/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.clip;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Observable;

public class ClippingData
extends Observable {
    public static final int DEC = 4;
    private Point2D ulWc = new Point2D.Double();
    private Point2D lrWc = new Point2D.Double();
    private Point2D llWc = new Point2D.Double();
    private Point2D urWc = new Point2D.Double();
    private Point2D ulPx = new Point2D.Double();
    private Point2D lrPx = new Point2D.Double();
    private Point2D llPx = new Point2D.Double();
    private Point2D urPx = new Point2D.Double();
    private double pxWidth = 0.0;
    private double pxHeight = 0.0;
    private double ratioWidthHeight = 0.0;
    private AffineTransform at = null;

    public void initSize() {
        this.pxHeight = Math.floor(this.getPxMaxY()) - Math.floor(this.getPxMinY()) + 1.0;
        this.pxWidth = Math.floor(this.getPxMaxX()) - Math.floor(this.getPxMinX()) + 1.0;
        this.ratioWidthHeight = this.pxWidth / this.pxHeight;
        this.updateObservers();
    }

    public void updateObservers() {
        this.setChanged();
        this.notifyObservers();
    }

    public void setOutOfArea() {
        this.ulWc = new Point2D.Double();
        this.lrWc = new Point2D.Double();
        this.urWc = new Point2D.Double();
        this.llWc = new Point2D.Double();
        this.ulPx = new Point2D.Double();
        this.lrPx = new Point2D.Double();
        this.llPx = new Point2D.Double();
        this.urPx = new Point2D.Double();
        this.pxWidth = 0.0;
        this.pxHeight = 0.0;
    }

    public double getRatio() {
        return this.getWcWidth() / this.getWcHeight();
    }

    public double getPxWidth() {
        return this.pxWidth;
    }

    public double getPxHeight() {
        return this.pxHeight;
    }

    public void setPxWidth(double pxw) {
        this.pxWidth = pxw;
    }

    public void setPxHeight(double pxh) {
        this.pxHeight = pxh;
    }

    public double getCellSize() {
        if (this.lrPx.getX() - this.ulPx.getX() + 1.0 == this.getPxWidth() && this.lrPx.getY() - this.ulPx.getY() + 1.0 == this.getPxHeight()) {
            return this.at != null ? this.at.getScaleX() : 0.0;
        }
        return Math.abs(this.ulWc.getX() - this.lrWc.getX()) / this.pxWidth;
    }

    public double getPxMaxX() {
        return Math.max(Math.max(this.ulPx.getX(), this.lrPx.getX()), Math.max(this.urPx.getX(), this.llPx.getX()));
    }

    public double getPxMaxY() {
        return Math.max(Math.max(this.ulPx.getY(), this.lrPx.getY()), Math.max(this.urPx.getY(), this.llPx.getY()));
    }

    public double getPxMinX() {
        return Math.min(Math.min(this.ulPx.getX(), this.lrPx.getX()), Math.min(this.llPx.getX(), this.urPx.getX()));
    }

    public double getPxMinY() {
        return Math.min(Math.min(this.ulPx.getY(), this.lrPx.getY()), Math.min(this.urPx.getY(), this.llPx.getY()));
    }

    public double getWcMaxX() {
        return Math.max(Math.max(this.ulWc.getX(), this.lrWc.getX()), Math.max(this.urWc.getX(), this.llWc.getX()));
    }

    public double getWcMaxY() {
        return Math.max(Math.max(this.ulWc.getY(), this.lrWc.getY()), Math.max(this.urWc.getY(), this.llWc.getY()));
    }

    public double getWcMinX() {
        return Math.min(Math.min(this.ulWc.getX(), this.lrWc.getX()), Math.min(this.llWc.getX(), this.urWc.getX()));
    }

    public double getWcMinY() {
        return Math.min(Math.min(this.ulWc.getY(), this.lrWc.getY()), Math.min(this.urWc.getY(), this.llWc.getY()));
    }

    public double getUlxWc() {
        return this.ulWc.getX();
    }

    public double getUlyWc() {
        return this.ulWc.getY();
    }

    public double getLlxWc() {
        return this.llWc.getX();
    }

    public double getLlyWc() {
        return this.llWc.getY();
    }

    public double getLrxWc() {
        return this.lrWc.getX();
    }

    public double getLryWc() {
        return this.lrWc.getY();
    }

    public double getUrxWc() {
        return this.urWc.getX();
    }

    public double getUryWc() {
        return this.urWc.getY();
    }

    public double getUlxPx() {
        return this.ulPx.getX();
    }

    public double getUlyPx() {
        return this.ulPx.getY();
    }

    public double getLlxPx() {
        return this.llPx.getX();
    }

    public double getLlyPx() {
        return this.llPx.getY();
    }

    public double getLrxPx() {
        return this.lrPx.getX();
    }

    public double getLryPx() {
        return this.lrPx.getY();
    }

    public double getUrxPx() {
        return this.urPx.getX();
    }

    public double getUryPx() {
        return this.urPx.getY();
    }

    public double getWcWidth() {
        return Math.abs(this.getWcMaxX() - this.getWcMinX());
    }

    public double getWcHeight() {
        return Math.abs(this.getWcMaxY() - this.getWcMinY());
    }

    public void setCoorReal(Point2D ul, Point2D lr, Point2D ll, Point2D ur) {
        this.ulWc = ul;
        this.lrWc = lr;
        this.llWc = ll;
        this.urWc = ur;
    }

    public void setCoorPixel(Point2D ul, Point2D lr, Point2D ll, Point2D ur) {
        this.ulPx = ul;
        this.lrPx = lr;
        this.llPx = ll;
        this.urPx = ur;
    }

    public void setUlxWc(double ulx) {
        this.ulWc = new Point2D.Double(ulx, this.ulWc.getY());
    }

    public void setLlxWc(double llx) {
        this.llWc = new Point2D.Double(llx, this.llWc.getY());
    }

    public void setUlyWc(double uly) {
        this.ulWc = new Point2D.Double(this.ulWc.getX(), uly);
    }

    public void setUryWc(double ury) {
        this.urWc = new Point2D.Double(this.urWc.getX(), ury);
    }

    public void setUlxPx(double ulx) {
        this.ulPx = new Point2D.Double(ulx, this.ulPx.getY());
    }

    public void setLlxPx(double llx) {
        this.llPx = new Point2D.Double(llx, this.llPx.getY());
    }

    public void setUlyPx(double uly) {
        this.ulPx = new Point2D.Double(this.ulPx.getX(), uly);
    }

    public void setUryPx(double ury) {
        this.urPx = new Point2D.Double(this.urPx.getX(), ury);
    }

    public void setLrxWc(double lrx) {
        this.lrWc = new Point2D.Double(lrx, this.lrWc.getY());
    }

    public void setLlyWc(double lly) {
        this.llWc = new Point2D.Double(this.llWc.getX(), lly);
    }

    public void setUrxWc(double urx) {
        this.urWc = new Point2D.Double(urx, this.urWc.getY());
    }

    public void setLryWc(double lry) {
        this.lrWc = new Point2D.Double(this.lrWc.getX(), lry);
    }

    public void setLrxPx(double lrx) {
        this.lrPx = new Point2D.Double(lrx, this.lrPx.getY());
    }

    public void setUrxPx(double urx) {
        this.urPx = new Point2D.Double(urx, this.urPx.getY());
    }

    public void setLryPx(double lry) {
        this.lrPx = new Point2D.Double(this.lrPx.getX(), lry);
    }

    public void setLlyPx(double lly) {
        this.llPx = new Point2D.Double(this.llPx.getX(), lly);
    }

    public void setAffineTransform(AffineTransform at) {
        this.at = at;
    }

    public double[] getWcCoordinatesToClip() {
        return new double[]{this.ulWc.getX(), this.ulWc.getY(), this.lrWc.getX(), this.lrWc.getY()};
    }

    public double[] getPxCoordinatesToClip() {
        return new double[]{this.ulPx.getX(), this.ulPx.getY(), this.lrPx.getX(), this.lrPx.getY()};
    }

    public double[] getPxSizeToClip() {
        return new double[]{this.getPxMaxX() - this.getPxMinX(), this.getPxMaxY() - this.getPxMinY()};
    }

    public Object clone() {
        ClippingData data = new ClippingData();
        data.ulWc = (Point2D)this.ulWc.clone();
        data.llWc = (Point2D)this.llWc.clone();
        data.lrWc = (Point2D)this.lrWc.clone();
        data.urWc = (Point2D)this.urWc.clone();
        data.ulPx = (Point2D)this.ulPx.clone();
        data.llPx = (Point2D)this.llPx.clone();
        data.lrPx = (Point2D)this.lrPx.clone();
        data.urPx = (Point2D)this.urPx.clone();
        data.pxWidth = this.pxWidth;
        data.pxHeight = this.pxHeight;
        data.ratioWidthHeight = this.ratioWidthHeight;
        if (this.at != null) {
            data.at = (AffineTransform)this.at.clone();
        }
        return data;
    }
}

