/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.clip.ui;

import java.awt.BorderLayout;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.util.RasterUtils;
import org.gvsig.gui.beans.datainput.DataInputContainerListener;
import org.gvsig.gui.beans.defaultbuttonspanel.DefaultButtonsPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.tools.app.basic.tool.clip.ClippingData;
import org.gvsig.raster.tools.app.basic.tool.clip.ui.ClippingDialog;
import org.gvsig.raster.tools.app.basic.tool.clip.ui.listener.ClippingPanelListener;
import org.gvsig.raster.tools.app.basic.tool.clip.ui.panel.ClippingCoordinatesPanel;
import org.gvsig.raster.tools.app.basic.tool.clip.ui.panel.ClippingOptionsPanel;
import org.gvsig.raster.tools.app.basic.tool.clip.ui.panel.ClippingResolutionPanel;
import org.gvsig.raster.tools.app.basic.tool.clip.ui.panel.ClippingSelectionPanel;

public class ClippingPanel
extends DefaultButtonsPanel
implements Observer {
    private static final long serialVersionUID = 3078196473228467834L;
    private ClippingDialog clippingDialog = null;
    private JTabbedPane jTabbedPane1 = null;
    private ClippingCoordinatesPanel coordinatesPanel = null;
    private ClippingResolutionPanel resolutionPanel = null;
    private ClippingSelectionPanel selectionPanel = null;
    private ClippingOptionsPanel optionsPanel = null;
    private ClippingPanelListener clippingPanelListener = null;
    double textWidth;
    double textHeight;

    public ClippingPanel(ClippingDialog clippingDialog) {
        super(3);
        this.getButtonsPanel().getButton(1).setEnabled(false);
        this.getButtonsPanel().getButton(3).setEnabled(false);
        this.clippingDialog = clippingDialog;
        this.initialize();
    }

    public void setClippingListener(ClippingPanelListener list) {
        this.clippingPanelListener = list;
        this.addListeners(this.clippingPanelListener);
        this.getCoordinatesPanel().setClippingListener(this.clippingPanelListener);
    }

    public ClippingPanelListener getListener() {
        return this.clippingPanelListener;
    }

    private void addListeners(ClippingPanelListener list) {
        this.getResolutionPanel().getCCellSize().addValueChangedListener((DataInputContainerListener)list);
        this.getResolutionPanel().getCWidth().addValueChangedListener((DataInputContainerListener)list);
        this.getResolutionPanel().getCHeight().addValueChangedListener((DataInputContainerListener)list);
        this.getResolutionPanel().getButtonRestore().addActionListener(list);
        this.addButtonPressedListener(list);
    }

    public ClippingDialog getClippingDialog() {
        return this.clippingDialog;
    }

    private void initialize() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jTabbedPane1.addTab(Messages.getText((String)"coordenadas_recorte"), this.getCoordinatesPanel());
        this.jTabbedPane1.addTab(Messages.getText((String)"resolucion_espacial"), this.getResolutionPanel());
        this.jTabbedPane1.addTab(Messages.getText((String)"seleccion_bandas"), this.getSelectionPanel());
        this.jTabbedPane1.addTab(Messages.getText((String)"otras_opciones"), this.getOptionsPanel());
        this.setLayout(new BorderLayout());
        this.add(this.jTabbedPane1, "Center");
    }

    public void removeTab(JPanel panel) {
        this.jTabbedPane1.remove(panel);
    }

    public ClippingCoordinatesPanel getCoordinatesPanel() {
        if (this.coordinatesPanel == null) {
            this.coordinatesPanel = new ClippingCoordinatesPanel();
        }
        return this.coordinatesPanel;
    }

    public ClippingResolutionPanel getResolutionPanel() {
        if (this.resolutionPanel == null) {
            this.resolutionPanel = new ClippingResolutionPanel();
            this.resolutionPanel.validate();
        }
        return this.resolutionPanel;
    }

    public ClippingSelectionPanel getSelectionPanel() {
        if (this.selectionPanel == null) {
            this.selectionPanel = new ClippingSelectionPanel();
        }
        return this.selectionPanel;
    }

    public ClippingOptionsPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new ClippingOptionsPanel();
        }
        return this.optionsPanel;
    }

    public void saveStatus(ClippingData data) {
        this.textWidth = data.getPxWidth();
        this.textHeight = data.getPxHeight();
    }

    public void restoreStatus(ClippingData data) {
        data.setPxWidth(this.textWidth);
        data.setPxHeight(this.textHeight);
        data.updateObservers();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!(o instanceof ClippingData)) {
            return;
        }
        ClippingData data = (ClippingData)o;
        this.clippingPanelListener.setEnableValueChangedEvent(false);
        this.getResolutionPanel().setWidthText(Math.round(data.getPxWidth()), 0);
        this.getResolutionPanel().setHeightText(Math.round(data.getPxHeight()), 0);
        RasterUtils util = RasterLocator.getManager().getRasterUtils();
        this.getCoordinatesPanel().setCoordReal(util.getCoord(data.getUlxWc(), data.getUlyWc(), data.getLrxWc(), data.getLryWc(), 4));
        this.getCoordinatesPanel().setCoordPixel(util.getCoord(data.getUlxPx(), data.getUlyPx(), data.getLrxPx(), data.getLryPx(), 4));
        this.getResolutionPanel().setCellSizeText(data.getCellSize(), 4);
        this.clippingPanelListener.setEnableValueChangedEvent(true);
    }
}

