/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.clip.ui.listener;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.EventObject;
import java.util.List;
import javax.swing.JOptionPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.Utilities;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.app.project.documents.view.toolListeners.StatusBarListener;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.ROIException;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.MouseMovementBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.RectangleBehavior;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.EnvelopeEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.RectangleListener;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelEvent;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelListener;
import org.gvsig.gui.beans.coordinatespanel.CoordinatesEvent;
import org.gvsig.gui.beans.coordinatespanel.CoordinatesListener;
import org.gvsig.gui.beans.coordinatespanel.CoordinatesPanel;
import org.gvsig.gui.beans.datainput.DataInputContainerListener;
import org.gvsig.gui.beans.table.models.CheckBoxModel;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.algorithm.process.IProcessActions;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.swing.RasterSwingLocator;
import org.gvsig.raster.tools.app.basic.RasterToolsUtil;
import org.gvsig.raster.tools.app.basic.raster.process.ClippingProcess;
import org.gvsig.raster.tools.app.basic.tool.clip.ClippingData;
import org.gvsig.raster.tools.app.basic.tool.clip.ui.ClippingPanel;
import org.gvsig.raster.tools.app.basic.tool.clip.ui.listener.ClippingMouseViewListener;
import org.gvsig.raster.tools.app.basic.tool.clip.ui.panel.ClippingCoordinatesPanel;
import org.gvsig.raster.tools.app.basic.tool.clip.ui.panel.ClippingOptionsPanel;
import org.gvsig.raster.tools.app.basic.tool.clip.ui.panel.ClippingResolutionPanel;
import org.gvsig.raster.tools.app.basic.tool.clip.ui.panel.ClippingSelectionPanel;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClippingPanelListener
implements ActionListener,
RectangleListener,
ButtonsPanelListener,
CoordinatesListener,
DataInputContainerListener,
IProcessActions {
    private static final Logger LOG = LoggerFactory.getLogger(ClippingPanelListener.class);
    private Dimension dim = new Dimension();
    private AffineTransform at = null;
    private ClippingPanel clippingPanel = null;
    private ClippingData data = null;
    private boolean enableValueChangedEvent = true;
    private FLyrRaster fLayer = null;
    private MapControl mapControl = null;
    private String lastTool = null;
    private String viewName = null;
    private static ClippingData lastDataSaved = null;

    public ClippingPanelListener(ClippingPanel clippingPanel) {
        this.clippingPanel = clippingPanel;
    }

    public void setData(ClippingData data) {
        this.data = data;
        if (this.fLayer != null) {
            data.setPxWidth((int)this.fLayer.getDataStore().getWidth());
            data.setPxHeight((int)this.fLayer.getDataStore().getHeight());
        }
    }

    private void setAffineTransform(AffineTransform at) {
        this.at = at;
    }

    public void setDimension(Dimension dim) {
        this.dim = dim;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getResolutionPanel().getButtonRestore()) {
            this.getClippingPanel().restoreStatus(this.data);
        }
        if (e.getSource() == this.getCoordinatesPanel().getButtonBarContainer().getButton(0)) {
            if (lastDataSaved != null) {
                this.data = (ClippingData)lastDataSaved.clone();
                this.data.addObserver(this.getClippingPanel());
                this.data.updateObservers();
                this.getClippingPanel().getButtonsPanel().getButton(3).setEnabled(true);
                this.getClippingPanel().getButtonsPanel().getButton(1).setEnabled(true);
            } else {
                RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"no_data_saved"), null);
            }
        }
        if (e.getSource() == this.getCoordinatesPanel().getButtonBarContainer().getButton(1)) {
            lastDataSaved = (ClippingData)this.data.clone();
        }
        if (e.getSource() == this.getCoordinatesPanel().getButtonBarContainer().getButton(2)) {
            this.roundPixels();
            return;
        }
        if (e.getSource() == this.getCoordinatesPanel().getButtonBarContainer().getButton(3)) {
            try {
                List roiList = this.getFLayer().getRois();
                if (roiList != null && roiList.size() > 0) {
                    Extent ext = RasterLocator.getManager().getRasterUtils().getROIsMaximunExtent(roiList);
                    this.assignROISExtent(ext, this.getFLayer());
                } else {
                    this.assignFullExtent();
                }
            }
            catch (ROIException e1) {
                RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"problems_loading_rois"), null);
            }
            return;
        }
        if (e.getSource() == this.getCoordinatesPanel().getButtonBarContainer().getButton(4)) {
            this.assignFullExtent();
            return;
        }
        if (e.getSource() == this.getCoordinatesPanel().getButtonBarContainer().getButton(5)) {
            this.selectToolButton();
            return;
        }
    }

    private void roundPixels() {
        this.data.setUlxPx((int)this.data.getUlxPx());
        this.data.setUlyPx((int)this.data.getUlyPx());
        this.data.setLrxPx((int)this.data.getLrxPx());
        this.data.setLryPx((int)this.data.getLryPx());
        this.data.setUrxPx((int)this.data.getUrxPx());
        this.data.setUryPx((int)this.data.getUryPx());
        this.data.setLlxPx((int)this.data.getLlxPx());
        this.data.setLlyPx((int)this.data.getLlyPx());
        Point2D.Double ulWc = new Point2D.Double();
        Point2D.Double lrWc = new Point2D.Double();
        Point2D.Double llWc = new Point2D.Double();
        Point2D.Double urWc = new Point2D.Double();
        this.at.transform(new Point2D.Double(this.data.getUlxPx(), this.data.getUlyPx()), ulWc);
        this.at.transform(new Point2D.Double(this.data.getLrxPx() + 1.0, this.data.getLryPx() + 1.0), lrWc);
        this.at.transform(new Point2D.Double(this.data.getLlxPx(), this.data.getLlyPx() + 1.0), llWc);
        this.at.transform(new Point2D.Double(this.data.getUrxPx() + 1.0, this.data.getUryPx()), urWc);
        this.data.setCoorReal(ulWc, lrWc, llWc, urWc);
        this.data.setAffineTransform(this.at);
        this.data.initSize();
        this.data.updateObservers();
    }

    private void assignROISExtent(Extent ext, FLyrRaster layer) {
        AffineTransform at = layer.getAffineTransform();
        Point2D ulWc = new Point2D.Double(ext.minX(), ext.maxY());
        Point2D lrWc = new Point2D.Double(ext.maxX(), ext.minY());
        Point2D llWc = new Point2D.Double(ext.minX(), ext.minY());
        Point2D urWc = new Point2D.Double(ext.maxX(), ext.maxY());
        ulWc = this.getFLayer().adjustWorldRequest(ulWc);
        lrWc = this.getFLayer().adjustWorldRequest(lrWc);
        llWc = this.getFLayer().adjustWorldRequest(llWc);
        urWc = this.getFLayer().adjustWorldRequest(urWc);
        Point2D.Double ulPx = new Point2D.Double();
        Point2D.Double lrPx = new Point2D.Double();
        Point2D.Double llPx = new Point2D.Double();
        Point2D.Double urPx = new Point2D.Double();
        try {
            at.inverseTransform(ulWc, ulPx);
            at.inverseTransform(lrWc, lrPx);
            at.inverseTransform(ulWc, llPx);
            at.inverseTransform(lrWc, urPx);
        }
        catch (NoninvertibleTransformException e) {
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), Messages.getText((String)"coordenadas_erroneas"));
            return;
        }
        this.data.setCoorPixel(ulPx, lrPx, llPx, urPx);
        this.data.setCoorReal(ulWc, lrWc, llWc, urWc);
        this.data.setAffineTransform(at);
        this.data.initSize();
        this.getClippingPanel().saveStatus(this.data);
        this.getClippingPanel().getButtonsPanel().getButton(3).setEnabled(true);
        this.getClippingPanel().getButtonsPanel().getButton(1).setEnabled(true);
    }

    private void assignFullExtent() {
        Point2D.Double ulPx = new Point2D.Double(0.0, 0.0);
        Point2D.Double lrPx = new Point2D.Double(this.dim.width, this.dim.height);
        Point2D.Double urPx = new Point2D.Double(this.dim.width, 0.0);
        Point2D.Double llPx = new Point2D.Double(0.0, this.dim.height);
        Point2D.Double ulWc = new Point2D.Double();
        Point2D.Double lrWc = new Point2D.Double();
        Point2D.Double urWc = new Point2D.Double();
        Point2D.Double llWc = new Point2D.Double();
        this.at.transform(ulPx, ulWc);
        this.at.transform(lrPx, lrWc);
        this.at.transform(urPx, urWc);
        this.at.transform(llPx, llWc);
        ulPx = new Point2D.Double(0.0, 0.0);
        lrPx = new Point2D.Double(this.dim.width - 1, this.dim.height - 1);
        urPx = new Point2D.Double(this.dim.width - 1, 0.0);
        llPx = new Point2D.Double(0.0, this.dim.height - 1);
        this.data.setCoorPixel(ulPx, lrPx, llPx, urPx);
        this.data.setCoorReal(ulWc, lrWc, llWc, urWc);
        this.data.setAffineTransform(this.at);
        this.data.initSize();
        this.getClippingPanel().saveStatus(this.data);
        this.getClippingPanel().getButtonsPanel().getButton(3).setEnabled(true);
        this.getClippingPanel().getButtonsPanel().getButton(1).setEnabled(true);
    }

    private void eventJTextField(CoordinatesEvent e) {
        try {
            if (e.getSource() == this.getCoordinatesPanel().getPixelCoordinates()) {
                if (e.getName().equals("11")) {
                    this.data.setUlxPx(Double.valueOf(this.getCoordinatesPanel().getPixelCoordinates().getValue11()));
                    this.data.setLlxPx(Double.valueOf(this.getCoordinatesPanel().getPixelCoordinates().getValue11()));
                }
                if (e.getName().equals("12")) {
                    this.data.setUlyPx(Double.valueOf(this.getCoordinatesPanel().getPixelCoordinates().getValue12()));
                    this.data.setUryPx(Double.valueOf(this.getCoordinatesPanel().getPixelCoordinates().getValue12()));
                }
                if (e.getName().equals("21")) {
                    this.data.setLrxPx(Double.valueOf(this.getCoordinatesPanel().getPixelCoordinates().getValue21()));
                    this.data.setUrxPx(Double.valueOf(this.getCoordinatesPanel().getPixelCoordinates().getValue21()));
                }
                if (e.getName().equals("22")) {
                    this.data.setLryPx(Double.valueOf(this.getCoordinatesPanel().getPixelCoordinates().getValue22()));
                    this.data.setLlyPx(Double.valueOf(this.getCoordinatesPanel().getPixelCoordinates().getValue22()));
                }
                this.data.updateObservers();
            }
            if (e.getSource() == this.getCoordinatesPanel().getRealCoordinates()) {
                if (e.getName().equals("11")) {
                    this.data.setUlxWc(Double.valueOf(this.getCoordinatesPanel().getRealCoordinates().getValue11()));
                    this.data.setLlxWc(Double.valueOf(this.getCoordinatesPanel().getRealCoordinates().getValue11()));
                }
                if (e.getName().equals("12")) {
                    this.data.setUlyWc(Double.valueOf(this.getCoordinatesPanel().getRealCoordinates().getValue12()));
                    this.data.setUryWc(Double.valueOf(this.getCoordinatesPanel().getRealCoordinates().getValue12()));
                }
                if (e.getName().equals("21")) {
                    this.data.setLrxWc(Double.valueOf(this.getCoordinatesPanel().getRealCoordinates().getValue21()));
                    this.data.setUrxWc(Double.valueOf(this.getCoordinatesPanel().getRealCoordinates().getValue21()));
                }
                if (e.getName().equals("22")) {
                    this.data.setLryWc(Double.valueOf(this.getCoordinatesPanel().getRealCoordinates().getValue22()));
                    this.data.setLlyWc(Double.valueOf(this.getCoordinatesPanel().getRealCoordinates().getValue22()));
                }
                this.data.updateObservers();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void recalcCoordFields(boolean modifyPx) {
        try {
            Point2D.Double ulPx = new Point2D.Double(this.data.getUlxPx(), this.data.getUlyPx());
            Point2D.Double lrPx = new Point2D.Double(this.data.getLrxPx(), this.data.getLryPx());
            Point2D.Double llPx = new Point2D.Double(this.data.getLlxPx(), this.data.getLlyPx());
            Point2D.Double urPx = new Point2D.Double(this.data.getUrxPx(), this.data.getUryPx());
            Point2D.Double ulWc = new Point2D.Double(this.data.getUlxWc(), this.data.getUlyWc());
            Point2D.Double lrWc = new Point2D.Double(this.data.getLrxWc(), this.data.getLryWc());
            Point2D.Double llWc = new Point2D.Double(this.data.getLlxWc(), this.data.getLlyWc());
            Point2D.Double urWc = new Point2D.Double(this.data.getUrxWc(), this.data.getUryWc());
            if (modifyPx) {
                this.at.transform(new Point2D.Double(((Point2D)ulPx).getX(), ((Point2D)ulPx).getY()), ulWc);
                this.at.transform(new Point2D.Double(((Point2D)lrPx).getX() + 1.0, ((Point2D)lrPx).getY() + 1.0), lrWc);
                this.at.transform(new Point2D.Double(((Point2D)llPx).getX(), ((Point2D)llPx).getY() + 1.0), llWc);
                this.at.transform(new Point2D.Double(((Point2D)urPx).getX() + 1.0, ((Point2D)urPx).getY()), urWc);
                this.data.setCoorReal(ulWc, lrWc, llWc, urWc);
                this.data.setAffineTransform(this.at);
                this.data.initSize();
                this.getClippingPanel().saveStatus(this.data);
            } else {
                try {
                    this.at.inverseTransform(ulWc, ulPx);
                    this.at.inverseTransform(lrWc, lrPx);
                    this.at.inverseTransform(llWc, llPx);
                    this.at.inverseTransform(urWc, urPx);
                }
                catch (NoninvertibleTransformException e) {
                    JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"coordenadas_erroneas"));
                    return;
                }
                lrPx = new Point2D.Double(((Point2D)lrPx).getX() - 1.0, ((Point2D)lrPx).getY() - 1.0);
                llPx = new Point2D.Double(((Point2D)llPx).getX(), ((Point2D)llPx).getY() - 1.0);
                urPx = new Point2D.Double(((Point2D)urPx).getX() - 1.0, ((Point2D)urPx).getY());
                this.data.setCoorPixel(ulPx, lrPx, llPx, urPx);
                this.data.setAffineTransform(this.at);
                this.data.initSize();
                this.getClippingPanel().saveStatus(this.data);
            }
            if (this.activeButtons(ulPx, lrPx, ulWc, lrWc)) {
                this.getClippingPanel().getButtonsPanel().getButton(3).setEnabled(true);
                this.getClippingPanel().getButtonsPanel().getButton(1).setEnabled(true);
            } else {
                this.getClippingPanel().getButtonsPanel().getButton(3).setEnabled(false);
                this.getClippingPanel().getButtonsPanel().getButton(1).setEnabled(false);
            }
        }
        catch (NumberFormatException ex) {
            return;
        }
    }

    public boolean activeButtons(Point2D ulPx, Point2D lrPx, Point2D ulWc, Point2D lrWc) {
        return ulPx.getX() < lrPx.getX() && ulPx.getY() < lrPx.getY() && ulWc.getX() < lrWc.getX() && ulWc.getY() > lrWc.getY() && lrPx.getX() - ulPx.getX() >= 2.0 && lrPx.getY() - ulPx.getY() >= 2.0 && ulPx.getX() >= 0.0 && ulPx.getY() >= 0.0 && (double)((int)lrPx.getX()) <= this.fLayer.getDataStore().getWidth() - 1.0 && (double)((int)lrPx.getY()) <= this.fLayer.getDataStore().getHeight() - 1.0;
    }

    private void adjustPoints(Point2D ul, Point2D lr) {
        double a = ul.getX() - (double)((int)ul.getX());
        double b = ul.getY() - (double)((int)ul.getY());
        double c = lr.getX() - (double)((int)lr.getX());
        double d = lr.getY() - (double)((int)lr.getY());
        ul.setLocation(a > 0.95 || a < 0.05 ? (double)Math.round(ul.getX()) : ul.getX(), b > 0.95 || b < 0.05 ? (double)Math.round(ul.getY()) : ul.getY());
        lr.setLocation(c > 0.95 || c < 0.05 ? (double)Math.round(lr.getX()) : lr.getX(), d > 0.95 || d < 0.05 ? (double)Math.round(lr.getY()) : lr.getY());
    }

    private Point2D adjustPixelRequest(Point2D req) {
        req.setLocation(Math.max(0.0, req.getX()), Math.max(0.0, req.getY()));
        req.setLocation(Math.min((double)(this.dim.width - 1), req.getX()), Math.min((double)(this.dim.height - 1), req.getY()));
        return req;
    }

    public void actionButtonPressed(ButtonsPanelEvent e) {
        if (e.getButton() == 1) {
            this.accept();
            this.close();
        }
        if (e.getButton() == 3) {
            this.accept();
        }
        if (e.getButton() == 2) {
            this.close();
        }
        this.getFLayer().getMapContext().invalidate();
    }

    private void close() {
        try {
            if (this.getLastTool() != null) {
                this.getMapControl().setTool(this.getLastTool());
            }
            PluginServices.getMDIManager().closeWindow((IWindow)this.getClippingPanel().getClippingDialog());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private ClippingPanel getClippingPanel() {
        return this.clippingPanel;
    }

    private ClippingCoordinatesPanel getCoordinatesPanel() {
        return this.getClippingPanel().getCoordinatesPanel();
    }

    private ClippingResolutionPanel getResolutionPanel() {
        return this.getClippingPanel().getResolutionPanel();
    }

    private ClippingOptionsPanel getOptionsPanel() {
        return this.getClippingPanel().getOptionsPanel();
    }

    private ClippingSelectionPanel getSelectionPanel() {
        return this.getClippingPanel().getSelectionPanel();
    }

    private void accept() {
        String filename;
        String file;
        String path;
        if (this.data.getPxHeight() == 0.0 || this.data.getPxWidth() == 0.0) {
            RasterSwingLibrary.messageBoxError((String)RasterToolsUtil.getText(this, "wrong_resolution"), null);
            return;
        }
        CoordinatesPanel coordinatesReales = this.getCoordinatesPanel().getRealCoordinates();
        double ulx = 0.0;
        double lrx = 0.0;
        double lry = 0.0;
        double uly = 0.0;
        try {
            ulx = Double.parseDouble(coordinatesReales.getValue11());
            lry = Double.parseDouble(coordinatesReales.getValue22());
            lrx = Double.parseDouble(coordinatesReales.getValue21());
            uly = Double.parseDouble(coordinatesReales.getValue12());
            Envelope ext = this.getFLayer().getFullEnvelope();
            if ((int)ulx > (int)ext.getMaximum(0) || (int)lrx < (int)ext.getMinimum(0) || (int)uly > (int)ext.getMaximum(1) || (int)lry < (int)ext.getMinimum(1)) {
                RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"coordenadas_erroneas"), null);
                return;
            }
        }
        catch (NumberFormatException e) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"coordenadas_erroneas"), null);
            return;
        }
        int countBands = 0;
        int rowCount = ((CheckBoxModel)this.getSelectionPanel().getTableContainer().getModel()).getRowCount();
        for (int iRow = 0; iRow < rowCount; ++iRow) {
            if (!((Boolean)((CheckBoxModel)this.getSelectionPanel().getTableContainer().getModel()).getValueAt(iRow, 0)).booleanValue()) continue;
            ++countBands;
        }
        int[] drawableBands = new int[countBands];
        int i = 0;
        for (int iRow = 0; iRow < rowCount; ++iRow) {
            if (!((Boolean)((CheckBoxModel)this.getSelectionPanel().getTableContainer().getModel()).getValueAt(iRow, 0)).booleanValue()) continue;
            int row = (Integer)((CheckBoxModel)this.getSelectionPanel().getTableContainer().getModel()).getValueAt(iRow, 2);
            drawableBands[i++] = row;
        }
        if (this.getOptionsPanel().getCbSaveFile().isSelected()) {
            path = this.getOptionsPanel().getDirectoryTextField().getText();
            File f = new File(path);
            if (!f.exists() || !f.canWrite()) {
                RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"path_not_valid"), null);
                return;
            }
        } else {
            path = Utilities.createTempDirectory();
        }
        if ((file = this.getOptionsPanel().getFilenameTextField().getText()).compareTo(RasterLocator.getManager().getFileUtils().getOnlyLayerName()) == 0) {
            RasterLocator.getManager().getFileUtils().usesOnlyLayerName();
        }
        if (file == "") {
            file = "cutlayer";
        }
        if (new File((filename = path + File.separator + file) + ".tif").exists() && !RasterSwingLibrary.messageBoxYesOrNot((String)"raster_error_file_exists", (Object)this.getOptionsPanel())) {
            return;
        }
        if (this.getFLayer() == null) {
            return;
        }
        double[] pxValues = this.data.getPxCoordinatesToClip();
        boolean pxRound = this.arePixelsRound(pxValues);
        double[] wcValues = this.data.getWcCoordinatesToClip();
        if (this.getFLayer().getCoordTrans() != null) {
            GeometryManager geometryManager = GeometryLocator.getGeometryManager();
            Envelope envelope = null;
            Envelope storeEnvelope = null;
            Envelope projectedEnvelope = null;
            Extent extent = this.getFLayer().getDataStore().getExtent();
            try {
                envelope = geometryManager.createEnvelope(wcValues[0], wcValues[3], wcValues[2], wcValues[1], 0);
            }
            catch (CreateEnvelopeException e) {
                String errorMessage = String.format("Can not create envelope with [%1d,%1d,%1d,%1d,%1s] parameters", wcValues[0], wcValues[3], wcValues[2], wcValues[1], 0);
                LOG.error(errorMessage, (Throwable)e);
                ThreadSafeDialogsManager tsdm = ToolsSwingLocator.getThreadSafeDialogsManager();
                tsdm.messageDialog("error_cutting", "_error", 0);
                return;
            }
            try {
                storeEnvelope = geometryManager.createEnvelope(extent.getMin().getX(), extent.getMin().getY(), extent.getMax().getX(), extent.getMax().getY(), 0);
            }
            catch (CreateEnvelopeException e) {
                String errorMessage = String.format("Can not create envelope with [%1d,%1d,%1d,%1d,%1s] parameters", extent.getMin().getX(), extent.getMin().getY(), extent.getMax().getX(), extent.getMax().getY(), 0);
                LOG.error(errorMessage, (Throwable)e);
                ThreadSafeDialogsManager tsdm = ToolsSwingLocator.getThreadSafeDialogsManager();
                tsdm.messageDialog("error_cutting", "_error", 0);
                return;
            }
            projectedEnvelope = envelope.convert(this.getFLayer().getCoordTrans().getInverted());
            try {
                Geometry intersection = projectedEnvelope.getGeometry().intersection(storeEnvelope.getGeometry());
                projectedEnvelope = geometryManager.createEnvelope(0);
                projectedEnvelope.add(intersection);
            }
            catch (GeometryOperationException | GeometryOperationNotSupportedException e) {
                String errorMessage = String.format("Can not intersects [%1s] projected envelope with [%1s] store envelope", projectedEnvelope, storeEnvelope);
                LOG.error(errorMessage, e);
                ThreadSafeDialogsManager tsdm = ToolsSwingLocator.getThreadSafeDialogsManager();
                tsdm.messageDialog("error_cutting", "_error", 0);
                return;
            }
            catch (CreateEnvelopeException e) {
                String errorMessage = String.format("Can not create envelope with [%1s] parameters", 0);
                LOG.error(errorMessage, (Throwable)e);
                ThreadSafeDialogsManager tsdm = ToolsSwingLocator.getThreadSafeDialogsManager();
                tsdm.messageDialog("error_cutting", "_error", 0);
                return;
            }
            wcValues[0] = projectedEnvelope.getLowerCorner().getX();
            wcValues[3] = projectedEnvelope.getLowerCorner().getY();
            wcValues[2] = projectedEnvelope.getUpperCorner().getX();
            wcValues[1] = projectedEnvelope.getUpperCorner().getY();
        }
        AffineTransform transf = null;
        transf = pxRound && pxValues[2] - pxValues[0] == this.data.getPxWidth() && pxValues[3] - pxValues[1] == this.data.getPxHeight() ? new AffineTransform(this.at.getScaleX(), this.at.getShearY(), this.at.getShearX(), this.at.getScaleY(), wcValues[0], wcValues[1]) : this.calcAffineTransform(wcValues[0], wcValues[1], wcValues[2], wcValues[3], Math.round(this.data.getPxWidth()), Math.round(this.data.getPxHeight()), this.at);
        int interpMethod = this.getResolutionPanel().getSelectedInterpolationMethod();
        String[] ci = new String[drawableBands.length];
        block16: for (int j = 0; j < ci.length; ++j) {
            switch (j) {
                case 0: {
                    if (ci.length >= 3) {
                        ci[j] = "Red";
                        continue block16;
                    }
                    ci[j] = "Gray";
                    continue block16;
                }
                case 1: {
                    if (ci.length >= 3) {
                        ci[j] = "Green";
                        continue block16;
                    }
                    ci[j] = "Undefined";
                    continue block16;
                }
                case 2: {
                    ci[j] = "Blue";
                    continue block16;
                }
                default: {
                    ci[j] = "Undefined";
                }
            }
        }
        ClippingProcess clippingProcess = new ClippingProcess();
        clippingProcess.setActions(this);
        clippingProcess.addParam("viewname", this.getViewName());
        if (pxRound) {
            clippingProcess.addParam("pixelcoordinates", pxValues);
        } else {
            clippingProcess.addParam("realcoordinates", wcValues);
        }
        clippingProcess.addParam("suffix", ".tif");
        clippingProcess.addParam("filename", filename);
        clippingProcess.addParam("layer", this.getFLayer().getDataStore());
        clippingProcess.addParam("drawablebands", drawableBands);
        clippingProcess.addParam("onelayerperband", new Boolean(this.getOptionsPanel().getCbOneLyrPerBand().isSelected()));
        clippingProcess.addParam("interpolationmethod", new Integer(interpMethod));
        clippingProcess.addParam("affinetransform", transf);
        clippingProcess.addParam("colorInterpretation", RasterLocator.getManager().getDataStructFactory().createColorInterpretation(ci));
        clippingProcess.addParam("resolution", new int[]{(int)Math.round(this.data.getPxWidth()), (int)Math.round(this.data.getPxHeight())});
        clippingProcess.addParam("viewProjection", this.mapControl.getProjection());
        clippingProcess.start();
    }

    private AffineTransform calcAffineTransform(double ulx, double uly, double lrx, double lry, double width, double height, AffineTransform trans) {
        Point2D.Double ul = new Point2D.Double(ulx, uly);
        Point2D.Double lr = new Point2D.Double(lrx, lry);
        try {
            trans.inverseTransform(ul, ul);
            trans.inverseTransform(lr, lr);
        }
        catch (NoninvertibleTransformException e) {
            JOptionPane.showMessageDialog(null, RasterToolsUtil.getText(this, "coordenadas_erroneas"));
            return new AffineTransform();
        }
        double w = Math.abs(((Point2D)lr).getX() - ((Point2D)ul).getX());
        Point2D.Double ur = new Point2D.Double(((Point2D)ul).getX() + w, ((Point2D)ul).getY());
        Point2D.Double ll = new Point2D.Double(((Point2D)lr).getX() - w, ((Point2D)lr).getY());
        trans.transform(ul, ul);
        trans.transform(ur, ur);
        trans.transform(lr, lr);
        trans.transform(ll, ll);
        double pixelSizeX = (lrx - ulx) / width;
        double pixelSizeY = (lry - uly) / height;
        double rotX = trans.getShearX();
        double rotY = trans.getShearY();
        return new AffineTransform(pixelSizeX, rotY, rotX, pixelSizeY, ulx, uly);
    }

    private boolean arePixelsRound(double[] pxValues) {
        return (double)((int)pxValues[0]) - pxValues[0] == 0.0 && (double)((int)pxValues[1]) - pxValues[1] == 0.0 && (double)((int)pxValues[2]) - pxValues[2] == 0.0 && (double)((int)pxValues[3]) - pxValues[3] == 0.0;
    }

    public boolean cancelDrawing() {
        return false;
    }

    public Cursor getCursor() {
        return null;
    }

    public void actionValueChanged(CoordinatesEvent e) {
        if (e.getSource() == this.getCoordinatesPanel().getPixelCoordinates()) {
            this.eventJTextField(e);
            if (e.getName().equals("11") || e.getName().equals("12") || e.getName().equals("21") || e.getName().equals("22")) {
                this.recalcCoordFields(true);
            }
        }
        if (e.getSource() == this.getCoordinatesPanel().getRealCoordinates()) {
            this.eventJTextField(e);
            if (e.getName().equals("11") || e.getName().equals("12") || e.getName().equals("21") || e.getName().equals("22")) {
                this.recalcCoordFields(false);
            }
        }
    }

    public void actionValueChanged(EventObject e) {
        if (!this.enableValueChangedEvent) {
            return;
        }
        this.enableValueChangedEvent = false;
        if (e.getSource() == this.getResolutionPanel().getCCellSize().getDataInputField()) {
            double ps = 0.0;
            try {
                ps = Double.parseDouble(this.getResolutionPanel().getCCellSize().getValue());
            }
            catch (NumberFormatException ex) {
                return;
            }
            this.data.setPxWidth(this.data.getWcWidth() / ps);
            this.data.setPxHeight(this.data.getWcHeight() / ps);
            this.data.updateObservers();
        } else if (e.getSource() == this.getResolutionPanel().getCWidth().getDataInputField()) {
            double wPx = 0.0;
            try {
                wPx = Double.parseDouble(this.getResolutionPanel().getCWidth().getValue());
            }
            catch (NumberFormatException ex) {
                return;
            }
            this.data.setPxWidth(wPx);
            this.data.setPxHeight(Math.round(wPx / this.data.getRatio()));
            this.data.updateObservers();
        } else if (e.getSource() == this.getResolutionPanel().getCHeight().getDataInputField()) {
            double hPx = 0.0;
            try {
                hPx = Double.parseDouble(this.getResolutionPanel().getCHeight().getValue());
            }
            catch (NumberFormatException ex) {
                return;
            }
            this.data.setPxHeight(hPx);
            this.data.setPxWidth(Math.round(Math.round(hPx * this.data.getRatio())));
            this.data.updateObservers();
        }
        this.enableValueChangedEvent = true;
    }

    public void setEnableValueChangedEvent(boolean enableValueChangedEvent) {
        this.enableValueChangedEvent = enableValueChangedEvent;
    }

    public void end(Object params) {
        if (params instanceof Object[] && ((Object[])params).length == 2 && ((Object[])params)[0] instanceof String && ((Object[])params)[1] instanceof Long) {
            String fName = (String)((Object[])params)[0];
            long milis = (Long)((Object[])params)[1];
            RasterSwingLocator.getSwingManager().showSummaryProcessDialog(fName, milis);
        }
    }

    public FLyrRaster getFLayer() {
        return this.fLayer;
    }

    public String getLastTool() {
        return this.lastTool;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setLayer(FLyrRaster fLayer) {
        this.fLayer = fLayer;
        AbstractViewPanel view = (AbstractViewPanel)PluginServices.getMDIManager().getActiveWindow();
        this.viewName = PluginServices.getMDIManager().getWindowInfo((IWindow)view).getTitle();
        this.mapControl = view.getMapControl();
        this.lastTool = this.mapControl.getCurrentTool();
        StatusBarListener sbl = new StatusBarListener(this.mapControl);
        ClippingMouseViewListener clippingMouseViewListener = new ClippingMouseViewListener(this.mapControl, this.getClippingPanel(), this.data, fLayer);
        this.mapControl.addBehavior("cutRaster", new Behavior[]{new RectangleBehavior((RectangleListener)clippingMouseViewListener), new MouseMovementBehavior((PointListener)sbl)});
        this.getSelectionPanel().setLayer(fLayer);
        this.setAffineTransform(fLayer.getAffineTransform());
        this.setDimension(new Dimension((int)fLayer.getDataStore().getWidth(), (int)fLayer.getDataStore().getHeight()));
        if (this.getFLayer().isRemote()) {
            this.getResolutionPanel().getComboInterpolation().setEnabled(false);
            this.getClippingPanel().removeTab(this.getSelectionPanel());
            this.getCoordinatesPanel().getPixelCoordinates().setVisible(false);
        }
    }

    public void selectToolButton() {
        AbstractViewPanel theView = null;
        try {
            IWindow[] allViews = PluginServices.getMDIManager().getAllWindows();
            for (int i = 0; i < allViews.length; ++i) {
                if (!(allViews[i] instanceof AbstractViewPanel) || !PluginServices.getMDIManager().getWindowInfo((IWindow)((AbstractViewPanel)allViews[i])).getTitle().equals(this.viewName)) continue;
                theView = (AbstractViewPanel)allViews[i];
            }
            if (theView == null) {
                return;
            }
        }
        catch (ClassCastException ex) {
            return;
        }
        MapControl m_MapControl = theView.getMapControl();
        m_MapControl.setTool("clipRaster");
    }

    public MapControl getMapControl() {
        return this.mapControl;
    }

    public void rectangle(EnvelopeEvent event) throws BehaviorException {
    }

    public void interrupted() {
    }

    public Image getImageCursor() {
        return null;
    }

    public void updateProgress(int current, int total) {
    }
}

