/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.clip.ui.panel;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.gvsig.gui.beans.datainput.DataInputContainer;
import org.gvsig.i18n.Messages;

public class ClippingResolutionPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 2570616093263451091L;
    private JPanel pButtons = null;
    private DataInputContainer cCellSize = null;
    private DataInputContainer cHeight = null;
    private DataInputContainer cWidth = null;
    private JRadioButton rSize = null;
    private JRadioButton rWidthH = null;
    private JComboBox cInterpolation = null;
    private JButton buttonRestore = null;

    public ClippingResolutionPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 8, 6, 8);
        this.add((Component)this.getPButtons(), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this.getComboInterpolation(), gridBagConstraints);
        JLabel jLabel = new JLabel();
        jLabel.setText(Messages.getText((String)"interpolacion") + ":");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.getCCellSize(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.getCWidth(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.getCHeight(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        this.add((Component)this.getButtonRestore(), gridBagConstraints);
        this.getRSize().addActionListener(this);
        this.getRWidthH().addActionListener(this);
        this.getRSize().setSelected(true);
        this.getCWidth().setControlEnabled(false);
        this.getCHeight().setControlEnabled(false);
    }

    public DataInputContainer getCCellSize() {
        if (this.cCellSize == null) {
            this.cCellSize = new DataInputContainer();
            this.cCellSize.setLabelText(Messages.getText((String)"celda"));
        }
        return this.cCellSize;
    }

    public DataInputContainer getCHeight() {
        if (this.cHeight == null) {
            this.cHeight = new DataInputContainer();
            this.cHeight.setLabelText(Messages.getText((String)"alto"));
        }
        return this.cHeight;
    }

    public JButton getButtonRestore() {
        if (this.buttonRestore == null) {
            this.buttonRestore = new JButton(Messages.getText((String)"restablecer"));
        }
        return this.buttonRestore;
    }

    public DataInputContainer getCWidth() {
        if (this.cWidth == null) {
            this.cWidth = new DataInputContainer();
            this.cWidth.setLabelText(Messages.getText((String)"ancho"));
        }
        return this.cWidth;
    }

    private JPanel getPButtons() {
        if (this.pButtons == null) {
            this.pButtons = new JPanel();
            this.pButtons.setLayout(new GridBagLayout());
            this.pButtons.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"resolution_method_selection"), 0, 0, new Font("Dialog", 0, 12), null)));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            this.pButtons.add((Component)this.getRSize(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints.anchor = 17;
            this.pButtons.add((Component)this.getRWidthH(), gridBagConstraints);
        }
        return this.pButtons;
    }

    private JRadioButton getRSize() {
        if (this.rSize == null) {
            this.rSize = new JRadioButton(Messages.getText((String)"tamanyo_celda"));
        }
        return this.rSize;
    }

    private JRadioButton getRWidthH() {
        if (this.rWidthH == null) {
            this.rWidthH = new JRadioButton(Messages.getText((String)"ancho_x_alto"));
        }
        return this.rWidthH;
    }

    public JComboBox getComboInterpolation() {
        if (this.cInterpolation == null) {
            this.cInterpolation = new JComboBox();
            this.cInterpolation.addItem(Messages.getText((String)"vecino_+_proximo"));
            this.cInterpolation.addItem(Messages.getText((String)"bilinear"));
            this.cInterpolation.addItem(Messages.getText((String)"distancia_inversa"));
            this.cInterpolation.addItem(Messages.getText((String)"b_splines"));
        }
        return this.cInterpolation;
    }

    public int getSelectedInterpolationMethod() {
        switch (this.getComboInterpolation().getSelectedIndex()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 5;
            }
        }
        return 0;
    }

    public void setCellSizeText(double cellSize, int dec) {
        int indexPoint = String.valueOf(cellSize).indexOf(46);
        try {
            this.cCellSize.setValue(String.valueOf(cellSize).substring(0, indexPoint + dec));
        }
        catch (StringIndexOutOfBoundsException ex) {
            this.cCellSize.setValue(String.valueOf(cellSize));
        }
        catch (NumberFormatException ex) {
            this.cCellSize.setValue(String.valueOf(cellSize));
        }
    }

    public void setWidthText(double width, int dec) {
        int indexPoint = String.valueOf(width).indexOf(46);
        try {
            this.cWidth.setValue(String.valueOf(width).substring(0, indexPoint + dec));
        }
        catch (StringIndexOutOfBoundsException ex) {
            this.cWidth.setValue(String.valueOf(width));
        }
        catch (NumberFormatException ex) {
            this.cWidth.setValue(String.valueOf(width));
        }
    }

    public void setHeightText(double height, int dec) {
        int indexPoint = String.valueOf(height).indexOf(46);
        try {
            this.cHeight.setValue(String.valueOf(height).substring(0, indexPoint + dec));
        }
        catch (StringIndexOutOfBoundsException ex) {
            this.cHeight.setValue(String.valueOf(height));
        }
        catch (NumberFormatException ex) {
            this.cHeight.setValue(String.valueOf(height));
        }
    }

    public double getCellSizeText() {
        return Double.parseDouble(this.cCellSize.getValue());
    }

    public double getWidthText() {
        return Double.parseDouble(this.cWidth.getValue());
    }

    public double getHeightText() {
        return Double.parseDouble(this.cHeight.getValue());
    }

    public String[] getWidthHeight() {
        String[] text = new String[]{this.cWidth.getValue(), this.cHeight.getValue()};
        return text;
    }

    public String getInterpolation() {
        return (String)this.getComboInterpolation().getSelectedItem();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getRSize()) {
            this.getRSize().setSelected(true);
            this.getRWidthH().setSelected(false);
            this.cCellSize.setControlEnabled(true);
            this.cHeight.setControlEnabled(false);
            this.cWidth.setControlEnabled(false);
        }
        if (e.getSource() == this.getRWidthH()) {
            this.getRWidthH().setSelected(true);
            this.getRSize().setSelected(false);
            this.cCellSize.setControlEnabled(false);
            this.cHeight.setControlEnabled(true);
            this.cWidth.setControlEnabled(true);
        }
    }
}

