/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.enhanced.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelListener;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.mainplugin.beans.createlayer.CreateLayerPanel;
import org.gvsig.raster.swing.RasterSwingLocator;
import org.gvsig.raster.swing.preview.DataSourcePreview;
import org.gvsig.raster.swing.preview.PreviewPanel;
import org.gvsig.raster.swing.preview.PreviewRenderProcess;
import org.gvsig.raster.tools.app.basic.raster.bean.previewbase.RasterDataSourcePreview;
import org.gvsig.raster.tools.app.basic.tool.enhanced.ui.EnhancedListener;
import org.gvsig.raster.tools.app.basic.tool.enhanced.ui.GraphicsPanel;
import org.gvsig.raster.tools.app.basic.tool.enhanced.ui.PreviewFiltering;
import org.gvsig.raster.tools.app.basic.tool.enhanced.ui.SelectorsPanel;

public class EnhancedDialog
extends JPanel
implements IWindow {
    private static final long serialVersionUID = -5374834293534046986L;
    private PreviewPanel previewBasePanel = null;
    private GraphicsPanel graphicsPanel = null;
    private FLyrRaster lyr = null;
    private PreviewFiltering filteredPreview = null;
    private SelectorsPanel controlsPanel = null;
    private CreateLayerPanel layerPanel = null;
    private String viewName = null;
    private EnhancedListener listener = null;

    public EnhancedDialog(FLyrRaster lyr, int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
        this.setSize(width, height);
        this.setLayout(new BorderLayout(5, 5));
        this.lyr = lyr;
        this.graphicsPanel = new GraphicsPanel(this.lyr);
        this.filteredPreview = new PreviewFiltering(false);
        this.filteredPreview.setFilterStatus(this.lyr.getRender().getFilterList().getStatusCloned());
        this.controlsPanel = new SelectorsPanel(this.lyr, this.graphicsPanel.getInputHistogram());
        this.add((Component)this.getPreviewBasePanel(), "Center");
        this.listener = new EnhancedListener(this.controlsPanel, this.graphicsPanel, this, this.filteredPreview);
        this.listener.firstLoad();
        this.graphicsPanel.setListener(this.listener);
        this.graphicsPanel.updateHistogram();
        this.listener.updatePreview();
        IWindow window = PluginServices.getMDIManager().getActiveWindow();
        if (window instanceof AbstractViewPanel) {
            AbstractViewPanel view = (AbstractViewPanel)window;
            this.viewName = PluginServices.getMDIManager().getWindowInfo((IWindow)view).getTitle();
        }
        this.getPreviewBasePanel().getButtonsPanel().addButtonPressedListener((ButtonsPanelListener)this.listener);
        this.previewBasePanel.refreshPreview();
    }

    public PreviewPanel getPreviewBasePanel() {
        if (this.previewBasePanel == null) {
            ArrayList<GraphicsPanel> list = new ArrayList<GraphicsPanel>();
            list.add(this.graphicsPanel);
            JPanel downPreview = new JPanel();
            this.getNewOrSaveLayerPanel().setLabelFilename("");
            downPreview.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            downPreview.add((Component)this.getNewOrSaveLayerPanel().getJPanel(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            downPreview.add((Component)this.getNewOrSaveLayerPanel().getFileNamePanel(), gridBagConstraints);
            IProjection viewProj = null;
            if (this.lyr.getMapContext() != null) {
                viewProj = this.lyr.getMapContext().getProjection();
            }
            RasterDataSourcePreview dataSourcePreview = new RasterDataSourcePreview(this.lyr, viewProj);
            this.previewBasePanel = RasterSwingLocator.getSwingManager().createPreviewPanel(9, list, (JPanel)this.controlsPanel, downPreview, (PreviewRenderProcess)this.filteredPreview, (DataSourcePreview)dataSourcePreview);
            this.previewBasePanel.getButtonsPanel().addCancel();
        }
        return this.previewBasePanel;
    }

    public CreateLayerPanel getNewOrSaveLayerPanel() {
        if (this.layerPanel == null) {
            this.layerPanel = new CreateLayerPanel(this.lyr);
            if (this.lyr.isRemote()) {
                this.layerPanel.disableNewLayer();
            }
        }
        return this.layerPanel;
    }

    public void close() {
        try {
            PluginServices.getMDIManager().closeWindow((IWindow)this);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public FLyrRaster getLayer() {
        return this.lyr;
    }

    public WindowInfo getWindowInfo() {
        WindowInfo m_viewinfo = new WindowInfo(19);
        if (this.getPreviewBasePanel().getDataSourcePreview().getSource() != null) {
            FLyrRaster lyr = (FLyrRaster)this.getPreviewBasePanel().getDataSourcePreview().getSource();
            m_viewinfo.setAdditionalInfo(lyr.getName());
        }
        m_viewinfo.setTitle(PluginServices.getText((Object)this, (String)"enhanced"));
        m_viewinfo.setHeight(this.getHeight());
        m_viewinfo.setWidth(this.getWidth());
        return m_viewinfo;
    }

    public PreviewFiltering getFilteredPreview() {
        return this.filteredPreview;
    }

    public String getViewName() {
        return this.viewName;
    }

    public GraphicsPanel getGraphicsPanel() {
        return this.graphicsPanel;
    }

    public Object getWindowProfile() {
        return WindowInfo.PROPERTIES_PROFILE;
    }
}

