/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.enhanced.ui;

import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.raster.swing.gcanvas.StraightLine;
import org.gvsig.raster.tools.app.basic.tool.enhanced.graphics.HistogramGraphicBase;
import org.gvsig.raster.tools.app.basic.tool.enhanced.graphics.InputHistogram;
import org.gvsig.raster.tools.app.basic.tool.enhanced.graphics.OutputHistogram;
import org.gvsig.raster.tools.app.basic.tool.enhanced.ui.EnhancedDialog;

public class EnhancedHistogramController {
    private InputHistogram inputHistogram = null;
    private OutputHistogram outputHistogram = null;
    private EnhancedDialog enhancedDialog = null;

    public EnhancedHistogramController(InputHistogram inputHistogram, OutputHistogram outputHistogram, EnhancedDialog enhancedDialog) {
        this.inputHistogram = inputHistogram;
        this.outputHistogram = outputHistogram;
        this.enhancedDialog = enhancedDialog;
    }

    private void renderingAsGray(HistogramGraphicBase.HistogramStatus histogram, Params params) {
        if (histogram.getBaseFunction() instanceof StraightLine) {
            StraightLine line = (StraightLine)histogram.getBaseFunction();
            double[] valuesIn = this.enhancedDialog.getGraphicsPanel().getRGB().isSelected() ? line.getInValues(0.0, 255.0) : line.getInValues(histogram.getMin(), histogram.getMax());
            int[] valuesOut = line.getOutValues();
            params.setParam("StretchInRed", (Object)valuesIn, -1, null);
            params.setParam("StretchOutRed", (Object)valuesOut, -1, null);
            params.setParam("StretchRedFunctionType", (Object)line.getFunctionType(), -1, null);
            params.setParam("StretchRedValueFunction", (Object)line.getValueFunction(), -1, null);
            params.setParam("StretchInGreen", (Object)valuesIn, -1, null);
            params.setParam("StretchOutGreen", (Object)valuesOut, -1, null);
            params.setParam("StretchGreenFunctionType", (Object)line.getFunctionType(), -1, null);
            params.setParam("StretchGreenValueFunction", (Object)line.getValueFunction(), -1, null);
            params.setParam("StretchInBlue", (Object)valuesIn, -1, null);
            params.setParam("StretchOutBlue", (Object)valuesOut, -1, null);
            params.setParam("StretchBlueFunctionType", (Object)line.getFunctionType(), -1, null);
            params.setParam("StretchBlueValueFunction", (Object)line.getValueFunction(), -1, null);
        }
    }

    private void renderingAsColor(HistogramGraphicBase.HistogramStatus histogram, Params params, String inColorLabel, String outColorLabel, String functionTypeLabel, String valueFunctionLabel) {
        if (histogram != null && histogram.getBaseFunction() instanceof StraightLine) {
            StraightLine line = (StraightLine)histogram.getBaseFunction();
            double[] valuesIn = this.enhancedDialog.getGraphicsPanel().getRGB().isSelected() ? line.getInValues(0.0, 255.0) : line.getInValues(histogram.getMin(), histogram.getMax());
            int[] valuesOut = line.getOutValues();
            params.setParam(inColorLabel, (Object)valuesIn, -1, null);
            params.setParam(outColorLabel, (Object)valuesOut, -1, null);
            params.setParam(functionTypeLabel, (Object)line.getFunctionType(), -1, null);
            params.setParam(valueFunctionLabel, (Object)line.getValueFunction(), -1, null);
        }
    }

    public void updatePreview() {
        Params params = RasterLocator.getManager().createParams("", (Object)0, 0, null);
        HistogramGraphicBase.HistogramStatus histogram = null;
        if (this.enhancedDialog.getLayer().getRender().isRenderingAsGray()) {
            histogram = this.inputHistogram.getHistogramStatus(3);
            this.renderingAsGray(histogram, params);
        } else {
            histogram = this.inputHistogram.getHistogramStatus(0);
            if (histogram != null) {
                this.renderingAsColor(histogram, params, "StretchInRed", "StretchOutRed", "StretchRedFunctionType", "StretchRedValueFunction");
            }
            if ((histogram = this.inputHistogram.getHistogramStatus(1)) != null) {
                this.renderingAsColor(histogram, params, "StretchInGreen", "StretchOutGreen", "StretchGreenFunctionType", "StretchGreenValueFunction");
            }
            if ((histogram = this.inputHistogram.getHistogramStatus(2)) != null) {
                this.renderingAsColor(histogram, params, "StretchInBlue", "StretchOutBlue", "StretchBlueFunctionType", "StretchBlueValueFunction");
            }
        }
        params.setParam("TailTrimRedMin", (Object)0.0, -1, null);
        params.setParam("TailTrimRedMax", (Object)0.0, -1, null);
        params.setParam("TailTrimGreenMin", (Object)0.0, -1, null);
        params.setParam("TailTrimGreenMax", (Object)0.0, -1, null);
        params.setParam("TailTrimBlueMin", (Object)0.0, -1, null);
        params.setParam("TailTrimBlueMax", (Object)0.0, -1, null);
        boolean rgb = this.enhancedDialog.getGraphicsPanel().getRGB().isSelected();
        params.setParam("RGB", (Object)new Boolean(rgb), -1, null);
        int[] renderBands = this.enhancedDialog.getLayer().getRender().getRenderColorInterpretation().buildRenderBands();
        String render = "";
        for (int i = 0; i < renderBands.length; ++i) {
            if (render != "") {
                render = render + " ";
            }
            render = render + "" + renderBands[i];
        }
        params.setParam("RenderBands", (Object)render, -1, null);
        this.enhancedDialog.getFilteredPreview().getParamsList().clear();
        Class filterClass = this.enhancedDialog.getLayer().getRender().getFilterList().getFilterClassByID("enhanced_stretch");
        this.enhancedDialog.getFilteredPreview().addNewParam("enhanced_stretch", params, filterClass);
        this.enhancedDialog.getPreviewBasePanel().refreshPreview();
    }

    public void updateHistogramOut() {
        HistogramGraphicBase.HistogramStatus histogram = this.inputHistogram.getHistogramStatus(4);
        if (histogram != null && histogram.getBaseFunction() instanceof StraightLine) {
            StraightLine line = (StraightLine)histogram.getBaseFunction();
            double[] valuesIn = line.getPercentInValues();
            double[] valuesOut = line.getPercentOutValues();
            double[] origenHistogram = this.inputHistogram.getHistogramStatus(4).getHistogram();
            double[] newHistogram = new double[origenHistogram.length];
            for (int i = 0; i < newHistogram.length; ++i) {
                newHistogram[i] = 0.0;
            }
            for (int i = 0; i < origenHistogram.length; ++i) {
                int pos;
                double p = (double)i / ((double)origenHistogram.length - 1.0);
                for (int j = 0; j < valuesIn.length - 1; ++j) {
                    if (valuesIn[j] == valuesIn[j + 1] || !(p >= valuesIn[j]) || !(p <= valuesIn[j + 1])) continue;
                    p = valuesOut[j] + (valuesOut[j + 1] - valuesOut[j]) * ((p - valuesIn[j]) / (valuesIn[j + 1] - valuesIn[j]));
                    break;
                }
                if ((pos = (int)Math.round(p * ((double)origenHistogram.length - 1.0))) < 0) {
                    pos = 0;
                }
                if (pos > origenHistogram.length - 1) {
                    pos = origenHistogram.length - 1;
                }
                int n = pos;
                newHistogram[n] = newHistogram[n] + origenHistogram[i];
            }
            HistogramGraphicBase.HistogramStatus histogramOut = this.outputHistogram.getHistogramStatus(4);
            histogramOut.setHistogram(newHistogram);
            histogramOut.setLimits(0.0, 255.0);
            this.outputHistogram.repaint();
        }
    }
}

