/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.enhanced.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.datastruct.Stretch;
import org.gvsig.fmap.dal.coverage.exception.FilterManagerException;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.grid.filter.LinearStretchParams;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelEvent;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelListener;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.swing.RasterSwingLocator;
import org.gvsig.raster.swing.gcanvas.BaseFunction;
import org.gvsig.raster.swing.gcanvas.DensitySlicingLine;
import org.gvsig.raster.swing.gcanvas.DrawableElement;
import org.gvsig.raster.swing.gcanvas.GCanvas;
import org.gvsig.raster.swing.gcanvas.GCanvasEvent;
import org.gvsig.raster.swing.gcanvas.IGCanvasListener;
import org.gvsig.raster.swing.gcanvas.LogaritmicExponentialLine;
import org.gvsig.raster.swing.gcanvas.SquareRootPowLine;
import org.gvsig.raster.swing.gcanvas.StraightLine;
import org.gvsig.raster.tools.app.basic.RasterToolsUtil;
import org.gvsig.raster.tools.app.basic.raster.bean.previewbase.ParamStruct;
import org.gvsig.raster.tools.app.basic.raster.process.FilterProcess;
import org.gvsig.raster.tools.app.basic.raster.process.IProcessActions;
import org.gvsig.raster.tools.app.basic.tool.enhanced.graphics.HistogramGraphicBase;
import org.gvsig.raster.tools.app.basic.tool.enhanced.ui.EnhancedDialog;
import org.gvsig.raster.tools.app.basic.tool.enhanced.ui.EnhancedHistogramController;
import org.gvsig.raster.tools.app.basic.tool.enhanced.ui.GraphicsPanel;
import org.gvsig.raster.tools.app.basic.tool.enhanced.ui.PreviewFiltering;
import org.gvsig.raster.tools.app.basic.tool.enhanced.ui.SelectorsPanel;
import org.gvsig.raster.util.LayerVisualStatusList;
import org.gvsig.raster.util.RasterNotLoadException;

public class EnhancedListener
implements ActionListener,
IGCanvasListener,
ButtonsPanelListener,
IProcessActions {
    private SelectorsPanel selectorsPanel = null;
    private GraphicsPanel graphicsPanel = null;
    private EnhancedDialog enhancedDialog = null;
    private PreviewFiltering filteredPreview = null;
    private EnhancedHistogramController enhancedManager = null;
    private LayerVisualStatusList status = new LayerVisualStatusList();

    public EnhancedListener(SelectorsPanel selectorsPanel, GraphicsPanel graphicsPanel, EnhancedDialog enhancedDialog, PreviewFiltering filteredPreview) {
        this.selectorsPanel = selectorsPanel;
        this.graphicsPanel = graphicsPanel;
        this.enhancedDialog = enhancedDialog;
        this.filteredPreview = filteredPreview;
        this.status.getVisualStatus(enhancedDialog.getLayer());
        this.enhancedManager = new EnhancedHistogramController(graphicsPanel.getInputHistogram(), graphicsPanel.getOutputHistogram(), enhancedDialog);
        selectorsPanel.getHistogramType().addActionListener((ActionListener)this);
        selectorsPanel.getDrawType().addActionListener((ActionListener)this);
        selectorsPanel.getBand(null).addActionListener((ActionListener)this);
        selectorsPanel.getEnhancedType().addActionListener((ActionListener)this);
        graphicsPanel.getLevels().addActionListener(this);
        graphicsPanel.getRGB().addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        HistogramGraphicBase.HistogramStatus status;
        if (e.getSource() == this.selectorsPanel.getDrawType()) {
            if (((String)this.selectorsPanel.getDrawType().getSelectedItem()).equals(Messages.getText((String)"fill"))) {
                this.graphicsPanel.getInputHistogram().setType(2);
                this.graphicsPanel.getOutputHistogram().setType(2);
            }
            if (((String)this.selectorsPanel.getDrawType().getSelectedItem()).equals(Messages.getText((String)"line"))) {
                this.graphicsPanel.getInputHistogram().setType(1);
                this.graphicsPanel.getOutputHistogram().setType(1);
            }
            ((Component)this.graphicsPanel.getInputHistogram().getCanvas()).repaint();
            ((Component)this.graphicsPanel.getOutputHistogram().getCanvas()).repaint();
        }
        if (e.getSource() == this.selectorsPanel.getHistogramType()) {
            if (((String)this.selectorsPanel.getHistogramType().getSelectedItem()).equals(Messages.getText((String)"standard"))) {
                this.graphicsPanel.getOutputHistogram().setHistogramType(0);
            }
            if (((String)this.selectorsPanel.getHistogramType().getSelectedItem()).equals(Messages.getText((String)"cumulative"))) {
                this.graphicsPanel.getOutputHistogram().setHistogramType(1);
            }
            if (((String)this.selectorsPanel.getHistogramType().getSelectedItem()).equals(Messages.getText((String)"logaritmic"))) {
                this.graphicsPanel.getOutputHistogram().setHistogramType(2);
            }
            if (((String)this.selectorsPanel.getHistogramType().getSelectedItem()).equals(Messages.getText((String)"cumulative_logarithmic"))) {
                this.graphicsPanel.getOutputHistogram().setHistogramType(3);
            }
            ((Component)this.graphicsPanel.getOutputHistogram().getCanvas()).repaint();
        }
        if (e.getSource() == this.graphicsPanel.getRGB()) {
            this.graphicsPanel.updateHistogram();
            this.updatePreview();
        }
        if (e.getSource() == this.selectorsPanel.getBand(null)) {
            if (((String)this.selectorsPanel.getBand(null).getSelectedItem()).equals(Messages.getText((String)"red"))) {
                this.graphicsPanel.getInputHistogram().setHistogramDrawed(0);
                this.graphicsPanel.getOutputHistogram().setHistogramDrawed(0);
            }
            if (((String)this.selectorsPanel.getBand(null).getSelectedItem()).equals(Messages.getText((String)"green"))) {
                this.graphicsPanel.getInputHistogram().setHistogramDrawed(1);
                this.graphicsPanel.getOutputHistogram().setHistogramDrawed(1);
            }
            if (((String)this.selectorsPanel.getBand(null).getSelectedItem()).equals(Messages.getText((String)"blue"))) {
                this.graphicsPanel.getInputHistogram().setHistogramDrawed(2);
                this.graphicsPanel.getOutputHistogram().setHistogramDrawed(2);
            }
            this.updateTypeSelected();
            status = this.graphicsPanel.getOutputHistogram().getHistogramStatus(4);
            switch (status.getGraphicHistogram().getType()) {
                case 2: {
                    this.selectorsPanel.getDrawType().setSelectedItem((Object)Messages.getText((String)"fill"));
                    break;
                }
                default: {
                    this.selectorsPanel.getDrawType().setSelectedItem((Object)Messages.getText((String)"line"));
                }
            }
            switch (status.getGraphicHistogram().getTypeViewed()) {
                case 1: {
                    this.selectorsPanel.getHistogramType().setSelectedItem((Object)Messages.getText((String)"cumulative"));
                    break;
                }
                case 2: {
                    this.selectorsPanel.getHistogramType().setSelectedItem((Object)Messages.getText((String)"logaritmic"));
                    break;
                }
                case 3: {
                    this.selectorsPanel.getHistogramType().setSelectedItem((Object)Messages.getText((String)"cumulative_logarithmic"));
                    break;
                }
                default: {
                    this.selectorsPanel.getHistogramType().setSelectedItem((Object)Messages.getText((String)"standard"));
                }
            }
        }
        if (e.getSource() == this.selectorsPanel.getEnhancedType()) {
            this.graphicsPanel.setLevelsEnabled(false);
            if (((String)this.selectorsPanel.getEnhancedType().getSelectedItem()).equals(Messages.getText((String)"lineal"))) {
                this.graphicsPanel.getInputHistogram().setFunction(0);
                this.updatePreview();
            }
            if (((String)this.selectorsPanel.getEnhancedType().getSelectedItem()).equals(Messages.getText((String)"gaussian"))) {
                // empty if block
            }
            if (((String)this.selectorsPanel.getEnhancedType().getSelectedItem()).equals(Messages.getText((String)"logaritmic"))) {
                this.graphicsPanel.getInputHistogram().setFunction(3);
                this.updatePreview();
            }
            if (((String)this.selectorsPanel.getEnhancedType().getSelectedItem()).equals(Messages.getText((String)"exponential"))) {
                this.graphicsPanel.getInputHistogram().setFunction(2);
                this.updatePreview();
            }
            if (((String)this.selectorsPanel.getEnhancedType().getSelectedItem()).equals(Messages.getText((String)"equalization"))) {
                this.graphicsPanel.getInputHistogram().setFunction(-1);
                int[] renderBands = this.enhancedDialog.getLayer().getRender().getRenderColorInterpretation().buildRenderBands();
                String values = "";
                for (int i = 0; i < renderBands.length; ++i) {
                    values = values + renderBands[i] + " ";
                }
                values = values.trim();
                Params params = RasterLocator.getManager().createParams("", (Object)0, 0, null);
                params.setParam("Histogram", (Object)this.graphicsPanel.getHistogram(), -1, null);
                params.setParam("RenderBands", (Object)values, -1, null);
                params.setParam("EcualizedBands", (Object)new int[]{0, 1, 2}, -1, null);
                Class filterClass = this.enhancedDialog.getLayer().getRender().getFilterList().getFilterClassByID("equalization");
                this.filteredPreview.addNewParam("equalization", params, filterClass);
                this.updatePreview();
            }
            if (((String)this.selectorsPanel.getEnhancedType().getSelectedItem()).equals(Messages.getText((String)"square_root"))) {
                this.graphicsPanel.getInputHistogram().setFunction(4);
                this.updatePreview();
            }
            if (((String)this.selectorsPanel.getEnhancedType().getSelectedItem()).equals(Messages.getText((String)"level_slice"))) {
                this.graphicsPanel.setLevelsEnabled(true);
                this.graphicsPanel.getInputHistogram().setFunction(6);
                status = this.graphicsPanel.getInputHistogram().getHistogramStatus(4);
                this.graphicsPanel.getLevels().setValue(new Long(((DensitySlicingLine)status.getBaseFunction()).getLevels()));
                this.updatePreview();
            }
        }
        if (e.getSource() == this.selectorsPanel.getHistogramType()) {
            if (((String)this.selectorsPanel.getHistogramType().getSelectedItem()).equals(Messages.getText((String)"standard"))) {
                // empty if block
            }
            if (((String)this.selectorsPanel.getHistogramType().getSelectedItem()).equals(Messages.getText((String)"cumulative"))) {
                // empty if block
            }
        }
        if (e.getSource() == this.graphicsPanel.getLevels()) {
            Long lValue = (Long)this.graphicsPanel.getLevels().getValue();
            int value = lValue.intValue();
            if (value > 30 || value < 2) {
                RasterSwingLibrary.messageBoxInfo((String)(Messages.getText((String)"range_wrong") + " [2-30]"), (Object)this.graphicsPanel);
                if (value > 30) {
                    value = 30;
                }
                if (value < 2) {
                    value = 2;
                }
            }
            this.graphicsPanel.getLevels().setValue(new Long(value));
            try {
                this.graphicsPanel.getInputHistogram().setLevel(value);
                this.updatePreview();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void updateTypeSelected() {
        HistogramGraphicBase.HistogramStatus status = this.graphicsPanel.getInputHistogram().getHistogramStatus(4);
        if (status.getBaseFunction().getClass().equals(DensitySlicingLine.class)) {
            this.selectorsPanel.setSelectedEnhancedType(Messages.getText((String)"level_slice"));
        }
        if (status.getBaseFunction().getClass().equals(StraightLine.class)) {
            this.selectorsPanel.setSelectedEnhancedType(Messages.getText((String)"lineal"));
        }
        Class filterClass = this.enhancedDialog.getLayer().getRender().getFilterList().getFilterClassByID("equalization");
        if (status.getBaseFunction().getClass().equals(filterClass)) {
            this.selectorsPanel.setSelectedEnhancedType(Messages.getText((String)"equalization"));
        }
        if (status.getBaseFunction().getClass().equals(SquareRootPowLine.class)) {
            this.selectorsPanel.setSelectedEnhancedType(Messages.getText((String)"square_root"));
        }
        if (status.getBaseFunction().getClass().equals(LogaritmicExponentialLine.class)) {
            if (((StraightLine)status.getBaseFunction()).getValueFunction() >= 0.0) {
                this.selectorsPanel.setSelectedEnhancedType(Messages.getText((String)"logaritmic"));
            } else {
                this.selectorsPanel.setSelectedEnhancedType(Messages.getText((String)"exponential"));
            }
        }
    }

    private List<Point2D> getPointListFromStretches(Stretch stretch) {
        ArrayList<Point2D> pointList = new ArrayList<Point2D>();
        for (int i = 0; i < stretch.getStretchIn().length; ++i) {
            Point2D.Double p = new Point2D.Double((stretch.getStretchIn()[i] - stretch.getMinValue()) / (stretch.getMaxValue() - stretch.getMinValue()), (double)stretch.getStretchOut()[i] / 255.0);
            pointList.add(p);
        }
        this.simplifyPointList(pointList);
        return pointList;
    }

    private double[] simplifyPointList(List<Point2D> pointList) {
        int lastPoint = pointList.size() - 1;
        double[] removed = new double[2];
        if (pointList.size() > 1 && pointList.get(lastPoint).getX() == 1.0 && pointList.get(lastPoint).getY() == 1.0 && pointList.get(lastPoint - 1).getY() == 1.0) {
            removed[0] = pointList.remove(lastPoint).getX();
        }
        if (pointList.size() > 1 && pointList.get(0).getX() == 0.0 && pointList.get(0).getY() == 0.0 && pointList.get(1).getY() == 0.0) {
            removed[1] = pointList.remove(0).getX();
        }
        return removed;
    }

    private void firstLoadBand(Stretch stretch, int band) {
        boolean firstBand = band == 3 || band == 0;
        this.graphicsPanel.getInputHistogram().setHistogramDrawed(band);
        StraightLine baseFunction = null;
        HistogramGraphicBase.HistogramStatus status = this.graphicsPanel.getInputHistogram().getHistogramStatus(band);
        if (status == null) {
            return;
        }
        GCanvas canvas = RasterSwingLocator.getSwingManager().createGraphicCanvas(Color.white);
        switch (stretch.getFunctionType()) {
            case 0: {
                if (firstBand) {
                    this.selectorsPanel.getEnhancedType().setSelectedItem((Object)Messages.getText((String)"lineal"));
                    this.graphicsPanel.setLevelsEnabled(false);
                }
                baseFunction = canvas.createStraightLineForGCanvas(((DrawableElement)status.getBaseFunction()).getColor());
                baseFunction.clearSquares();
                List<Point2D> pointList = this.getPointListFromStretches(stretch);
                StraightLine func = baseFunction;
                for (int i = 0; i < pointList.size(); ++i) {
                    func.addSquare(pointList.get(i).getX(), pointList.get(i).getY());
                }
                break;
            }
            case 1: {
                if (firstBand) {
                    if (stretch.getValueFunction() >= 0.0) {
                        this.selectorsPanel.getEnhancedType().setSelectedItem((Object)Messages.getText((String)"logaritmic"));
                    } else {
                        this.selectorsPanel.getEnhancedType().setSelectedItem((Object)Messages.getText((String)"exponential"));
                    }
                    this.graphicsPanel.setLevelsEnabled(false);
                }
                baseFunction = canvas.createLogaritmicExponentialLineForGCanvas(((DrawableElement)status.getBaseFunction()).getColor(), stretch.getValueFunction());
                break;
            }
            case 2: {
                if (firstBand) {
                    this.selectorsPanel.getEnhancedType().setSelectedItem((Object)Messages.getText((String)"square_root"));
                    this.graphicsPanel.setLevelsEnabled(false);
                }
                baseFunction = canvas.createSquareRootPowLineForGCanvas(((DrawableElement)status.getBaseFunction()).getColor(), stretch.getValueFunction());
                break;
            }
            case 3: {
                if (firstBand) {
                    this.selectorsPanel.getEnhancedType().setSelectedItem((Object)Messages.getText((String)"level_slice"));
                    this.graphicsPanel.setLevelsEnabled(true);
                }
                baseFunction = canvas.createDensitySliceForGCanvas(((DrawableElement)status.getBaseFunction()).getColor(), (int)stretch.getValueFunction());
            }
        }
        if (baseFunction != null) {
            status.setBaseFunction((BaseFunction)baseFunction);
            this.graphicsPanel.getInputHistogram().setHistogramDrawed(band);
        }
    }

    public void firstLoad() {
        RasterFilterList rasterFilterList = this.enhancedDialog.getLayer().getRender().getFilterList();
        RasterFilter filter = rasterFilterList.getByName("enhanced_stretch");
        if (filter != null) {
            LinearStretchParams stretch = (LinearStretchParams)filter.getParam("stretchs");
            this.firstLoadBand(stretch.getBlue(), 2);
            this.firstLoadBand(stretch.getGreen(), 1);
            this.firstLoadBand(stretch.getRed(), 0);
            this.firstLoadBand(stretch.getRed(), 3);
            this.graphicsPanel.getRGB().setSelected(stretch.isRgb());
        }
        this.graphicsPanel.getInputHistogram().repaint();
    }

    public void updatePreview() {
        this.enhancedManager.updatePreview();
        this.enhancedManager.updateHistogramOut();
    }

    private void updateHistogramOut() {
        this.updateTypeSelected();
        this.enhancedManager.updatePreview();
        this.enhancedManager.updateHistogramOut();
    }

    public void actionDataChanged(GCanvasEvent e) {
        if (e.getKey().equals("minmax")) {
            this.updatePreview();
            return;
        }
        if (e.getKey().equals("line")) {
            this.updatePreview();
            return;
        }
    }

    public void actionDataDragged(GCanvasEvent e) {
        if (e.getKey().equals("minmax")) {
            this.updateHistogramOut();
            return;
        }
        if (e.getKey().equals("line")) {
            this.updateHistogramOut();
            return;
        }
    }

    public void actionButtonPressed(ButtonsPanelEvent e) {
        switch (e.getButton()) {
            case 2: {
                this.cancel();
                break;
            }
            case 3: {
                this.apply();
                break;
            }
            case 6: {
                this.enhancedDialog.close();
            }
        }
    }

    public void apply() {
        FLyrRaster lyr = this.enhancedDialog.getLayer();
        if (lyr == null) {
            return;
        }
        String path = null;
        if (!this.enhancedDialog.getNewOrSaveLayerPanel().isOnlyViewSelected() && (path = this.enhancedDialog.getNewOrSaveLayerPanel().getFileSelected()) == null) {
            return;
        }
        List<ParamStruct> listFilterUsed = this.enhancedDialog.getFilteredPreview().applySelectedFilters(null);
        if (this.enhancedDialog.getNewOrSaveLayerPanel().isOnlyViewSelected()) {
            try {
                ParamStruct.addSelectedFilters(lyr.getRender().getFilterList(), listFilterUsed);
                this.enhancedDialog.getLayer().getRender().setFilterList(lyr.getRender().getFilterList());
                this.enhancedDialog.getLayer().getMapContext().invalidate();
            }
            catch (FilterTypeException e) {
                RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"error_adding_filters"), (Object)this, (Exception)((Object)e));
            }
            catch (FilterManagerException e) {
                RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"error_adding_filters"), (Object)this, (Exception)((Object)e));
            }
        } else {
            FilterProcess filterProcess = new FilterProcess();
            filterProcess.setActions(this);
            filterProcess.addParam("rendering", lyr);
            filterProcess.addParam("filename", path);
            filterProcess.addParam("rasterdatasource", lyr.getDataStore());
            filterProcess.addParam("layer", this.enhancedDialog.getLayer());
            filterProcess.addParam("listfilterused", listFilterUsed);
            filterProcess.addParam("onlyrenderbands", Boolean.TRUE);
            filterProcess.start();
        }
    }

    public void cancel() {
        if (this.enhancedDialog.getLayer() != null) {
            this.status.restoreVisualStatus(this.enhancedDialog.getLayer());
            this.enhancedDialog.getLayer().getMapContext().invalidate();
        }
    }

    public void loadLayerInToc(String fileName) {
        if (!this.enhancedDialog.getNewOrSaveLayerPanel().isNewLayerSelected()) {
            return;
        }
        if (!new File(fileName).exists()) {
            return;
        }
        try {
            RasterToolsUtil.loadLayer(this.enhancedDialog.getViewName(), fileName, null);
        }
        catch (RasterNotLoadException e) {
            RasterSwingLibrary.messageBoxError((String)"error_cargar_capa", (Object)this, (Exception)((Object)e));
        }
        if (this.enhancedDialog != null) {
            this.enhancedDialog.getNewOrSaveLayerPanel().updateNewLayerText();
        }
    }

    @Override
    public void end(Object param) {
        this.loadLayerInToc((String)param);
    }

    @Override
    public void interrupted() {
    }
}

