/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.enhanced.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.tools.app.basic.RasterToolsUtil;
import org.gvsig.raster.tools.app.basic.tool.enhanced.graphics.HistogramGraphicBase;
import org.gvsig.utils.swing.JComboBox;

public class SelectorsPanel
extends JPanel {
    private static final long serialVersionUID = 3453973982901626644L;
    private JComboBox enhancedType = null;
    private JComboBox histogramType = null;
    private JComboBox drawType = null;
    private JComboBox band = null;
    private HistogramGraphicBase graphicBase = null;

    public SelectorsPanel(FLyrRaster lyr, HistogramGraphicBase graphicBase) {
        this.graphicBase = graphicBase;
        this.init(lyr);
    }

    private void init(FLyrRaster lyr) {
        GridBagConstraints gridBagConstraints = null;
        this.setBorder(BorderFactory.createTitledBorder(null, null, 0, 0, null, null));
        this.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 2, 2);
        this.add((Component)new JLabel(RasterToolsUtil.getText(this, "operation")), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.getEnhancedType(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.add((Component)new JLabel(RasterToolsUtil.getText(this, "band")), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.getBand(lyr), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 2, 2, 2);
        this.add((Component)new JLabel(RasterToolsUtil.getText(this, "drawing_type")), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 2, 2, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.getDrawType(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)new JLabel(RasterToolsUtil.getText(this, "histogram_type")), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.getHistogramType(), gridBagConstraints);
    }

    public JComboBox getHistogramType() {
        if (this.histogramType == null) {
            this.histogramType = new JComboBox();
            this.histogramType.addItem((Object)RasterToolsUtil.getText(this, "standard"));
            this.histogramType.addItem((Object)RasterToolsUtil.getText(this, "cumulative"));
            this.histogramType.addItem((Object)RasterToolsUtil.getText(this, "logaritmic"));
            this.histogramType.addItem((Object)RasterToolsUtil.getText(this, "cumulative_logarithmic"));
        }
        return this.histogramType;
    }

    public JComboBox getDrawType() {
        if (this.drawType == null) {
            this.drawType = new JComboBox();
            this.drawType.addItem((Object)RasterToolsUtil.getText(this, "line"));
            this.drawType.addItem((Object)RasterToolsUtil.getText(this, "fill"));
        }
        return this.drawType;
    }

    public JComboBox getBand(FLyrRaster lyr) {
        if (this.band == null) {
            this.band = new JComboBox();
            if (lyr.getRender().isRenderingAsGray()) {
                this.band.addItem((Object)RasterToolsUtil.getText(this, "gray"));
            } else {
                if (this.graphicBase.getHistogramStatus(0) != null) {
                    this.band.addItem((Object)RasterToolsUtil.getText(this, "red"));
                }
                if (this.graphicBase.getHistogramStatus(1) != null) {
                    this.band.addItem((Object)RasterToolsUtil.getText(this, "green"));
                }
                if (this.graphicBase.getHistogramStatus(2) != null) {
                    this.band.addItem((Object)RasterToolsUtil.getText(this, "blue"));
                }
            }
        }
        return this.band;
    }

    public JComboBox getEnhancedType() {
        if (this.enhancedType == null) {
            this.enhancedType = new JComboBox();
            this.enhancedType.addItem((Object)RasterToolsUtil.getText(this, "lineal"));
            this.enhancedType.addItem((Object)RasterToolsUtil.getText(this, "square_root"));
            this.enhancedType.addItem((Object)RasterToolsUtil.getText(this, "logaritmic"));
            this.enhancedType.addItem((Object)RasterToolsUtil.getText(this, "exponential"));
            this.enhancedType.addItem((Object)RasterToolsUtil.getText(this, "level_slice"));
        }
        return this.enhancedType;
    }

    public void setSelectedEnhancedType(String type) {
        if (this.getEnhancedType().getSelectedItem() != type) {
            int i;
            ActionListener[] copyActionListeners = this.getEnhancedType().getActionListeners();
            for (i = 0; i < copyActionListeners.length; ++i) {
                this.getEnhancedType().removeActionListener(copyActionListeners[i]);
            }
            this.getEnhancedType().setSelectedItem((Object)type);
            for (i = 0; i < copyActionListeners.length; ++i) {
                this.getEnhancedType().addActionListener(copyActionListeners[i]);
            }
        }
    }
}

