/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.filter.grayscale;

import java.util.ArrayList;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.AbstractRasterFilterManager;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.raster.tools.app.basic.tool.filter.grayscale.GrayScaleByteFilter;
import org.gvsig.raster.tools.app.basic.tool.filter.grayscale.GrayScaleFilter;

public class GrayScaleManager
extends AbstractRasterFilterManager {
    public static String ID = "GrayScale";

    public String getManagerID() {
        return ID;
    }

    public static void register() {
        AbstractRasterFilterManager.register((String)ID, GrayScaleManager.class);
    }

    public boolean isDataTypeSupported(int dataType) {
        return dataType == 0;
    }

    public Class<?> getFilterClassByID(String id) {
        if (id.compareTo("grayscale") == 0) {
            return GrayScaleFilter.class;
        }
        return null;
    }

    public GrayScaleManager(RasterFilterList filterList) {
        super(filterList);
    }

    public void addGrayScaleFilter(int type) throws FilterTypeException {
        GrayScaleByteFilter filter = new GrayScaleByteFilter();
        if (filter != null) {
            filter.addParam("typeBand", new Integer(type));
            this.getFilterList().add((RasterFilter)filter);
        }
    }

    public ArrayList getRasterFilterList() {
        ArrayList<Class<GrayScaleFilter>> filters = new ArrayList<Class<GrayScaleFilter>>();
        filters.add(GrayScaleFilter.class);
        return filters;
    }

    public void addFilter(Class<?> classFilter, Params params) throws FilterTypeException {
        if (classFilter.equals(GrayScaleFilter.class)) {
            int type = 0;
            for (int i = 0; i < params.getNumParams(); ++i) {
                if (!params.getParam(i).getId().equals("typeBand")) continue;
                type = (Integer)params.getParam(i).getDefaultValue();
            }
            this.addGrayScaleFilter(type);
        }
    }

    public RasterFilter createFilter(Params params) {
        Integer type = (Integer)params.getParamById("typeBand").getDefaultValue();
        GrayScaleByteFilter filter = new GrayScaleByteFilter();
        filter.addParam("typeBand", type);
        return filter;
    }

    public void addFilter(Params params) throws FilterTypeException {
        this.addFilter(GrayScaleFilter.class, params);
    }
}

