/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.filter.mask;

import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.raster.roi.ROI;
import org.gvsig.raster.tools.app.basic.tool.filter.mask.MaskFilter;

public class MaskByteFilter
extends MaskFilter {
    private byte nodata = RasterLibrary.defaultByteNoDataValue;

    @Override
    public void pre() throws FilterAddException {
        super.pre();
        this.noData = (NoData)this.params.get("nodata");
        if (this.noData != null && this.noData.isDefined()) {
            this.nodata = this.noData.getValue().byteValue();
        }
    }

    @Override
    public void process(int x, int y) {
        if (this.bufferExtent == null || this.rois == null || this.rois.size() == 0) {
            for (int j = 0; j < this.raster.getBandCount(); ++j) {
                this.rasterResult.setElem(y, x, j, this.raster.getElemByte(y, x, j));
            }
            return;
        }
        double wcX = this.bufferExtent.minX() + (double)x * this.bufferExtent.width() / (double)this.raster.getWidth();
        double wcY = this.bufferExtent.minY() + (double)(this.raster.getHeight() - y) * this.bufferExtent.height() / (double)this.raster.getHeight();
        for (int iBand = 0; iBand < this.numberOfBandsToProcess(); ++iBand) {
            this.rasterResult.setElem(y, x, iBand, this.raster.getElemByte(y, x, iBand));
        }
        for (int i = 0; i < this.rois.size(); ++i) {
            if (!((ROI)this.rois.get(i)).isInside(wcX, wcY, this.cellsize, this.cellsize)) continue;
            if (this.inverse) {
                this.drawPixelNoData(x, y);
            } else {
                this.drawPixelFill(x, y);
            }
            return;
        }
        if (this.inverse) {
            this.drawPixelFill(x, y);
        } else {
            this.drawPixelNoData(x, y);
        }
    }

    private void drawPixelFill(int x, int y) {
        for (int j = 0; j < this.numberOfBandsToProcess(); ++j) {
            this.rasterResult.setElem(y, x, j, this.raster.getElemByte(y, x, j));
        }
        this.writeAlphaBand(y, x);
    }

    private void drawPixelNoData(int x, int y) {
        for (int j = 0; j < this.numberOfBandsToProcess(); ++j) {
            this.rasterResult.setElem(y, x, j, this.nodata);
        }
        if (this.hasInputTransparency()) {
            this.rasterResult.setElem(y, x, this.rasterResult.getBandCount() - 1, (byte)-1);
        }
    }

    @Override
    public int getInRasterDataType() {
        return 0;
    }

    @Override
    public int getOutRasterDataType() {
        return 0;
    }
}

