/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.filter.mask;

import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.raster.roi.ROI;
import org.gvsig.raster.tools.app.basic.tool.filter.mask.MaskFilter;

public class MaskShortFilter
extends MaskFilter {
    private short nodata = RasterLibrary.defaultShortNoDataValue;

    @Override
    public void pre() throws FilterAddException {
        super.pre();
        this.noData = (NoData)this.params.get("nodata");
        if (this.noData != null && this.noData.isDefined()) {
            this.nodata = this.noData.getValue().shortValue();
        }
    }

    @Override
    public void process(int x, int y) {
        if (this.bufferExtent == null) {
            for (int j = 0; j < this.raster.getBandCount(); ++j) {
                this.rasterResult.setElem(y, x, j, this.raster.getElemShort(y, x, j));
            }
            return;
        }
        double wcX = this.bufferExtent.minX() + (double)x * this.bufferExtent.width() / (double)this.raster.getWidth();
        double wcY = this.bufferExtent.minY() + (double)(this.raster.getHeight() - y) * this.bufferExtent.height() / (double)this.raster.getHeight();
        if (this.inverse) {
            for (int i = 0; i < this.rois.size(); ++i) {
                if (!((ROI)this.rois.get(i)).isInside(wcX, wcY, this.cellsize, this.cellsize)) continue;
                for (int j = 0; j < this.numberOfBandsToProcess(); ++j) {
                    this.rasterResult.setElem(y, x, j, this.nodata);
                }
                return;
            }
            for (int j = 0; j < this.numberOfBandsToProcess(); ++j) {
                this.rasterResult.setElem(y, x, j, this.raster.getElemShort(y, x, j));
            }
            return;
        }
        for (int i = 0; i < this.rois.size(); ++i) {
            if (!((ROI)this.rois.get(i)).isInside(wcX, wcY, this.cellsize, this.cellsize)) continue;
            for (int j = 0; j < this.numberOfBandsToProcess(); ++j) {
                this.rasterResult.setElem(y, x, j, this.raster.getElemShort(y, x, j));
            }
            return;
        }
        for (int j = 0; j < this.numberOfBandsToProcess(); ++j) {
            this.rasterResult.setElem(y, x, j, this.nodata);
        }
    }

    @Override
    public int getInRasterDataType() {
        return 2;
    }

    @Override
    public int getOutRasterDataType() {
        return 2;
    }
}

