/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.filter.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Param;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.ROIException;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelListener;
import org.gvsig.gui.beans.imagenavigator.ImageUnavailableException;
import org.gvsig.gui.beans.propertiespanel.PropertiesComponent;
import org.gvsig.gui.beans.propertiespanel.PropertiesComponentListener;
import org.gvsig.gui.beans.treelist.TreeListContainer;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.mainplugin.beans.createlayer.CreateLayerPanel;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.swing.RasterSwingLocator;
import org.gvsig.raster.swing.preview.DataSourcePreview;
import org.gvsig.raster.swing.preview.PreviewPanel;
import org.gvsig.raster.swing.preview.PreviewRenderProcess;
import org.gvsig.raster.tools.app.basic.raster.bean.previewbase.RasterDataSourcePreview;
import org.gvsig.raster.tools.app.basic.tool.filter.FilterListener;
import org.gvsig.raster.tools.app.basic.tool.filter.ui.FilterDialog;
import org.gvsig.raster.tools.app.basic.tool.filter.ui.FilterMainPanel;
import org.gvsig.raster.util.LayerVisualStatusList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterPanel
extends JPanel
implements PreviewRenderProcess {
    private static final long serialVersionUID = 7152780112689637266L;
    private Logger log = LoggerFactory.getLogger(FilterPanel.class);
    private PreviewPanel previewBasePanel = null;
    private FLyrRaster layer = null;
    private FilterListener filterListener = null;
    private PropertiesComponent propertiesComponent = null;
    private LayerVisualStatusList status = new LayerVisualStatusList();
    private JCheckBox jCBShowFilters = null;
    private String viewName = null;
    private JPanel jPanelOptions = null;
    private FilterMainPanel filterMain = null;
    private FilterDialog filterDialog = null;
    private CreateLayerPanel newLayerPanel = null;
    private boolean showPreview = true;

    public FilterPanel(FLyrRaster layer, FilterDialog filterDialog) {
        this.filterDialog = filterDialog;
        this.setLayer(layer);
        this.initialize();
    }

    private void initialize() {
        this.translate();
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPreviewBasePanel(), "Center");
    }

    private void translate() {
        this.getCBShowFilters().setText(PluginServices.getText((Object)this, (String)"aplicar_vista_previa"));
    }

    public PreviewPanel getPreviewBasePanel() {
        if (this.previewBasePanel == null) {
            ArrayList<FilterMainPanel> list = new ArrayList<FilterMainPanel>();
            list.add(this.getMainPanel());
            IProjection viewProj = null;
            if (this.layer.getMapContext() != null) {
                viewProj = this.layer.getMapContext().getProjection();
            }
            RasterDataSourcePreview source = new RasterDataSourcePreview(this.layer, viewProj);
            this.previewBasePanel = RasterSwingLocator.getSwingManager().createPreviewPanel(3, list, null, this.panelOptions(), (PreviewRenderProcess)this, (DataSourcePreview)source);
            this.previewBasePanel.setPreviewSize(new Dimension(230, 215));
            this.previewBasePanel.addButtonPressedListener((ButtonsPanelListener)this.filterDialog);
        }
        return this.previewBasePanel;
    }

    private FilterListener getFilterListener() {
        if (this.filterListener == null) {
            this.filterListener = new FilterListener(this);
        }
        return this.filterListener;
    }

    private JPanel panelOptions() {
        if (this.jPanelOptions == null) {
            this.jPanelOptions = new JPanel();
            this.jPanelOptions.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.jPanelOptions.add((Component)this.getCBShowFilters(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            this.jPanelOptions.add((Component)this.getNewLayerPanel().getJPanel(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.jPanelOptions.add((Component)new JPanel(), gridBagConstraints);
        }
        return this.jPanelOptions;
    }

    public CreateLayerPanel getNewLayerPanel() {
        if (this.newLayerPanel == null) {
            this.newLayerPanel = new CreateLayerPanel(this.layer);
            if (this.layer.isRemote()) {
                this.newLayerPanel.disableNewLayer();
            }
        }
        return this.newLayerPanel;
    }

    private void menuBuild() {
        Hashtable<String, RasterFilter> keys = new Hashtable<String, RasterFilter>();
        RasterFilterList filterList = this.layer.getRender().getFilterList();
        int dataType = this.layer.getDataStore().getDataType()[0];
        if (filterList.getByName("enhanced_stretch") != null || filterList.getByName("enhanced") != null || filterList.getByName("colortable") != null) {
            dataType = 0;
        }
        List registeredFilters = filterList.getRegisteredFilterListByDataType(dataType);
        int count = 0;
        RasterFilter obj = null;
        for (int i = 0; i < registeredFilters.size(); ++i) {
            Class classFilter = (Class)registeredFilters.get(i);
            try {
                obj = (RasterFilter)classFilter.newInstance();
                this.initFilter(obj);
                if (!obj.isVisible()) continue;
                if (!keys.containsKey(Messages.getText((String)new String(obj.getGroup())))) {
                    keys.put(Messages.getText((String)new String(obj.getGroup())), obj);
                    this.getMainPanel().getTreeListContainer().addClass(Messages.getText((String)new String(obj.getGroup())), count);
                    ++count;
                }
                String[] names = obj.getNames();
                for (int j = 0; j < names.length; ++j) {
                    obj.setName(names[j]);
                    this.getFilterListener().addNewParam(names[j], this.initFilterParam(obj.getUIParams(names[j])), classFilter);
                    this.getMainPanel().getTreeListContainer().addEntry(Messages.getText((String)names[j]), Messages.getText((String)obj.getGroup()), names[j]);
                }
                continue;
            }
            catch (InstantiationException e) {
                this.log.debug("Error: the filter cannot be added to the list", (Object)this, (Object)e);
                continue;
            }
            catch (IllegalAccessException e) {
                this.log.debug("Error: the filter cannot be added to the list", (Object)this, (Object)e);
            }
        }
        this.getMainPanel().getTreeListContainer().getTree().expandRow(0);
    }

    private void initFilter(RasterFilter filter) {
        if (this.layer != null) {
            filter.getEnv().put("SrcDataType", this.layer.getDataStore().getDataType()[0]);
            filter.getEnv().put("SrcBandCount", this.layer.getDataStore().getBandCount());
            filter.getEnv().put("SrcStatistics", this.layer.getDataStore().getStatistics());
            filter.getEnv().put("Transparency", this.layer.getDataStore().getTransparency());
            try {
                filter.getEnv().put("SrcROI", this.layer.getRois());
            }
            catch (ROIException e1) {
                this.log.debug("Error reading ROI from the layer", (Object)this, (Object)e1);
            }
        }
    }

    private Params initFilterParam(Params params) {
        params.setParam("enabled", (Object)new Boolean(true), 1, null);
        Param param = params.getParamById("enabled");
        params.getParams().remove(params.getParams().size() - 1);
        params.getParams().add(0, param);
        return params;
    }

    private boolean hasThisFilter(String filter) {
        RasterFilterList filterList = RasterLocator.getManager().createEmptyFilterList(0);
        List registeredFilters = filterList.getRegisteredFilterList();
        RasterFilter obj = null;
        for (int i = 0; i < registeredFilters.size(); ++i) {
            Class classFilter = (Class)registeredFilters.get(i);
            boolean error = true;
            try {
                obj = (RasterFilter)classFilter.newInstance();
                error = false;
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (error) continue;
            String[] names = obj.getNames();
            for (int j = 0; j < names.length; ++j) {
                if (!filter.equals(names[j])) continue;
                return true;
            }
        }
        return false;
    }

    private void setLayer(FLyrRaster layer) {
        if (layer == null) {
            return;
        }
        this.layer = layer;
        IProjection viewProj = null;
        if (layer.getMapContext() != null) {
            viewProj = layer.getMapContext().getProjection();
        }
        RasterDataSourcePreview source = new RasterDataSourcePreview(layer, viewProj);
        this.getPreviewBasePanel().setLayer((DataSourcePreview)source);
        this.menuBuild();
        IWindow win = PluginServices.getMDIManager().getActiveWindow();
        AbstractViewPanel view = null;
        if (!(win instanceof AbstractViewPanel)) {
            RasterSwingLibrary.messageBoxInfo((String)"view_not_active", (Object)this);
            return;
        }
        view = (AbstractViewPanel)win;
        this.viewName = PluginServices.getMDIManager().getWindowInfo((IWindow)view).getTitle();
        long sizeB = (long)(layer.getDataStore().getWidth() * layer.getDataStore().getWidth() * (double)layer.getDataStore().getBandCount());
        int sizeMB = (int)(sizeB / 0x100000L);
        if (sizeMB >= 4096) {
            RasterSwingLibrary.messageBoxInfo((String)"file_too_big", (Object)this);
            this.getNewLayerPanel().setCompress(true);
        }
        RasterFilterList rfl = layer.getRender().getFilterList();
        this.status.getVisualStatus(layer);
        int i = 0;
        boolean filters = false;
        while (rfl.get(i) != null) {
            DefaultListModel list = (DefaultListModel)this.getMainPanel().getTreeListContainer().getListModel();
            if (rfl.get(i).isVisible() && this.hasThisFilter(rfl.get(i).getName())) {
                list.addElement(PluginServices.getText((Object)this, (String)rfl.get(i).getName()));
                for (int j = 0; j < this.getFilterListener().getParamsList().size(); ++j) {
                    if (!this.getFilterListener().getParamsList().get(j).getFilterName().equals(rfl.get(i).getName())) continue;
                    filters = true;
                    this.initFilter(rfl.get(i));
                    this.getFilterListener().getParamsList().get(j).setFilterParam(this.initFilterParam(rfl.get(i).getUIParams(rfl.get(i).getName())));
                }
            }
            ++i;
        }
        if (filters) {
            this.getNewLayerPanel().setOnlyView(true);
        }
        TreeListContainer lc = this.getMainPanel().getTreeListContainer();
        lc.getTree().expandRow(1);
        lc.getTree().setSelectionInterval(2, 2);
    }

    public FilterMainPanel getMainPanel() {
        if (this.filterMain == null) {
            this.filterMain = new FilterMainPanel(this.getFilterListener());
            JPanel panel = this.getNewLayerPanel().getFileNamePanel();
            panel.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"nombre_capa"), 0, 0, null, null));
            this.filterMain.getCentralPanel().add((Component)panel, "South");
        }
        return this.filterMain;
    }

    public void cancel() {
        if (this.layer != null) {
            this.layer.getMapContext().invalidate();
        }
    }

    public void apply() {
        this.filterListener.accept();
    }

    public PropertiesComponent getPropertiesComponent() {
        if (this.propertiesComponent == null) {
            this.propertiesComponent = new PropertiesComponent();
            this.getMainPanel().getCentralPanel().add((Component)this.propertiesComponent, "Center");
            this.propertiesComponent.addStateChangedListener((PropertiesComponentListener)this.getFilterListener());
        }
        return this.propertiesComponent;
    }

    public void setNewPropertiesComponent(PropertiesComponent component, String name) {
        this.getPropertiesComponent().setVisible(false);
        this.remove((Component)this.propertiesComponent);
        this.propertiesComponent = null;
        this.propertiesComponent = component;
        this.getMainPanel().getCentralPanel().add((Component)this.propertiesComponent, "Center");
        this.propertiesComponent.addStateChangedListener((PropertiesComponentListener)this.getFilterListener());
        this.setTitle(name);
        this.validate();
    }

    public void setTitle(String title) {
        this.getPropertiesComponent().setBorder((Border)BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"filtro_de") + " " + PluginServices.getText((Object)this, (String)title), 0, 0, null, null));
    }

    public LayerVisualStatusList getLayerVisualStatus() {
        return this.status;
    }

    public void refreshPreview() {
        this.getPreviewBasePanel().refreshPreview();
    }

    public FLyrRaster getLayer() {
        return this.layer;
    }

    public JCheckBox getCBShowFilters() {
        if (this.jCBShowFilters == null) {
            this.jCBShowFilters = new JCheckBox();
            this.jCBShowFilters.addActionListener(this.getFilterListener());
            this.jCBShowFilters.setSelected(true);
        }
        return this.jCBShowFilters;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void updateNewLayerText() {
        this.getNewLayerPanel().updateNewLayerText();
    }

    public void process(DataSourcePreview rendering) throws ImageUnavailableException {
        if (!this.showPreview) {
            throw new ImageUnavailableException(Messages.getText((String)"panel_preview_not_available"));
        }
        this.getFilterListener().drawImage((FLyrRaster)rendering.getSource());
    }

    public boolean isShowPreview() {
        return this.showPreview;
    }

    public void setShowPreview(boolean showPreview) {
        this.showPreview = showPreview;
    }
}

