/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.geolocation.behavior;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontrol.MapControlDrawer;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Listeners.RectangleListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.ToolListener;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.tool.geolocation.behavior.GeoRasterBehavior;
import org.gvsig.raster.tools.app.basic.tool.geolocation.behavior.ITransformIO;
import org.gvsig.raster.tools.app.basic.tool.geolocation.behavior.TransformationBehavior;

public class ScaleBehavior
extends TransformationBehavior {
    private int PX_SELEC_BASE = 6;
    private int LONG_CORNER_BASE = 12;
    private int PX_SELEC = this.PX_SELEC_BASE;
    private int LONG_CORNER = this.LONG_CORNER_BASE;
    private RectangleListener listener;
    private final Image iconHoriz = IconThemeHelper.getImage((String)"hor-arrow-cursor");
    private final Image iconVert = IconThemeHelper.getImage((String)"ver-arrow-cursor");
    private final Image iconInclDer = IconThemeHelper.getImage((String)"inclder-arrow-cursor");
    private final Image iconInclIzq = IconThemeHelper.getImage((String)"inclizq-arrow-cursor");
    private boolean isResizable = false;
    private double escale = 1.0;
    private boolean[] sideActive = new boolean[]{false, false, false, false, false, false, false, false};
    private boolean init = false;
    private Point2D tmpLr;
    private Point2D tmpUl;
    private double initWidth;
    private double endWidth;

    public ScaleBehavior(GeoRasterBehavior grb, Image curImage, ITransformIO windowIO) {
        this.grBehavior = grb;
        this.defaultImage = curImage;
        this.trIO = windowIO;
    }

    private void init() {
        ViewPort vp = this.grBehavior.getMapControl().getMapContext().getViewPort();
        this.lyr = this.grBehavior.getLayer();
        if (this.lyr == null) {
            return;
        }
        Extent ext = this.lyr.getDataStore().getExtent();
        AffineTransform atImg = this.lyr.getAffineTransform();
        Point2D.Double ul = new Point2D.Double(ext.getULX(), ext.getULY());
        Point2D.Double lr = new Point2D.Double(ext.getLRX(), ext.getLRY());
        Point2D.Double ulPx = new Point2D.Double();
        Point2D.Double lrPx = new Point2D.Double();
        Point2D ulVp = new Point2D.Double();
        Point2D lrVp = new Point2D.Double();
        double esc = 1.0;
        try {
            atImg.inverseTransform(ul, ulPx);
            atImg.inverseTransform(lr, lrPx);
            ulVp = vp.fromMapPoint((Point2D)ul);
            lrVp = vp.fromMapPoint((Point2D)lr);
            esc = Math.abs(((Point2D)lrPx).getX() - ((Point2D)ulPx).getX()) / Math.abs(lrVp.getX() - ulVp.getX());
        }
        catch (NoninvertibleTransformException e1) {
            return;
        }
        this.PX_SELEC = (int)((double)this.PX_SELEC_BASE * esc);
        this.LONG_CORNER = (int)((double)this.LONG_CORNER_BASE * esc);
        this.init = true;
    }

    @Override
    public void paintComponent(MapControlDrawer mapControlDrawer) {
        if (this.isResizable && this.lyr != null) {
            try {
                ViewPort vp = this.grBehavior.getMapControl().getMapContext().getViewPort();
                Point2D.Double ul = new Point2D.Double();
                Point2D.Double lr = new Point2D.Double();
                AffineTransform tr = this.lyr.getAffineTransform();
                tr.transform(this.tmpUl, ul);
                tr.transform(this.tmpLr, lr);
                AffineTransform at = new AffineTransform(tr.getScaleX(), tr.getShearY(), tr.getShearX(), tr.getScaleY(), ((Point2D)ul).getX(), ((Point2D)ul).getY());
                at.preConcatenate(vp.getAffineTransform());
                vp.getAffineTransform().transform(ul, ul);
                at.inverseTransform(ul, ul);
                vp.getAffineTransform().transform(lr, lr);
                at.inverseTransform(lr, lr);
                mapControlDrawer.transform(at);
                mapControlDrawer.setColor(this.rectangleColor);
                mapControlDrawer.setComposite((Composite)AlphaComposite.getInstance(3, 0.1f));
                mapControlDrawer.fillRect((int)((Point2D)ul).getX(), (int)((Point2D)ul).getY(), (int)((Point2D)lr).getX(), (int)((Point2D)lr).getY());
                mapControlDrawer.setComposite((Composite)AlphaComposite.getInstance(3, 1.0f));
                mapControlDrawer.drawRect((int)((Point2D)ul).getX(), (int)((Point2D)ul).getY(), (int)((Point2D)lr).getX(), (int)((Point2D)lr).getY());
                mapControlDrawer.transform(at.createInverse());
            }
            catch (NoninvertibleTransformException e1) {
                RasterSwingLibrary.messageBoxError((String)"error_transformacion1", (Object)this, (Exception)e1);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.setActiveTool(true);
            this.isResizable = true;
            ViewPort vp = this.grBehavior.getMapControl().getMapContext().getViewPort();
            if (this.lyr == null) {
                this.lyr = this.grBehavior.getLayer();
            }
            if (vp != null && this.lyr != null) {
                Extent ext = this.lyr.getFullRasterExtent();
                this.tmpUl = new Point2D.Double(ext.getULX(), ext.getULY());
                this.tmpLr = new Point2D.Double(ext.getLRX(), ext.getLRY());
                try {
                    this.lyr.getAffineTransform().inverseTransform(this.tmpUl, this.tmpUl);
                    this.lyr.getAffineTransform().inverseTransform(this.tmpLr, this.tmpLr);
                }
                catch (NoninvertibleTransformException e1) {
                    e1.printStackTrace();
                }
                this.initWidth = Math.abs(this.tmpUl.getX() - this.tmpLr.getX());
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) throws BehaviorException {
        this.resetBorderSelected();
        if (e.getButton() == 1 && this.isResizable && this.lyr != null) {
            this.endWidth = Math.abs(this.tmpUl.getX() - this.tmpLr.getX());
            this.escale = this.endWidth / this.initWidth;
            AffineTransform tr = (AffineTransform)this.lyr.getAffineTransform().clone();
            Point2D.Double ul = new Point2D.Double();
            Point2D.Double lr = new Point2D.Double();
            tr.transform(this.tmpUl, ul);
            tr.transform(this.tmpLr, lr);
            AffineTransform esc = new AffineTransform(this.escale, 0.0, 0.0, this.escale, 0.0, 0.0);
            AffineTransform at = new AffineTransform(tr.getScaleX(), tr.getShearY(), tr.getShearX(), tr.getScaleY(), ((Point2D)ul).getX(), ((Point2D)ul).getY());
            esc.preConcatenate(at);
            this.lyr.setAffineTransform(esc);
            this.grBehavior.getMapControl().getMapContext().invalidate();
            this.isResizable = false;
            super.mouseReleased(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent ev) {
        if (this.isResizable) {
            if (this.tmpLr == null || this.tmpUl == null || this.lyr == null) {
                return;
            }
            this.setActiveTool(true);
            ViewPort vp = this.grBehavior.getMapControl().getMapContext().getViewPort();
            Point2D e = new Point2D.Double(ev.getX(), ev.getY());
            e = vp.toMapPoint(e);
            try {
                this.lyr.getAffineTransform().inverseTransform(e, e);
            }
            catch (NoninvertibleTransformException e1) {
                e1.printStackTrace();
            }
            double longLadoX = Math.abs(this.tmpLr.getX() - this.tmpUl.getX());
            double longLadoY = Math.abs(this.tmpLr.getY() - this.tmpUl.getY());
            double coordCentroV = this.tmpUl.getY() + Math.abs(this.tmpLr.getY() - this.tmpUl.getY()) / 2.0;
            double coordCentroH = this.tmpUl.getX() + Math.abs(this.tmpLr.getX() - this.tmpUl.getX()) / 2.0;
            if (this.sideActive[2]) {
                double newLadoX = e.getX() - this.tmpUl.getX();
                double newLadoY = newLadoX * longLadoY / longLadoX;
                this.tmpUl = new Point2D.Double(this.tmpUl.getX(), coordCentroV - newLadoY / 2.0);
                this.tmpLr = new Point2D.Double(e.getX(), coordCentroV + newLadoY / 2.0);
            } else if (this.sideActive[3]) {
                double newLadoX = e.getX() - this.tmpLr.getX();
                double newLadoY = newLadoX * longLadoY / longLadoX;
                this.tmpLr = new Point2D.Double(this.tmpLr.getX(), coordCentroV - newLadoY / 2.0);
                this.tmpUl = new Point2D.Double(e.getX(), coordCentroV + newLadoY / 2.0);
            } else if (this.sideActive[1]) {
                double newLadoY = e.getY() - this.tmpUl.getY();
                double newLadoX = newLadoY * longLadoX / longLadoY;
                this.tmpLr = new Point2D.Double(coordCentroH + newLadoX / 2.0, e.getY());
                this.tmpUl = new Point2D.Double(coordCentroH - newLadoX / 2.0, this.tmpUl.getY());
            } else if (this.sideActive[0]) {
                double newLadoY = this.tmpLr.getY() - e.getY();
                double newLadoX = newLadoY * longLadoX / longLadoY;
                this.tmpUl = new Point2D.Double(coordCentroH - newLadoX / 2.0, e.getY());
                this.tmpLr = new Point2D.Double(coordCentroH + newLadoX / 2.0, this.tmpLr.getY());
            } else if (this.sideActive[6]) {
                double rel = longLadoX / longLadoY;
                double difY = e.getY() - this.tmpLr.getY();
                double difX = e.getX() - this.tmpLr.getX();
                if (difX > difY) {
                    difY = difX / rel;
                } else {
                    difX = difY * rel;
                }
                this.tmpUl = new Point2D.Double(this.tmpUl.getX(), this.tmpUl.getY());
                this.tmpLr = new Point2D.Double(this.tmpLr.getX() + difX, this.tmpLr.getY() + difY);
            } else if (this.sideActive[5]) {
                double rel = longLadoX / longLadoY;
                double difY = this.tmpUl.getY() - e.getY();
                double difX = this.tmpUl.getX() - e.getX();
                if (difX > difY) {
                    difY = difX / rel;
                } else {
                    difX = difY * rel;
                }
                this.tmpUl = new Point2D.Double(this.tmpUl.getX() - difX, this.tmpUl.getY() - difY);
                this.tmpLr = new Point2D.Double(this.tmpLr.getX(), this.tmpLr.getY());
            } else if (this.sideActive[4]) {
                double rel = longLadoX / longLadoY;
                double difY = this.tmpUl.getY() - e.getY();
                double difX = e.getX() - this.tmpLr.getX();
                if (difX > difY) {
                    difY = difX / rel;
                } else {
                    difX = difY * rel;
                }
                this.tmpUl = new Point2D.Double(this.tmpUl.getX(), this.tmpUl.getY() - difY);
                this.tmpLr = new Point2D.Double(this.tmpLr.getX() + difX, this.tmpLr.getY());
            } else if (this.sideActive[7]) {
                double rel = longLadoX / longLadoY;
                double difY = e.getY() - this.tmpLr.getY();
                double difX = this.tmpUl.getX() - e.getX();
                if (difX > difY) {
                    difY = difX / rel;
                } else {
                    difX = difY * rel;
                }
                this.tmpUl = new Point2D.Double(this.tmpUl.getX() - difX, this.tmpUl.getY());
                this.tmpLr = new Point2D.Double(this.tmpLr.getX(), this.tmpLr.getY() + difY);
            }
            this.assignTransformToDialog();
            this.grBehavior.getMapControl().repaint();
        }
    }

    public void assignTransformToDialog() {
        Point2D.Double ul = new Point2D.Double();
        Point2D.Double lr = new Point2D.Double();
        AffineTransform tr = this.grBehavior.getLayer().getAffineTransform();
        tr.transform(this.tmpUl, ul);
        tr.transform(this.tmpLr, lr);
        this.endWidth = Math.abs(this.tmpUl.getX() - this.tmpLr.getX());
        this.escale = this.endWidth / this.initWidth;
        AffineTransform esc = new AffineTransform(this.escale, 0.0, 0.0, this.escale, 0.0, 0.0);
        AffineTransform at = new AffineTransform(tr.getScaleX(), tr.getShearY(), tr.getShearX(), tr.getScaleY(), ((Point2D)ul).getX(), ((Point2D)ul).getY());
        esc.preConcatenate(at);
        this.trIO.loadTransform(esc);
    }

    public void setListener(ToolListener listener) {
        this.listener = (RectangleListener)listener;
    }

    public ToolListener getListener() {
        return this.listener;
    }

    @Override
    public boolean mouseMoved(MouseEvent ev) throws BehaviorException {
        if (!this.init) {
            this.init();
        }
        ViewPort vp = this.grBehavior.getMapControl().getMapContext().getViewPort();
        this.resetBorderSelected();
        this.lyr = this.grBehavior.getLayer();
        if (this.lyr == null) {
            this.setActiveTool(false);
            return false;
        }
        AffineTransform atImg = this.lyr.getAffineTransform();
        Point2D e = vp.toMapPoint(ev.getX(), ev.getY());
        try {
            atImg.inverseTransform(e, e);
        }
        catch (NoninvertibleTransformException e1) {
            return false;
        }
        Point2D.Double p1 = new Point2D.Double(0.0, 0.0);
        Point2D.Double p2 = new Point2D.Double(this.lyr.getDataStore().getWidth(), this.lyr.getDataStore().getHeight());
        if (e.getX() < ((Point2D)p1).getX() || e.getX() > ((Point2D)p2).getX() || e.getY() < ((Point2D)p1).getY() || e.getY() > ((Point2D)p2).getY()) {
            this.setActiveTool(false);
            this.grBehavior.getMapControl().repaint();
            return false;
        }
        if (e.getX() > ((Point2D)p1).getX() && e.getX() <= ((Point2D)p1).getX() + (double)this.PX_SELEC && e.getY() > ((Point2D)p1).getY() + (double)this.LONG_CORNER && e.getY() < ((Point2D)p2).getY() - (double)this.LONG_CORNER) {
            this.grBehavior.setCursorImage(this.iconHoriz);
            this.setActiveTool(true);
            this.sideActive[3] = true;
            return true;
        }
        if (e.getX() >= ((Point2D)p2).getX() - (double)this.PX_SELEC && e.getX() < ((Point2D)p2).getX() && e.getY() > ((Point2D)p1).getY() + (double)this.LONG_CORNER && e.getY() < ((Point2D)p2).getY() - (double)this.LONG_CORNER) {
            this.grBehavior.setCursorImage(this.iconHoriz);
            this.setActiveTool(true);
            this.sideActive[2] = true;
            return true;
        }
        if (e.getY() > ((Point2D)p1).getY() && e.getY() <= ((Point2D)p1).getY() + (double)this.PX_SELEC && e.getX() > ((Point2D)p1).getX() + (double)this.LONG_CORNER && e.getX() < ((Point2D)p2).getX() - (double)this.LONG_CORNER) {
            this.grBehavior.setCursorImage(this.iconVert);
            this.setActiveTool(true);
            this.sideActive[0] = true;
            return true;
        }
        if (e.getY() >= ((Point2D)p2).getY() - (double)this.PX_SELEC && e.getY() < ((Point2D)p2).getY() && e.getX() > ((Point2D)p1).getX() + (double)this.LONG_CORNER && e.getX() < ((Point2D)p2).getX() - (double)this.LONG_CORNER) {
            this.grBehavior.setCursorImage(this.iconVert);
            this.setActiveTool(true);
            this.sideActive[1] = true;
            return true;
        }
        if (e.getX() > ((Point2D)p1).getX() && e.getX() <= ((Point2D)p1).getX() + (double)this.LONG_CORNER && e.getY() > ((Point2D)p1).getY() && e.getY() < ((Point2D)p1).getY() + (double)this.PX_SELEC || e.getX() > ((Point2D)p1).getX() && e.getX() <= ((Point2D)p1).getX() + (double)this.PX_SELEC && e.getY() > ((Point2D)p1).getY() && e.getY() <= ((Point2D)p1).getY() + (double)this.LONG_CORNER) {
            if (atImg.getScaleX() * atImg.getScaleY() < 0.0) {
                this.grBehavior.setCursorImage(this.iconInclIzq);
            } else {
                this.grBehavior.setCursorImage(this.iconInclDer);
            }
            this.setActiveTool(true);
            this.sideActive[5] = true;
            return true;
        }
        if (e.getX() >= ((Point2D)p2).getX() - (double)this.LONG_CORNER && e.getX() < ((Point2D)p2).getX() && e.getY() > ((Point2D)p1).getY() && e.getY() < ((Point2D)p1).getY() + (double)this.PX_SELEC || e.getX() >= ((Point2D)p2).getX() - (double)this.PX_SELEC && e.getX() < ((Point2D)p2).getX() && e.getY() > ((Point2D)p1).getY() && e.getY() <= ((Point2D)p1).getY() + (double)this.LONG_CORNER) {
            if (atImg.getScaleX() * atImg.getScaleY() < 0.0) {
                this.grBehavior.setCursorImage(this.iconInclDer);
            } else {
                this.grBehavior.setCursorImage(this.iconInclIzq);
            }
            this.setActiveTool(true);
            this.sideActive[4] = true;
            return true;
        }
        if (e.getX() > ((Point2D)p1).getX() && e.getX() <= ((Point2D)p1).getX() + (double)this.LONG_CORNER && e.getY() >= ((Point2D)p2).getY() - (double)this.PX_SELEC && e.getY() < ((Point2D)p2).getY() || e.getX() > ((Point2D)p1).getX() && e.getX() <= ((Point2D)p1).getX() + (double)this.PX_SELEC && e.getY() < ((Point2D)p2).getY() && e.getY() >= ((Point2D)p2).getY() - (double)this.LONG_CORNER) {
            if (atImg.getScaleX() * atImg.getScaleY() < 0.0) {
                this.grBehavior.setCursorImage(this.iconInclDer);
            } else {
                this.grBehavior.setCursorImage(this.iconInclIzq);
            }
            this.setActiveTool(true);
            this.sideActive[7] = true;
            return true;
        }
        if (e.getX() < ((Point2D)p2).getX() && e.getX() >= ((Point2D)p2).getX() - (double)this.LONG_CORNER && e.getY() >= ((Point2D)p2).getY() - (double)this.PX_SELEC && e.getY() < ((Point2D)p2).getY() || e.getX() < ((Point2D)p2).getX() && e.getX() >= ((Point2D)p2).getX() - (double)this.PX_SELEC && e.getY() < ((Point2D)p2).getY() && e.getY() >= ((Point2D)p2).getY() - (double)this.LONG_CORNER) {
            if (atImg.getScaleX() * atImg.getScaleY() < 0.0) {
                this.grBehavior.setCursorImage(this.iconInclIzq);
            } else {
                this.grBehavior.setCursorImage(this.iconInclDer);
            }
            this.setActiveTool(true);
            this.sideActive[6] = true;
            return true;
        }
        this.grBehavior.resetDefaultCursor();
        this.grBehavior.getMapControl().repaint();
        return false;
    }

    private void resetBorderSelected() {
        for (int i = 0; i < this.sideActive.length; ++i) {
            this.sideActive[i] = false;
        }
    }
}

