/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.geolocation.behavior;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontrol.MapControlDrawer;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Listeners.ToolListener;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.tool.geolocation.behavior.GeoRasterBehavior;
import org.gvsig.raster.tools.app.basic.tool.geolocation.behavior.ITransformIO;
import org.gvsig.raster.tools.app.basic.tool.geolocation.behavior.TransformationBehavior;

public class TranslateBehavior
extends TransformationBehavior {
    private final Image handCursor = IconThemeHelper.getImage((String)"hand-cursor");
    private boolean isMoveable = false;
    private boolean defaultCursorActive = true;
    private Point2D ptoIni = null;
    private Point2D ptoFin = null;

    public TranslateBehavior(GeoRasterBehavior grb, Image curImage, ITransformIO windowIO) {
        this.grBehavior = grb;
        this.defaultImage = curImage;
        this.trIO = windowIO;
    }

    @Override
    public boolean mouseMoved(MouseEvent e) throws BehaviorException {
        ViewPort vp = this.grBehavior.getMapControl().getMapContext().getViewPort();
        try {
            this.lyr = this.grBehavior.getLayer();
            if (this.lyr == null) {
                this.setActiveTool(false);
                return false;
            }
            Point2D pto = vp.toMapPoint(e.getX(), e.getY());
            try {
                if (this.lyr.isInside(pto)) {
                    this.grBehavior.setCursorImage(this.handCursor);
                    this.defaultCursorActive = false;
                    this.setActiveTool(true);
                    return true;
                }
                if (!this.defaultCursorActive) {
                    this.grBehavior.resetDefaultCursor();
                    this.defaultCursorActive = true;
                    this.setActiveTool(false);
                    return false;
                }
            }
            catch (HeadlessException e1) {
                e1.printStackTrace();
            }
            catch (IndexOutOfBoundsException e1) {
                e1.printStackTrace();
            }
        }
        catch (ClassCastException exc) {
            RasterSwingLibrary.messageBoxError((String)"error_capa_puntos", (Object)this, (Exception)exc);
        }
        this.setActiveTool(false);
        return false;
    }

    @Override
    public void mousePressed(MouseEvent e) throws BehaviorException {
        if (e.getButton() == 1 && !this.defaultCursorActive) {
            this.setActiveTool(true);
            this.lyr = this.grBehavior.getLayer();
            if (this.lyr == null) {
                return;
            }
            ViewPort vp = this.grBehavior.getMapControl().getMapContext().getViewPort();
            this.ptoIni = vp.toMapPoint((Point2D)e.getPoint());
            this.isMoveable = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) throws BehaviorException {
        if (!this.isActiveTool()) {
            return;
        }
        if (e.getButton() == 1 && this.isMoveable) {
            FLyrRaster lyr = this.grBehavior.getLayer();
            if (lyr == null) {
                return;
            }
            ViewPort vp = this.grBehavior.getMapControl().getMapContext().getViewPort();
            this.ptoFin = vp.toMapPoint((Point2D)e.getPoint());
            AffineTransform atOld = lyr.getAffineTransform();
            AffineTransform atNew = null;
            double distX = this.ptoFin.getX() - this.ptoIni.getX();
            double distY = this.ptoFin.getY() - this.ptoIni.getY();
            atNew = new AffineTransform(atOld.getScaleX(), atOld.getShearY(), atOld.getShearX(), atOld.getScaleY(), atOld.getTranslateX() + distX, atOld.getTranslateY() + distY);
            lyr.setAffineTransform(atNew);
            this.grBehavior.getMapControl().getMapContext().invalidate();
            this.isMoveable = false;
            super.mouseReleased(e);
        }
    }

    @Override
    public void paintComponent(MapControlDrawer mapControlDrawer) {
        if (this.isMoveable && this.lyr != null && this.ptoFin != null && this.ptoIni != null) {
            try {
                ViewPort vp = this.grBehavior.getMapControl().getMapContext().getViewPort();
                AffineTransform at = (AffineTransform)this.lyr.getAffineTransform().clone();
                at.preConcatenate(vp.getAffineTransform());
                Extent ext = this.lyr.getFullRasterExtent();
                Point2D.Double pt = new Point2D.Double(ext.getULX(), ext.getULY());
                vp.getAffineTransform().transform(pt, pt);
                at.inverseTransform(pt, pt);
                Point2D.Double size = new Point2D.Double(ext.getLRX(), ext.getLRY());
                vp.getAffineTransform().transform(size, size);
                at.inverseTransform(size, size);
                double distX = this.ptoFin.getX() - this.ptoIni.getX();
                double distY = this.ptoFin.getY() - this.ptoIni.getY();
                Point2D.Double d = new Point2D.Double(ext.getULX() + distX, ext.getULY() + distY);
                vp.getAffineTransform().transform(d, d);
                at.inverseTransform(d, d);
                mapControlDrawer.transform(at);
                mapControlDrawer.setColor(this.rectangleColor);
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.1f);
                mapControlDrawer.setComposite((Composite)alpha);
                mapControlDrawer.fillRect((int)((Point2D)pt).getX() + (int)((Point2D)d).getX(), (int)((Point2D)pt).getY() + (int)((Point2D)d).getY(), (int)((Point2D)size).getX(), (int)((Point2D)size).getY());
                mapControlDrawer.setComposite((Composite)AlphaComposite.getInstance(3, 1.0f));
                mapControlDrawer.drawRect((int)((Point2D)pt).getX() + (int)((Point2D)d).getX(), (int)((Point2D)pt).getY() + (int)((Point2D)d).getY(), (int)((Point2D)size).getX(), (int)((Point2D)size).getY());
                mapControlDrawer.transform(at.createInverse());
            }
            catch (NoninvertibleTransformException e1) {
                RasterSwingLibrary.messageBoxError((String)"error_transformacion1", (Object)this, (Exception)e1);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) throws BehaviorException {
        if (!this.isActiveTool()) {
            return;
        }
        if (this.isMoveable) {
            ViewPort vp = this.grBehavior.getMapControl().getMapContext().getViewPort();
            this.ptoFin = vp.toMapPoint((Point2D)e.getPoint());
            this.assignTransformToDialog();
            this.grBehavior.getMapControl().repaint();
        }
    }

    public void assignTransformToDialog() {
        AffineTransform atNew = null;
        double distX = this.ptoFin.getX() - this.ptoIni.getX();
        double distY = this.ptoFin.getY() - this.ptoIni.getY();
        AffineTransform atOld = this.grBehavior.getLayer().getAffineTransform();
        atNew = new AffineTransform(atOld.getScaleX(), atOld.getShearY(), atOld.getShearX(), atOld.getScaleY(), atOld.getTranslateX() + distX, atOld.getTranslateY() + distY);
        this.trIO.loadTransform(atNew);
    }

    public ToolListener getListener() {
        return null;
    }
}

