/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.geolocation.listener;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.EventObject;
import javax.swing.filechooser.FileFilter;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.RmfSerializerException;
import org.gvsig.fmap.dal.coverage.util.Historical;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.gui.beans.datainput.DataInputContainerListener;
import org.gvsig.gui.beans.swing.JFileChooser;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.tool.geolocation.ui.GeoLocationDialog;
import org.gvsig.raster.tools.app.basic.tool.geolocation.ui.GeoLocationOpeningRasterPanel;
import org.gvsig.raster.tools.app.basic.tool.geolocation.ui.GeoLocationPanel;
import org.gvsig.raster.tools.app.basic.tool.geolocation.ui.GeolocationBaseClassPanel;
import org.gvsig.raster.util.ExtendedFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoLocationPanelListener
implements ActionListener,
DataInputContainerListener,
KeyListener {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(GeoLocationPanelListener.class);
    private GeolocationBaseClassPanel panel = null;
    private boolean enableValueChangeEvent = false;
    private GeoLocationDialog dialog = null;
    private RasterManager rManager = RasterLocator.getManager();

    public GeoLocationPanelListener(GeolocationBaseClassPanel panel, GeoLocationDialog dialog) {
        this.dialog = dialog;
        this.panel = panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Historical hist;
        if (e.getSource() == this.panel.getSaveButton()) {
            if (RasterSwingLibrary.messageBoxYesOrNot((String)Messages.getText((String)"aviso_write_transform"), (Object)this.panel)) {
                try {
                    this.panel.getLayer().saveGeoToRmf();
                    this.panel.activeButtons();
                }
                catch (RmfSerializerException e1) {
                    RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"error_salvando_rmf"), (Object)this.panel, (Exception)((Object)e1));
                }
                this.panel.setModify(false);
            }
            return;
        }
        if (e.getSource() == this.panel.getApplyButton()) {
            try {
                double ulx = Double.parseDouble(this.panel.getUlx().getValue());
                double uly = Double.parseDouble(this.panel.getUly().getValue());
                double psx = Double.parseDouble(this.panel.getPsx().getValue());
                double psy = Double.parseDouble(this.panel.getPsy().getValue());
                double rotx = Double.parseDouble(this.panel.getRotx().getValue());
                double roty = Double.parseDouble(this.panel.getRoty().getValue());
                if (psx == 0.0 || psy == 0.0) {
                    return;
                }
                AffineTransform at = new AffineTransform(psx, roty, rotx, psy, ulx, uly);
                this.panel.getLayer().setAffineTransform(at);
                this.panel.setModify(true);
                if (this.panel.getMapCtrl() != null) {
                    this.panel.getMapCtrl().getMapContext().invalidate();
                } else if (this.panel instanceof GeoLocationOpeningRasterPanel) {
                    PluginServices.getMDIManager().closeWindow((IWindow)((GeoLocationOpeningRasterPanel)this.panel).getDialog());
                }
                this.panel.activeButtons();
                return;
            }
            catch (NumberFormatException ex) {
                RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"error_transformacion"), (Object)this.panel);
                return;
            }
        }
        if (e.getSource() == this.panel.getCancelButton()) {
            PluginServices.getMDIManager().closeWindow((IWindow)((GeoLocationOpeningRasterPanel)this.panel).getDialog());
        }
        if ((hist = this.panel.getHistorical()) == null) {
            return;
        }
        AffineTransform at = null;
        if (e.getSource() == this.panel.getFirstButton()) {
            at = (AffineTransform)hist.getFirst();
        }
        if (e.getSource() == this.panel.getBackButton()) {
            at = (AffineTransform)hist.getBack();
        }
        if (e.getSource() == this.panel.getNextButton()) {
            at = (AffineTransform)hist.getNext();
        }
        if (e.getSource() == this.panel.getResetButton()) {
            at = this.panel.getLayer().getDataStore().getOwnAffineTransform();
        }
        if (e.getSource() == this.panel.getTfwLoad()) {
            JFileChooser chooser = new JFileChooser("GEO_LOCATION_PANEL_LISTENER", JFileChooser.getLastPath((String)"GEO_LOCATION_PANEL_LISTENER", null));
            chooser.setDialogTitle(PluginServices.getText((Object)this, (String)"seleccionar_fichero"));
            chooser.addChoosableFileFilter((FileFilter)new ExtendedFileFilter("tfw"));
            chooser.addChoosableFileFilter((FileFilter)new ExtendedFileFilter("wld"));
            ExtendedFileFilter allFilters = new ExtendedFileFilter();
            allFilters.addExtension("tfw");
            allFilters.addExtension("wld");
            allFilters.setDescription(PluginServices.getText((Object)this, (String)"todos_soportados"));
            chooser.addChoosableFileFilter((FileFilter)allFilters);
            chooser.setFileFilter((FileFilter)allFilters);
            int returnVal = chooser.showOpenDialog((Component)this.panel);
            if (returnVal == 0) {
                String fName = chooser.getSelectedFile().toString();
                at = this.readTfw(fName);
            }
            JFileChooser.setLastPath((String)"GEO_LOCATION_PANEL_LISTENER", (File)chooser.getSelectedFile());
        }
        if (e.getSource() == this.panel.getCenterToView()) {
            Extent extentView = this.calcCenterExtent(this.panel.getViewPort());
            double x = extentView.minX();
            double y = extentView.maxY();
            double psX = extentView.width() / this.panel.getLayer().getDataStore().getWidth();
            double psY = -(extentView.height() / this.panel.getLayer().getDataStore().getHeight());
            at = new AffineTransform(psX, 0.0, 0.0, psY, x, y);
            this.panel.setModify(true);
        }
        if (e.getSource() == this.panel.getFocus() && this.dialog != null) {
            AbstractViewPanel theView = this.dialog.getAssociateView();
            MapControl mapCtrl = theView.getMapControl();
            mapCtrl.setTool("geoPan");
        }
        if (at != null) {
            this.panel.getLayer().setAffineTransformWithoutHistorical(at);
            this.panel.loadTransform(at);
            this.panel.activeButtons();
            if (this.panel.getMapCtrl() != null) {
                this.panel.getMapCtrl().getMapContext().invalidate();
            }
        }
    }

    public void actionValueChanged(EventObject e) {
        if (this.isEnableValueChangeEvent() && this.panel instanceof GeoLocationPanel) {
            ActionEvent ev = new ActionEvent(this.panel.getApplyButton(), 0, null);
            this.actionPerformed(ev);
        }
    }

    public boolean isEnableValueChangeEvent() {
        return this.enableValueChangeEvent;
    }

    public void setEnableValueChangeEvent(boolean enableValueChangeEvent) {
        this.enableValueChangeEvent = enableValueChangeEvent;
    }

    private Extent calcCenterExtent(ViewPort vp) {
        Extent tempExtent = null;
        double widthPxImg = this.panel.getLayer().getDataStore().getWidth();
        double heightPxImg = this.panel.getLayer().getDataStore().getHeight();
        if (vp == null || vp.getAdjustedExtent() == null) {
            vp = new ViewPort(null);
            try {
                Envelope r2d = geomManager.createEnvelope(0.0, 0.0, widthPxImg, heightPxImg, 0);
                vp.setEnvelope(r2d);
            }
            catch (CreateEnvelopeException e) {
                logger.error("Error creating the envelope", (Throwable)e);
            }
            tempExtent = this.rManager.getDataStructFactory().createExtent(0.0, 0.0, widthPxImg, heightPxImg);
        } else {
            Envelope env = vp.getAdjustedExtent();
            tempExtent = this.rManager.getDataStructFactory().createExtent((Rectangle2D)new Rectangle2D.Double(env.getMinimum(0), env.getMinimum(1), env.getLength(0), env.getLength(1)));
        }
        double ulX = 0.0;
        double ulY = 0.0;
        double lrX = 0.0;
        double lrY = 0.0;
        if (widthPxImg > heightPxImg) {
            double widthView = tempExtent.maxX() - tempExtent.minX();
            ulX = tempExtent.minX() + widthView / 4.0;
            lrX = ulX + widthView / 2.0;
            double newAlto = heightPxImg * (widthView / 2.0) / widthPxImg;
            double centroY = tempExtent.minY() + (tempExtent.maxY() - tempExtent.minY()) / 2.0;
            ulY = centroY - newAlto / 2.0;
            lrY = centroY + newAlto / 2.0;
        } else {
            double heightView = tempExtent.maxY() - tempExtent.minY();
            ulY = tempExtent.minY() + heightView / 4.0;
            lrY = ulY + heightView / 2.0;
            double newAncho = widthPxImg * (heightView / 2.0) / heightPxImg;
            double centroX = tempExtent.minX() + (tempExtent.maxX() - tempExtent.minX()) / 2.0;
            ulX = centroX - newAncho / 2.0;
            lrX = centroX + newAncho / 2.0;
        }
        return this.rManager.getDataStructFactory().createExtent(ulX, ulY, lrX, lrY);
    }

    private AffineTransform readTfw(String fName) {
        BufferedReader inGrf = null;
        double[] result = new double[6];
        try {
            inGrf = new BufferedReader(new InputStreamReader(new FileInputStream(fName)));
            String str = inGrf.readLine();
            for (int count = 0; str != null && count < 6; ++count) {
                try {
                    Double value = new Double(str);
                    result[count] = value;
                }
                catch (NumberFormatException ex) {
                    RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"error_file_not_valid"), (Object)this.panel, (Exception)ex);
                    inGrf.close();
                    return null;
                }
                str = inGrf.readLine();
            }
            inGrf.close();
        }
        catch (FileNotFoundException e) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"error_file_not_found"), (Object)this.panel, (Exception)e);
            return null;
        }
        catch (IOException ex) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"error_lectura"), (Object)this.panel, (Exception)ex);
            return null;
        }
        return new AffineTransform(result[0], result[1], result[2], result[3], result[4], result[5]);
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        ActionEvent ev;
        if (e.getKeyCode() == 10) {
            ev = new ActionEvent(this.panel.getApplyButton(), 0, null);
            this.actionPerformed(ev);
        }
        if (e.getKeyCode() == 27 && this.panel.getCancelButton() != null) {
            ev = new ActionEvent(this.panel.getCancelButton(), 0, null);
            this.actionPerformed(ev);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

