/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.geolocation.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import javax.swing.JPanel;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.IWindowListener;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.fmap.dal.coverage.exception.RmfSerializerException;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.tool.geolocation.behavior.ITransformIO;
import org.gvsig.raster.tools.app.basic.tool.geolocation.ui.GeoLocationPanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class GeoLocationDialog
extends JPanel
implements IWindow,
IWindowListener,
ITransformIO {
    private static final long serialVersionUID = 7362459094802955247L;
    private GeoLocationPanel geolocationPanel = null;
    private int posWindowX = 0;
    private int posWindowY = 0;
    private int widthWindow = 272;
    private int heightWindow = 155;
    private String lastTool = null;
    private AbstractViewPanel view = null;

    public GeoLocationDialog() {
        BorderLayout bl = new BorderLayout(5, 5);
        this.setLayout(bl);
        this.add(this.getGeoLocationPanel());
    }

    public GeoLocationDialog(FLyrRaster lyr, ViewPort vp, AbstractViewPanel view) {
        this.view = view;
        BorderLayout bl = new BorderLayout(5, 5);
        this.setLayout(bl);
        this.add(this.getGeoLocationPanel());
        this.getGeoLocationPanel().setParams(lyr, vp);
    }

    public AbstractViewPanel getAssociateView() {
        return this.view;
    }

    public void setPosition(int x, int y) {
        this.posWindowX = x;
        this.posWindowY = y;
    }

    public Dimension getSizeWindow() {
        return new Dimension(this.widthWindow, this.heightWindow);
    }

    private void loadLayer(ViewPort vp) {
        if (this.getGeoLocationPanel().getLayer() != null) {
            return;
        }
        FLayers flyrs = this.getGeoLocationPanel().getMapCtrl().getMapContext().getLayers();
        FLayer[] actives = flyrs.getActives();
        for (int i = 0; i < actives.length; ++i) {
            if (!(actives[i] instanceof FLyrRaster)) continue;
            this.getGeoLocationPanel().setParams((FLyrRaster)actives[i], vp);
            break;
        }
    }

    public void init(MapControl mapCtrl) {
        this.geolocationPanel.setMapCtrl(mapCtrl);
        this.lastTool = mapCtrl.getCurrentTool();
        this.loadLayer(mapCtrl.getViewPort());
        FLyrRaster lyr = this.getGeoLocationPanel().getLayer();
        if (lyr != null) {
            lyr.getAffineTransformHistorical().clear();
            lyr.getAffineTransformHistorical().add((Object)lyr.getDataStore().getAffineTransform());
            this.loadTransform(lyr.getDataStore().getAffineTransform());
        }
        this.activeButtons();
    }

    @Override
    public void loadTransform(AffineTransform at) {
        this.geolocationPanel.loadTransform(at);
    }

    @Override
    public void applyTransformation() {
        this.geolocationPanel.setModify(true);
        this.geolocationPanel.activeButtons();
    }

    public GeoLocationPanel getGeoLocationPanel() {
        if (this.geolocationPanel == null) {
            this.geolocationPanel = new GeoLocationPanel(this);
        }
        return this.geolocationPanel;
    }

    public void activeButtons() {
        this.getGeoLocationPanel().activeButtons();
    }

    public WindowInfo getWindowInfo() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowInfo m_viewinfo = new WindowInfo(17);
        m_viewinfo.setHeight(this.heightWindow);
        m_viewinfo.setWidth(this.widthWindow);
        m_viewinfo.setX(this.posWindowX);
        m_viewinfo.setY(this.posWindowY);
        m_viewinfo.setTitle(i18n.getTranslation("geolocation"));
        return m_viewinfo;
    }

    public void setLastTool(String tool) {
        this.lastTool = tool;
    }

    public void windowActivated() {
    }

    public void windowClosed() {
        if (this.geolocationPanel.getModify()) {
            if (RasterSwingLibrary.messageBoxYesOrNot((String)PluginServices.getText((Object)this, (String)"aviso_salir_salvando"), (Object)this.geolocationPanel)) {
                try {
                    this.geolocationPanel.getLayer().saveGeoToRmf();
                }
                catch (RmfSerializerException e1) {
                    RasterSwingLibrary.messageBoxError((String)PluginServices.getText((Object)this, (String)"error_salvando_rmf"), (Object)this.geolocationPanel, (Exception)((Object)e1));
                }
            }
            this.geolocationPanel.setModify(false);
        }
        if (this.lastTool != null) {
            this.getGeoLocationPanel().getMapCtrl().setTool(this.lastTool);
        }
    }

    public Object getWindowProfile() {
        return WindowInfo.PROPERTIES_PROFILE;
    }
}

