/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.geolocation.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.util.Historical;
import org.gvsig.fmap.dal.coverage.util.MathUtils;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.gui.beans.datainput.DataInputContainer;
import org.gvsig.gui.beans.datainput.DataInputContainerListener;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.tools.app.basic.tool.geolocation.listener.GeoLocationPanelListener;
import org.gvsig.raster.tools.app.basic.tool.geolocation.ui.GeoLocationDialog;
import org.gvsig.raster.tools.app.basic.tool.geolocation.ui.GeolocationBaseClassPanel;

public class GeoLocationPanel
extends GeolocationBaseClassPanel {
    private static final long serialVersionUID = -7797379892312214949L;
    private DataInputContainer ulx = null;
    private DataInputContainer uly = null;
    private DataInputContainer psx = null;
    private DataInputContainer psy = null;
    private DataInputContainer rotx = null;
    private DataInputContainer roty = null;
    private JButton first = null;
    private JButton save = null;
    private JButton back = null;
    private JButton next = null;
    private JButton apply = null;
    private JButton reset = null;
    private JButton tfwload = null;
    private JButton center = null;
    private JButton focus = null;
    private JPanel coordsPanel = null;
    private JPanel paramsPanel = null;
    private JPanel buttonsPanel = null;

    public GeoLocationPanel(GeoLocationDialog dialog) {
        ImageIcon backIcon = null;
        ImageIcon nextIcon = null;
        ImageIcon saveIcon = null;
        ImageIcon firstIcon = null;
        ImageIcon resetIcon = null;
        ImageIcon tfwLoadIcon = null;
        ImageIcon centerRasterIcon = null;
        ImageIcon focusIcon = null;
        try {
            backIcon = IconThemeHelper.getImageIcon((String)"back-icon");
            nextIcon = IconThemeHelper.getImageIcon((String)"next-icon");
            saveIcon = IconThemeHelper.getImageIcon((String)"layer-saveas");
            firstIcon = IconThemeHelper.getImageIcon((String)"undo-icon");
            resetIcon = IconThemeHelper.getImageIcon((String)"reset-icon");
            centerRasterIcon = IconThemeHelper.getImageIcon((String)"centerraster-icon");
            tfwLoadIcon = IconThemeHelper.getImageIcon((String)"tfwload-icon");
            focusIcon = IconThemeHelper.getImageIcon((String)"focus-icon");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.listener = new GeoLocationPanelListener(this, dialog);
        GridBagLayout gl = new GridBagLayout();
        this.setLayout(gl);
        this.ulx = new DataInputContainer();
        this.ulx.setLabelText(PluginServices.getText((Object)this, (String)"ux"));
        this.ulx.addValueChangedListener((DataInputContainerListener)this.listener);
        this.uly = new DataInputContainer();
        this.uly.setLabelText(PluginServices.getText((Object)this, (String)"uy"));
        this.uly.addValueChangedListener((DataInputContainerListener)this.listener);
        this.psx = new DataInputContainer();
        this.psx.setLabelText(PluginServices.getText((Object)this, (String)"px"));
        this.psx.addValueChangedListener((DataInputContainerListener)this.listener);
        this.psy = new DataInputContainer();
        this.psy.setLabelText(PluginServices.getText((Object)this, (String)"py"));
        this.psy.addValueChangedListener((DataInputContainerListener)this.listener);
        this.rotx = new DataInputContainer();
        this.rotx.setLabelText(PluginServices.getText((Object)this, (String)"rx"));
        this.rotx.addValueChangedListener((DataInputContainerListener)this.listener);
        this.roty = new DataInputContainer();
        this.roty.setLabelText(PluginServices.getText((Object)this, (String)"ry"));
        this.roty.addValueChangedListener((DataInputContainerListener)this.listener);
        this.first = new JButton(firstIcon);
        this.save = new JButton(saveIcon);
        this.back = new JButton(backIcon);
        this.next = new JButton(nextIcon);
        this.apply = new JButton(PluginServices.getText((Object)this, (String)"apply"));
        this.reset = new JButton(resetIcon);
        this.tfwload = new JButton(tfwLoadIcon);
        this.center = new JButton(centerRasterIcon);
        this.focus = new JButton(focusIcon);
        this.save.setToolTipText(PluginServices.getText((Object)this, (String)"salvar_transf"));
        this.back.setToolTipText(PluginServices.getText((Object)this, (String)"back_transf"));
        this.next.setToolTipText(PluginServices.getText((Object)this, (String)"next_transf"));
        this.apply.setToolTipText(PluginServices.getText((Object)this, (String)"aplicar_transf"));
        this.first.setToolTipText(PluginServices.getText((Object)this, (String)"first_transf"));
        this.reset.setToolTipText(PluginServices.getText((Object)this, (String)"reset_transf"));
        this.center.setToolTipText(PluginServices.getText((Object)this, (String)"center_raster"));
        this.tfwload.setToolTipText(PluginServices.getText((Object)this, (String)"tfw_load"));
        this.focus.setToolTipText(PluginServices.getText((Object)this, (String)"get_tool_focus"));
        this.save.setPreferredSize(new Dimension(28, 24));
        this.first.setPreferredSize(new Dimension(28, 24));
        this.back.setPreferredSize(new Dimension(28, 24));
        this.next.setPreferredSize(new Dimension(28, 24));
        this.apply.setPreferredSize(new Dimension(64, 24));
        this.reset.setPreferredSize(new Dimension(28, 24));
        this.center.setPreferredSize(new Dimension(28, 24));
        this.tfwload.setPreferredSize(new Dimension(28, 24));
        this.focus.setPreferredSize(new Dimension(28, 24));
        this.first.addActionListener(this.listener);
        this.save.addActionListener(this.listener);
        this.back.addActionListener(this.listener);
        this.next.addActionListener(this.listener);
        this.apply.addActionListener(this.listener);
        this.reset.addActionListener(this.listener);
        this.tfwload.addActionListener(this.listener);
        this.center.addActionListener(this.listener);
        this.focus.addActionListener(this.listener);
        this.save.setEnabled(false);
        this.back.setEnabled(false);
        this.next.setEnabled(false);
        this.first.setEnabled(false);
        this.reset.setEnabled(true);
        this.center.setEnabled(true);
        this.tfwload.setEnabled(true);
        this.focus.setEnabled(true);
        this.coordsPanel = new JPanel();
        GridLayout l = new GridLayout(2, 1);
        l.setVgap(2);
        this.coordsPanel.setLayout(l);
        this.paramsPanel = new JPanel();
        GridLayout l1 = new GridLayout(2, 2);
        l1.setVgap(2);
        this.paramsPanel.setLayout(l1);
        this.getButtonsPanel();
        this.init();
    }

    private void init() {
        this.coordsPanel.add((Component)this.ulx);
        this.coordsPanel.add((Component)this.uly);
        this.paramsPanel.add((Component)this.psx);
        this.paramsPanel.add((Component)this.psy);
        this.paramsPanel.add((Component)this.rotx);
        this.paramsPanel.add((Component)this.roty);
        JPanel smallButtons = new JPanel();
        smallButtons.setLayout(new GridBagLayout());
        JPanel applyButton = new JPanel();
        applyButton.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(1, 0, 0, 2);
        smallButtons.add((Component)this.focus, gbc);
        gbc.gridx = 1;
        smallButtons.add((Component)this.center, gbc);
        gbc.gridx = 2;
        smallButtons.add((Component)this.reset, gbc);
        gbc.gridx = 3;
        smallButtons.add((Component)this.first, gbc);
        gbc.gridx = 4;
        smallButtons.add((Component)this.back, gbc);
        gbc.gridx = 5;
        smallButtons.add((Component)this.next, gbc);
        gbc.gridx = 6;
        smallButtons.add((Component)this.tfwload, gbc);
        gbc.gridx = 7;
        smallButtons.add((Component)this.save, gbc);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        applyButton.add((Component)this.apply, gbc);
        this.buttonsPanel.add((Component)smallButtons, gbc);
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        this.buttonsPanel.add((Component)applyButton, gbc);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.coordsPanel, gbc);
        gbc.gridy = 1;
        this.add((Component)this.paramsPanel, gbc);
        gbc.weightx = 1.0;
        gbc.gridy = 2;
        this.add((Component)this.buttonsPanel, gbc);
    }

    public JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setLayout(new GridBagLayout());
        }
        return this.buttonsPanel;
    }

    @Override
    public void activeButtons() {
        Historical affineTransformHist = this.getLayer().getAffineTransformHistorical();
        if (!affineTransformHist.existNext()) {
            this.next.setEnabled(false);
        } else {
            this.next.setEnabled(true);
        }
        if (!affineTransformHist.existBack()) {
            this.back.setEnabled(false);
        } else {
            this.back.setEnabled(true);
        }
        if (affineTransformHist.getElementsCount() <= 1) {
            this.first.setEnabled(false);
        } else {
            this.first.setEnabled(true);
        }
        if (affineTransformHist.getElementsCount() == 0) {
            this.save.setEnabled(false);
        } else {
            this.save.setEnabled(true);
        }
    }

    public void setParams(FLyrRaster lyr, ViewPort vp) {
        this.setLayer(lyr);
        this.setViewPort(vp);
        this.loadTransform(lyr.getDataStore().getAffineTransform());
    }

    @Override
    public void loadTransform(AffineTransform at) {
        this.listener.setEnableValueChangeEvent(false);
        MathUtils math = RasterLocator.getManager().getMathUtils();
        this.setUlx(String.valueOf(math.format(at.getTranslateX(), this.tailValue)));
        this.setUly(String.valueOf(math.format(at.getTranslateY(), this.tailValue)));
        this.setPsx(String.valueOf(math.format(at.getScaleX(), this.tailValue)));
        this.setPsy(String.valueOf(math.format(at.getScaleY(), this.tailValue)));
        this.setRotx(String.valueOf(math.format(at.getShearX(), this.tailValue)));
        this.setRoty(String.valueOf(math.format(at.getShearY(), this.tailValue)));
        this.listener.setEnableValueChangeEvent(true);
    }

    public void setPsx(String psx) {
        this.psx.setValue(psx);
    }

    public void setPsy(String psy) {
        this.psy.setValue(psy);
    }

    public void setRotx(String rotx) {
        this.rotx.setValue(rotx);
    }

    public void setRoty(String roty) {
        this.roty.setValue(roty);
    }

    public void setUlx(String ulx) {
        this.ulx.setValue(ulx);
    }

    public void setUly(String uly) {
        this.uly.setValue(uly);
    }

    @Override
    public JButton getApplyButton() {
        return this.apply;
    }

    @Override
    public JButton getBackButton() {
        return this.back;
    }

    @Override
    public JButton getFirstButton() {
        return this.first;
    }

    @Override
    public JButton getSaveButton() {
        return this.save;
    }

    @Override
    public JButton getResetButton() {
        return this.reset;
    }

    @Override
    public JButton getNextButton() {
        return this.next;
    }

    @Override
    public JButton getTfwLoad() {
        return this.tfwload;
    }

    @Override
    public JButton getCenterToView() {
        return this.center;
    }

    @Override
    public JButton getFocus() {
        return this.focus;
    }

    @Override
    public DataInputContainer getPsx() {
        return this.psx;
    }

    @Override
    public DataInputContainer getPsy() {
        return this.psy;
    }

    @Override
    public DataInputContainer getRotx() {
        return this.rotx;
    }

    @Override
    public DataInputContainer getRoty() {
        return this.roty;
    }

    @Override
    public DataInputContainer getUlx() {
        return this.ulx;
    }

    @Override
    public DataInputContainer getUly() {
        return this.uly;
    }
}

