/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.histogram;

import javax.swing.Icon;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.toc.AbstractTocContextMenuAction;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.layers.ILayerState;
import org.gvsig.raster.fmap.layers.IRasterLayerActions;
import org.gvsig.raster.mainplugin.toolbar.IGenericToolBarMenuItem;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.RasterToolsUtil;
import org.gvsig.raster.tools.app.basic.tool.histogram.ui.HistogramDialog;

public class HistogramTocMenuEntry
extends AbstractTocContextMenuAction
implements IGenericToolBarMenuItem {
    private static HistogramTocMenuEntry singleton = null;

    private HistogramTocMenuEntry() {
    }

    public static HistogramTocMenuEntry getSingleton() {
        if (singleton == null) {
            singleton = new HistogramTocMenuEntry();
        }
        return singleton;
    }

    public String getGroup() {
        return "RasterLayer";
    }

    public int getGroupOrder() {
        return 10;
    }

    public int getOrder() {
        return 30;
    }

    public String getText() {
        return RasterToolsUtil.getText((Object)this, "histograma");
    }

    public boolean isEnabled(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        if (selectedItems[0] instanceof ILayerState) {
            return ((ILayerState)selectedItems[0]).isOpen();
        }
        return false;
    }

    public boolean isVisible(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        if (!(selectedItems[0] instanceof FLyrRaster)) {
            return false;
        }
        return ((IRasterLayerActions)selectedItems[0]).isActionEnabled(2);
    }

    public void execute(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return;
        }
        if (!(selectedItems[0] instanceof FLyrRaster)) {
            return;
        }
        FLyrRaster fLayer = (FLyrRaster)selectedItems[0];
        try {
            HistogramDialog histogramDialog = null;
            histogramDialog = new HistogramDialog(650, 500);
            histogramDialog.setLayer(fLayer);
            histogramDialog.getHistogramPanel().firstRun();
            histogramDialog.setVisible(true);
            PluginServices.getMDIManager().addCentredWindow((IWindow)histogramDialog);
        }
        catch (Exception e) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"histogram_error"), (Object)((Object)this), (Exception)e);
            return;
        }
    }

    public Icon getIcon() {
        return RasterToolsUtil.getIcon("layer-histogram");
    }
}

