/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.histogram.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.store.props.HistogramComputer;
import org.gvsig.fmap.dal.coverage.util.MathUtils;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelEvent;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelListener;
import org.gvsig.gui.beans.defaultbuttonspanel.DefaultButtonsPanel;
import org.gvsig.gui.beans.graphic.GraphicContainer;
import org.gvsig.gui.beans.table.TableContainer;
import org.gvsig.gui.beans.table.exceptions.NotInitializeException;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.tools.app.basic.tool.histogram.HistogramPanelListener;

public class HistogramPanel
extends DefaultButtonsPanel
implements ButtonsPanelListener {
    private static final long serialVersionUID = 2772897994667886753L;
    private MathUtils math = RasterLocator.getManager().getMathUtils();
    private HistogramPanelListener histogramPanelListener = null;
    private ArrayList comboSource = new ArrayList();
    public boolean panelInizialited = false;
    private JComboBox comboBoxSource = null;
    private JComboBox comboBoxType = null;
    private JButton bTable = null;
    private JPanel panelNorth = null;
    private JPanel panelSouth = null;
    private JButton buttonShowAll = null;
    private JButton buttonClean = null;
    private JTable jTableBands = null;
    private JCheckBox checkBoxDeleteEdges = null;
    private JCheckBox checkBoxRGB = null;
    private TableContainer tableContainer = null;
    private GraphicContainer graphicContainer = null;
    private int dataType = 0;

    public HistogramPanel() {
        super(8);
        this.getButtonsPanel().addHideDetails();
        this.getButtonsPanel().addSeeDetails();
        this.getButtonsPanel().getButton(8).setVisible(false);
        this.getButtonsPanel().getButton(8).setText(PluginServices.getText((Object)((Object)this), (String)"mostrar_estadisticas"));
        this.getButtonsPanel().getButton(9).setText(PluginServices.getText((Object)((Object)this), (String)"ocultar_estadisticas"));
        this.getButtonsPanel().addClose();
        this.addButtonPressedListener(this);
        this.histogramPanelListener = this.getHistogramPanelListener();
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout(5, 5));
        this.add(this.getPanelNorth(), "North");
        this.add((Component)this.getGraphicContainer(), "Center");
        this.add(this.getPanelSouth(), "South");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getHistogramPanelListener().setControlListeners();
    }

    public ArrayList getComboSource() {
        return this.comboSource;
    }

    private void setHistogramableSource(HistogramComputer source, String name) {
        this.getHistogramPanelListener().eventsEnabled = false;
        ArrayList<Object> aux = new ArrayList<Object>();
        aux.add(source);
        aux.add(name);
        this.getComboSource().add(aux);
        this.updateComboBoxSource();
        this.getHistogramPanelListener().eventsEnabled = this.panelInizialited;
    }

    private void updateComboBoxSource() {
        this.getHistogramPanelListener().eventsEnabled = false;
        this.getComboBoxSource().removeAllItems();
        for (int i = 0; i < this.getComboSource().size(); ++i) {
            this.getComboBoxSource().addItem(((ArrayList)this.getComboSource().get(i)).get(1));
        }
        this.getHistogramPanelListener().eventsEnabled = this.panelInizialited;
    }

    public void setLayer(FLyrRaster lyr) throws Exception {
        if (!lyr.getDataStore().isTiled()) {
            this.setHistogramableSource(lyr.getRender().getLastRenderBuffer().getHistogramComputer(), PluginServices.getText((Object)((Object)this), (String)"datos_visualizados"));
        }
        if (!lyr.getDataStore().isRasterEnclosed()) {
            this.setHistogramableSource(lyr.getDataStore().getHistogramComputer(), PluginServices.getText((Object)((Object)this), (String)"imagen_completa"));
        }
        this.getHistogramPanelListener().setLayer(lyr);
    }

    public GraphicContainer getGraphicContainer() {
        if (this.graphicContainer == null) {
            this.graphicContainer = new GraphicContainer(true);
        }
        return this.graphicContainer;
    }

    private JPanel getPanelSouth() {
        if (this.panelSouth == null) {
            this.panelSouth = new JPanel();
            this.panelSouth.setLayout(new BorderLayout(5, 5));
            this.panelSouth.add((Component)this.getTableContainer(), "Center");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            jPanel2.add(this.getBCreateTable());
            jPanel2.add(this.getCheckBoxDeleteEdges());
            jPanel2.add(this.getCheckBoxRGB());
            jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.panelSouth.add((Component)jPanel2, "East");
        }
        return this.panelSouth;
    }

    public JCheckBox getCheckBoxDeleteEdges() {
        if (this.checkBoxDeleteEdges == null) {
            this.checkBoxDeleteEdges = new JCheckBox(PluginServices.getText((Object)((Object)this), (String)"eliminar_extremos"));
            this.checkBoxDeleteEdges.addActionListener(this.histogramPanelListener);
        }
        return this.checkBoxDeleteEdges;
    }

    public JCheckBox getCheckBoxRGB() {
        if (this.checkBoxRGB == null) {
            this.checkBoxRGB = new JCheckBox(PluginServices.getText((Object)((Object)this), (String)"RGB"));
            this.checkBoxRGB.addActionListener(this.histogramPanelListener);
        }
        return this.checkBoxRGB;
    }

    private TableContainer getTableContainer() {
        if (this.tableContainer == null) {
            String[] columnNames = new String[]{PluginServices.getText((Object)((Object)this), (String)"band"), PluginServices.getText((Object)((Object)this), (String)"minimo"), PluginServices.getText((Object)((Object)this), (String)"maximo"), PluginServices.getText((Object)((Object)this), (String)"media"), PluginServices.getText((Object)((Object)this), (String)"median"), PluginServices.getText((Object)((Object)this), (String)"npixeles")};
            int[] columnWidths = new int[]{50, 65, 65, 65, 65, 115};
            this.tableContainer = new TableContainer(columnNames, columnWidths);
            this.tableContainer.setPreferredSize(new Dimension(0, 90));
            this.tableContainer.setControlVisible(true);
            this.tableContainer.setModel("ListModel");
            this.tableContainer.initialize();
            this.tableContainer.setName("tableContainer");
            this.tableContainer.setControlVisible(false);
            try {
                this.tableContainer.setEditable(false);
            }
            catch (NotInitializeException notInitializeException) {
                // empty catch block
            }
        }
        return this.tableContainer;
    }

    public JButton getButtonShowAll() {
        if (this.buttonShowAll == null) {
            this.buttonShowAll = new JButton(PluginServices.getText((Object)((Object)this), (String)"boton_mostrar"));
            this.buttonShowAll.addActionListener(this.getHistogramPanelListener());
        }
        return this.buttonShowAll;
    }

    public JButton getButtonClean() {
        if (this.buttonClean == null) {
            this.buttonClean = new JButton(PluginServices.getText((Object)((Object)this), (String)"boton_limpiar"));
            this.buttonClean.addActionListener(this.getHistogramPanelListener());
        }
        return this.buttonClean;
    }

    private JPanel getPanelNorth() {
        if (this.panelNorth == null) {
            this.panelNorth = new JPanel();
            JScrollPane jScrollPane1 = new JScrollPane();
            JPanel jPanel4 = new JPanel();
            jScrollPane1.setPreferredSize(new Dimension(120, 65));
            jScrollPane1.setViewportView(this.getJTableBands());
            this.panelNorth.setLayout(new BorderLayout());
            this.panelNorth.add((Component)jPanel4, "Center");
            this.panelNorth.add((Component)jScrollPane1, "East");
            jPanel4.setLayout(new GridBagLayout());
            JLabel jLabel1 = new JLabel(PluginServices.getText((Object)((Object)this), (String)"origen") + ":");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            jPanel4.add((Component)jLabel1, gridBagConstraints);
            JLabel jLabel2 = new JLabel(PluginServices.getText((Object)((Object)this), (String)"tipo") + ":");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            jPanel4.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(5, 0, 5, 0);
            jPanel4.add((Component)this.getComboBoxSource(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(5, 0, 5, 0);
            jPanel4.add((Component)this.getComboBoxType(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 15, 0, 0);
            jPanel4.add((Component)this.getButtonShowAll(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 15, 0, 0);
            jPanel4.add((Component)this.getButtonClean(), gridBagConstraints);
        }
        return this.panelNorth;
    }

    public JComboBox getComboBoxType() {
        if (this.comboBoxType == null) {
            String[] lista = new String[]{"normal", "accumulated", "logaritmic"};
            for (int i = 0; i < lista.length; ++i) {
                lista[i] = PluginServices.getText((Object)((Object)this), (String)lista[i]);
            }
            this.comboBoxType = new JComboBox<String>(lista);
            this.comboBoxType.addActionListener(this.getHistogramPanelListener());
            this.comboBoxType.setPreferredSize(new Dimension(150, 25));
        }
        return this.comboBoxType;
    }

    public JComboBox getComboBoxSource() {
        if (this.comboBoxSource == null) {
            this.comboBoxSource = new JComboBox();
            this.comboBoxSource.addActionListener(this.getHistogramPanelListener());
            this.comboBoxSource.setPreferredSize(new Dimension(150, 25));
        }
        return this.comboBoxSource;
    }

    public JButton getBCreateTable() {
        if (this.bTable == null) {
            this.bTable = new JButton();
            this.bTable.setHorizontalAlignment(0);
            this.bTable.setText(PluginServices.getText((Object)((Object)this), (String)"crear_tabla"));
            this.bTable.setName("bTable");
            this.bTable.addActionListener(this.getHistogramPanelListener());
            this.bTable.setPreferredSize(new Dimension(150, 25));
        }
        return this.bTable;
    }

    public JTable getJTableBands() {
        this.getHistogramPanelListener().eventsEnabled = false;
        if (this.jTableBands == null) {
            this.jTableBands = new JTable();
            this.jTableBands.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", PluginServices.getText((Object)((Object)this), (String)"bandas")}){
                private static final long serialVersionUID = 0L;
                Class<?>[] types;
                boolean[] canEdit;
                {
                    this.types = new Class[]{Boolean.class, String.class};
                    this.canEdit = new boolean[]{true, false};
                }

                @Override
                public Class<?> getColumnClass(int columnIndex) {
                    return this.types[columnIndex];
                }

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return this.canEdit[columnIndex];
                }
            });
            this.jTableBands.addPropertyChangeListener(this.getHistogramPanelListener());
            this.jTableBands.getColumnModel().getColumn(0).setPreferredWidth(20);
            this.jTableBands.getColumnModel().getColumn(0).setResizable(false);
        }
        this.getHistogramPanelListener().eventsEnabled = this.panelInizialited;
        return this.jTableBands;
    }

    private void setBands(int bands, boolean initValue) {
        this.getHistogramPanelListener().eventsEnabled = false;
        ((DefaultTableModel)this.getJTableBands().getModel()).setRowCount(0);
        for (int i = 0; i < bands; ++i) {
            ((DefaultTableModel)this.getJTableBands().getModel()).addRow(new Object[]{new Boolean(initValue), PluginServices.getText((Object)((Object)this), (String)"band") + " " + String.valueOf(i)});
        }
        this.getHistogramPanelListener().eventsEnabled = this.panelInizialited;
    }

    public void setStatistic(double[][] stat) {
        try {
            this.getTableContainer().removeAllRows();
            if (stat == null) {
                return;
            }
            for (int iBand = 0; iBand < stat[0].length; ++iBand) {
                Object[] list = new Object[stat.length + 1];
                list[0] = new Integer(iBand);
                for (int iStat = 1; iStat <= stat.length; ++iStat) {
                    if (stat[iStat - 1] == null || iBand >= stat[iStat - 1].length) continue;
                    list[iStat] = new Double(this.math.format(new Double(stat[iStat - 1][iBand]).doubleValue(), 3));
                }
                this.getTableContainer().addRow(list);
                Object var3_4 = null;
            }
        }
        catch (NotInitializeException e) {
            NotificationManager.addError((String)"Error al eliminar las filas de la tabla", (Throwable)e);
        }
    }

    public void setRGBInBandList(boolean initValue) {
        this.getHistogramPanelListener().eventsEnabled = false;
        ((DefaultTableModel)this.getJTableBands().getModel()).setRowCount(0);
        ((DefaultTableModel)this.getJTableBands().getModel()).addRow(new Object[]{new Boolean(initValue), "R"});
        ((DefaultTableModel)this.getJTableBands().getModel()).addRow(new Object[]{new Boolean(initValue), "G"});
        ((DefaultTableModel)this.getJTableBands().getModel()).addRow(new Object[]{new Boolean(initValue), "B"});
        this.getHistogramPanelListener().eventsEnabled = this.panelInizialited;
    }

    public double getBoxValueX1() {
        return this.getGraphicContainer().getX1();
    }

    public double getBoxValueX2() {
        return this.getGraphicContainer().getX2();
    }

    private HistogramPanelListener getHistogramPanelListener() {
        if (this.histogramPanelListener == null) {
            this.histogramPanelListener = new HistogramPanelListener(this);
        }
        return this.histogramPanelListener;
    }

    public void refreshBands(boolean initValue) {
        if (this.getHistogramPanelListener().getLastHistogram() == null) {
            this.setBands(0, initValue);
            return;
        }
        int bandCount = this.getHistogramPanelListener().getLastHistogram().getNumBands();
        if (this.getComboBoxSource().getSelectedIndex() == 0 && bandCount == 3) {
            this.setRGBInBandList(initValue);
        } else {
            this.setBands(bandCount, initValue);
        }
    }

    public void firstRun() {
        this.getHistogramPanelListener().showHistogram();
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void actionButtonPressed(ButtonsPanelEvent e) {
        switch (e.getButton()) {
            case 9: {
                this.getButtonsPanel().getButton(9).setVisible(false);
                this.getButtonsPanel().getButton(8).setVisible(true);
                this.panelSouth.setVisible(false);
                break;
            }
            case 8: {
                this.getButtonsPanel().getButton(9).setVisible(true);
                this.getButtonsPanel().getButton(8).setVisible(false);
                this.panelSouth.setVisible(true);
            }
        }
    }
}

