/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.infobypoint.viewtool;

import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.util.ColorConversion;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.swing.infobypoint.InfoByPointDataModel;
import org.gvsig.raster.tools.app.basic.tool.selectrasterlayer.SelectImageListImpl;

public class InfoByPixelPointViewTool
extends SelectImageListImpl {
    private RasterManager rManager = RasterLocator.getManager();
    private InfoByPointDataModel model = null;
    private ColorConversion conv = null;
    private ViewPort viewPort = null;
    private FLayers layers = null;
    private List<String> list = null;

    public InfoByPixelPointViewTool(MapControl mapCtrl, InfoByPointDataModel model) {
        super(mapCtrl);
        this.model = model;
        this.conv = this.rManager.getColorConversion();
        this.viewPort = mapCtrl.getViewPort();
        this.layers = mapCtrl.getMapContext().getLayers();
        this.list = new ArrayList<String>();
    }

    @Override
    public void point(PointEvent event) {
        super.point(event);
        Point2D point2D = event.getPoint();
        BufferedImage image = this.mapCtrl.getImage();
        int value = image.getRGB((int)point2D.getX(), (int)point2D.getY());
        int r = value >> 16 & 0xFF;
        int g = value >> 8 & 0xFF;
        int b = value & 0xFF;
        double[] cmyk = this.conv.RGBtoCMYK(r & 0xFF, g & 0xFF, b & 0xFF, 1.0);
        double[] hsl = this.conv.RGBtoHSL(r & 0xFF, g & 0xFF, b & 0xFF);
        hsl[0] = (int)(255.0 * hsl[0] / 360.0 + 0.5);
        hsl[2] = (int)(hsl[2] * 255.0 + 0.5);
        hsl[1] = (int)(hsl[1] * 255.0 + 0.5);
        Point2D mapPoint = this.viewPort.toMapPoint(point2D);
        this.model.setARGB(r, g, b);
        this.model.setCMYK(cmyk);
        this.model.setHSL(hsl[0], hsl[1], hsl[2]);
        this.model.setViewPoint(point2D.getX(), point2D.getY());
        this.model.setWorldPoint(mapPoint.getX(), mapPoint.getY());
        this.list.clear();
        FLyrRaster selected = null;
        for (int i = this.layers.getLayersCount() - 1; i >= 0; --i) {
            FLayer lyr = this.layers.getLayer(i);
            if (!(lyr instanceof FLyrRaster)) continue;
            FLyrRaster raster = (FLyrRaster)lyr;
            Point2D tmpPoint = mapPoint;
            if (raster.getCoordTrans() != null) {
                tmpPoint = raster.getCoordTrans().getInverted().convert(mapPoint, null);
            }
            if (!raster.isInside(tmpPoint)) continue;
            this.list.add(raster.getName());
            if (!raster.isActive()) continue;
            selected = raster;
        }
        if (selected != null) {
            if (selected.getCoordTrans() != null) {
                mapPoint = selected.getCoordTrans().getInverted().convert(mapPoint, null);
            }
            Point2D rasterPoint = selected.getDataStore().worldToRaster(mapPoint);
            this.model.setNumberOfBands(selected.getDataStore().getBandCount());
            this.model.setBandValues(this.getBandValues(selected.getDataStore(), rasterPoint));
            this.model.setPixelPoint(rasterPoint.getX(), rasterPoint.getY());
        } else {
            this.list.clear();
            this.list.add("...");
            this.model.setNumberOfBands(0);
            this.model.setBandValues(new double[]{Double.NaN});
            this.model.setPixelPoint(-1.0, -1.0);
        }
        this.model.setLayerList(this.list);
        this.model.notifyObservers();
    }

    private double[] getBandValues(RasterDataStore dataStore, Point2D pxPoint) {
        double[] res = new double[dataStore.getBandCount()];
        int pos = 0;
        try {
            int i;
            if (dataStore.getDataType()[0] >= 0 && dataStore.getDataType()[0] <= 3) {
                for (i = 0; i < dataStore.getBandCount(); ++i) {
                    int val = (Integer)dataStore.getData((int)pxPoint.getX(), (int)pxPoint.getY(), i);
                    res[pos] = dataStore.getDataType()[0] == 0 ? (double)(val & 0xFF) : (double)val;
                    ++pos;
                }
            }
            if (dataStore.getDataType()[0] == 4) {
                for (i = 0; i < dataStore.getBandCount(); ++i) {
                    res[pos] = ((Float)dataStore.getData((int)pxPoint.getX(), (int)pxPoint.getY(), i)).doubleValue();
                    ++pos;
                }
            }
            if (dataStore.getDataType()[0] == 5) {
                for (i = 0; i < dataStore.getBandCount(); ++i) {
                    res[pos] = (Double)dataStore.getData((int)pxPoint.getX(), (int)pxPoint.getY(), i);
                    ++pos;
                }
            }
            return res;
        }
        catch (Exception e) {
            for (int i = 0; i < dataStore.getBandCount(); ++i) {
                res[i] = Double.NaN;
            }
            return res;
        }
    }
}

