/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.infobypoint.viewtool;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.util.ColorConversion;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Listeners.ToolListener;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.swing.infobypoint.InfoByPointDataModel;
import org.gvsig.raster.swing.pixelinspector.PixelInspector;

public class PixelInspectorViewTool
extends Behavior {
    private RasterManager rManager = RasterLocator.getManager();
    private InfoByPointDataModel model = null;
    private ColorConversion conv = null;
    private ViewPort viewPort = null;
    private MapControl mapCtrl = null;
    private PixelInspector observer = null;

    public PixelInspectorViewTool(MapControl mapCtrl, InfoByPointDataModel model, PixelInspector observer) {
        this.mapCtrl = mapCtrl;
        this.model = model;
        this.observer = observer;
        this.conv = this.rManager.getColorConversion();
        this.viewPort = mapCtrl.getViewPort();
    }

    public FLyrRaster getLayer(Point2D p) {
        FLyrRaster raster = null;
        for (int i = this.mapCtrl.getMapContext().getLayers().getLayersCount() - 1; i >= 0; --i) {
            FLayer lyr = this.mapCtrl.getMapContext().getLayers().getLayer(i);
            if (!(lyr instanceof FLyrRaster) || !(raster = (FLyrRaster)lyr).isInside(p)) continue;
            return raster;
        }
        return null;
    }

    public ToolListener getListener() {
        return null;
    }

    public void mouseMoved(MouseEvent e) throws BehaviorException {
        Point2D.Double point2D = new Point2D.Double(e.getX(), e.getY());
        BufferedImage image = this.mapCtrl.getImage();
        if (e.getX() >= image.getWidth() || e.getY() >= image.getHeight()) {
            return;
        }
        int value = image.getRGB((int)((Point2D)point2D).getX(), (int)((Point2D)point2D).getY());
        int r = value >> 16 & 0xFF;
        int g = value >> 8 & 0xFF;
        int b = value & 0xFF;
        double[] cmyk = this.conv.RGBtoCMYK(r & 0xFF, g & 0xFF, b & 0xFF, 1.0);
        double[] hsl = this.conv.RGBtoHSL(r & 0xFF, g & 0xFF, b & 0xFF);
        hsl[0] = (int)(255.0 * hsl[0] / 360.0 + 0.5);
        hsl[2] = (int)(hsl[2] * 255.0 + 0.5);
        hsl[1] = (int)(hsl[1] * 255.0 + 0.5);
        Point2D mapPoint = this.viewPort.toMapPoint((Point2D)point2D);
        this.model.setARGB(r, g, b);
        this.model.setCMYK(cmyk);
        this.model.setHSL(hsl[0], hsl[1], hsl[2]);
        this.model.setViewPoint(((Point2D)point2D).getX(), ((Point2D)point2D).getY());
        this.model.setWorldPoint(mapPoint.getX(), mapPoint.getY());
        FLyrRaster raster = this.getLayer(mapPoint);
        if (raster != null && raster.getDataStore() != null) {
            Point2D rasterPoint = raster.getDataStore().worldToRaster(mapPoint);
            this.model.setNumberOfBands(raster.getDataStore().getBandCount());
            this.model.setPixelPoint(rasterPoint.getX(), rasterPoint.getY());
        }
        this.model.notifyObservers();
        this.observer.setClear(false);
        this.observer.setDataBuffer(image);
        int pX = (this.observer.getWidth() / this.observer.getScale() >> 1) - e.getX();
        int pY = (this.observer.getHeight() / this.observer.getScale() >> 1) - e.getY();
        this.observer.setViewCoordinates((int)e.getPoint().getX(), (int)e.getPoint().getY());
        this.observer.setPosX(pX);
        this.observer.setPosY(pY);
        this.observer.repaint();
    }
}

