/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.pixelincrease;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.CompoundBehavior;
import org.gvsig.raster.swing.pixelinspector.PixelInspector;
import org.gvsig.raster.tools.app.basic.tool.pixelincrease.PixelIncreaseBehavior;

public class PixelIncreaseDialog
extends JPanel
implements IWindow,
MouseListener,
PixelInspector {
    private static final long serialVersionUID = -3370601314380922368L;
    private JPopupMenu menu = null;
    private int width = 170;
    private int height = 170;
    private int w = 0;
    private int h = 0;
    private int posWindowX = 0;
    private int posWindowY = 0;
    private int scale = 8;
    public BufferedImage img = null;
    private int posX = 0;
    private int posY = 0;
    public int pixX = 0;
    public int pixY = 0;
    int red = 0;
    int green = 0;
    int blue = 0;
    private WindowInfo m_viewinfo = null;
    private boolean clear = false;
    private Color color = Color.red;
    private JCheckBoxMenuItem[] entry = new JCheckBoxMenuItem[6];

    public PixelIncreaseDialog() {
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.setSize(this.width, this.height);
        this.addMouseListener(this);
        IWindow active = PluginServices.getMDIManager().getActiveWindow();
        if (active instanceof AbstractViewPanel) {
            this.img = ((AbstractViewPanel)active).getImage();
            WindowInfo wInfo = PluginServices.getMDIManager().getWindowInfo(active);
            this.posWindowX = wInfo.getX() + wInfo.getWidth() - this.width;
            this.posWindowY = wInfo.getY();
        }
        CompoundBehavior.setAllControlsBehavior((Behavior)new PixelIncreaseBehavior(this));
        this.initMenu();
    }

    public void setViewCoordinates(int pixX, int pixY) {
        this.pixX = pixX;
        this.pixY = pixY;
    }

    public void setClear(boolean clear) {
        this.clear = clear;
    }

    private void initMenu() {
        this.menu = new JPopupMenu();
        PopupMenuListener lis = new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
                PixelIncreaseDialog.this.clear = true;
                PixelIncreaseDialog.this.repaint();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        };
        this.menu.addPopupMenuListener(lis);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int i;
                String txt = ((JMenuItem)evt.getSource()).getText();
                if (txt.compareTo("X4") == 0) {
                    PixelIncreaseDialog.this.scale = 4;
                    for (i = 1; i <= 3; ++i) {
                        PixelIncreaseDialog.this.entry[i].setSelected(false);
                    }
                    PixelIncreaseDialog.this.entry[0].setSelected(true);
                }
                if (txt.compareTo("X8") == 0) {
                    PixelIncreaseDialog.this.scale = 8;
                    PixelIncreaseDialog.this.entry[0].setSelected(false);
                    PixelIncreaseDialog.this.entry[1].setSelected(true);
                    PixelIncreaseDialog.this.entry[2].setSelected(false);
                    PixelIncreaseDialog.this.entry[3].setSelected(false);
                }
                if (txt.compareTo("X16") == 0) {
                    PixelIncreaseDialog.this.scale = 16;
                    PixelIncreaseDialog.this.entry[0].setSelected(false);
                    PixelIncreaseDialog.this.entry[1].setSelected(false);
                    PixelIncreaseDialog.this.entry[2].setSelected(true);
                    PixelIncreaseDialog.this.entry[3].setSelected(false);
                }
                if (txt.compareTo("X32") == 0) {
                    PixelIncreaseDialog.this.scale = 32;
                    for (i = 0; i < 3; ++i) {
                        PixelIncreaseDialog.this.entry[i].setSelected(false);
                    }
                    PixelIncreaseDialog.this.entry[3].setSelected(true);
                }
                if (txt.compareTo(PluginServices.getText((Object)this, (String)"green")) == 0) {
                    PixelIncreaseDialog.this.color = Color.GREEN;
                    PixelIncreaseDialog.this.entry[4].setSelected(false);
                    PixelIncreaseDialog.this.entry[5].setSelected(true);
                }
                if (txt.compareTo(PluginServices.getText((Object)this, (String)"red")) == 0) {
                    PixelIncreaseDialog.this.color = Color.RED;
                    PixelIncreaseDialog.this.entry[4].setSelected(true);
                    PixelIncreaseDialog.this.entry[5].setSelected(false);
                }
            }
        };
        this.entry[0] = new JCheckBoxMenuItem("X4");
        this.entry[0].addActionListener(al);
        this.menu.add(this.entry[0]);
        this.entry[1] = new JCheckBoxMenuItem("X8");
        this.entry[1].setSelected(true);
        this.entry[1].addActionListener(al);
        this.menu.add(this.entry[1]);
        this.entry[2] = new JCheckBoxMenuItem("X16");
        this.entry[2].addActionListener(al);
        this.menu.add(this.entry[2]);
        this.entry[3] = new JCheckBoxMenuItem("X32");
        this.entry[3].addActionListener(al);
        this.menu.add(this.entry[3]);
        this.entry[4] = new JCheckBoxMenuItem(PluginServices.getText((Object)this, (String)"red"));
        this.entry[4].addActionListener(al);
        this.entry[4].setSelected(true);
        this.menu.add(this.entry[4]);
        this.entry[5] = new JCheckBoxMenuItem(PluginServices.getText((Object)this, (String)"green"));
        this.entry[5].addActionListener(al);
        this.menu.add(this.entry[5]);
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.w = this.getVisibleRect().width;
        this.h = this.getVisibleRect().height;
        if (this.clear) {
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, this.w, this.h);
            return;
        }
        if (this.img != null) {
            int sizeCrux = 10;
            int value = 0;
            try {
                value = this.img.getRGB(this.pixX, this.pixY);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            this.red = (value & 0xFF0000) >> 16;
            this.green = (value & 0xFF00) >> 8;
            this.blue = value & 0xFF;
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, this.w, this.h);
            ((Graphics2D)g).scale(this.scale, this.scale);
            g.drawImage(this.img, this.posX, this.posY, this);
            ((Graphics2D)g).setTransform(new AffineTransform());
            g.setColor(this.color);
            int middleW = this.w >> 1;
            int middleH = this.h >> 1;
            g.drawLine(middleW - sizeCrux, middleH, middleW + sizeCrux, middleH);
            g.drawLine(middleW, middleH - sizeCrux, middleW, middleH + sizeCrux);
            g.drawString(this.red + "," + this.green + "," + this.blue, this.w - 85, this.h - 3);
        }
    }

    public WindowInfo getWindowInfo() {
        this.m_viewinfo = new WindowInfo(16);
        this.m_viewinfo.setTitle(PluginServices.getText((Object)this, (String)"increase"));
        this.m_viewinfo.setX(this.posWindowX);
        this.m_viewinfo.setY(this.posWindowY);
        return this.m_viewinfo;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setPosX(int posX) {
        this.posX = posX;
    }

    public void setPosY(int posY) {
        this.posY = posY;
    }

    @Override
    public int getHeight() {
        return this.h == 0 ? this.height : this.h;
    }

    @Override
    public int getWidth() {
        return this.w == 0 ? this.width : this.w;
    }

    public int getScale() {
        return this.scale;
    }

    public BufferedImage getDataBuffer() {
        return this.img;
    }

    public void setDataBuffer(BufferedImage view) {
        this.img = view;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.clear = true;
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.clear = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.clear = true;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 3) {
            this.menu.show(e.getComponent(), e.getX(), e.getY());
            this.clear = true;
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public Object getWindowProfile() {
        return WindowInfo.PROPERTIES_PROFILE;
    }
}

