/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.properties.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.fmap.dal.coverage.exception.FilterManagerException;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterListManager;
import org.gvsig.fmap.dal.coverage.grid.filter.LinearStretchParams;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.gui.beans.panelGroup.AbstractPanelGroup;
import org.gvsig.gui.beans.slidertext.listeners.SliderEvent;
import org.gvsig.gui.beans.slidertext.listeners.SliderListener;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.mainplugin.properties.RasterPropertiesTocMenuEntry;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.RasterExtension;
import org.gvsig.raster.tools.app.basic.raster.process.IProcessActions;
import org.gvsig.raster.tools.app.basic.raster.process.StatisticsProcess;
import org.gvsig.raster.tools.app.basic.tool.properties.panel.EnhancedBrightnessContrastPanel;
import org.gvsig.raster.tools.app.basic.tool.properties.panel.EnhancedPanel;
import org.gvsig.raster.tools.app.basic.tool.properties.panel.EnhancedWithTrimPanel;

public class EnhancedControl
implements IProcessActions {
    private EnhancedPanel tPanel = null;
    private RasterFilterList filterList = null;
    private EnhancedWithTrimPanel ePanel = null;
    private EnhancedBrightnessContrastPanel bcPanel = null;
    private FLyrRaster lyr = null;
    private AbstractPanelGroup panelGroup = null;
    private Statistics stats = null;
    private int[] renderBands = new int[]{0, 1, 2};

    public EnhancedControl(AbstractPanelGroup panelGroup, EnhancedPanel tp, FLyrRaster lyr, RasterFilterList rfl) {
        this.panelGroup = panelGroup;
        this.tPanel = tp;
        this.filterList = rfl;
        this.lyr = lyr;
        this.bcPanel = this.tPanel.getBrightnessContrastPanel();
        this.ePanel = this.tPanel.getEnhancedWithTrimPanel();
        new BrightnessContrastListener(this.bcPanel);
        new EnhancedWithTrimListener(this.ePanel);
        try {
            this.saveStatus();
        }
        catch (FilterManagerException e) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"error_saving_filters"), (Object)this, (Exception)((Object)e));
        }
        catch (FilterTypeException e) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"error_saving_filters"), (Object)this, (Exception)((Object)e));
        }
        this.setValuesFromFilterToPanel();
    }

    private void setValuesFromFilterToPanel() {
        RasterFilter bFilter = this.filterList.getByName("brightness");
        if (bFilter != null) {
            int incr = (Integer)bFilter.getParam("incrBrillo");
            this.bcPanel.setBrightnessValue(incr);
        } else {
            this.bcPanel.setBrightnessValue(0.0);
        }
        RasterFilter cFilter = this.filterList.getByName("contrast");
        if (cFilter != null) {
            int incr = (Integer)cFilter.getParam("incrContraste");
            this.bcPanel.setContrastValue(incr);
        } else {
            this.bcPanel.setContrastValue(0.0);
        }
        if (bFilter != null || cFilter != null) {
            this.bcPanel.setControlEnabled(true);
        } else {
            this.bcPanel.setControlEnabled(false);
        }
        RasterFilter eFilter = this.filterList.getByName("enhanced_stretch");
        if (eFilter != null) {
            this.ePanel.setControlEnabled(true);
            boolean removeEnds = false;
            if (eFilter.getParam("remove") != null) {
                removeEnds = (Boolean)eFilter.getParam("remove");
            }
            this.ePanel.setRemoveEndsActive(removeEnds);
            LinearStretchParams stretchs = (LinearStretchParams)eFilter.getParam("stretchs");
            double[] tailTrimList = stretchs != null ? stretchs.getTailTrimList() : new double[]{};
            double median = 0.0;
            double nValues = tailTrimList.length;
            for (int i = 0; i < tailTrimList.length; ++i) {
                median += tailTrimList[i];
            }
            double tailTrim = new Double(nValues > 0.0 ? median / nValues : median);
            if (tailTrim != 0.0) {
                this.ePanel.setTailTrimCheckActive(true);
                this.ePanel.setTailTrimValue(tailTrim * 100.0);
            } else {
                this.ePanel.setTailTrimCheckActive(false);
                this.ePanel.setTailTrimValue(0.0);
            }
        } else {
            this.ePanel.setControlEnabled(false);
            this.ePanel.setRemoveEndsActive(false);
            this.ePanel.setTailTrimCheckActive(false);
            this.ePanel.setTailTrimValue(0.0);
        }
    }

    private void setValuesFromPanelToFilter() throws FilterTypeException, FilterAddException {
        Params params;
        if (this.ePanel.getActive().isSelected()) {
            if (this.lyr != null) {
                this.stats = this.lyr.getDataStore().getStatistics();
                this.renderBands = this.lyr.getRender().getRenderColorInterpretation().buildRenderBands();
                try {
                    if (!this.stats.isCalculated() && this.lyr instanceof FLyrRaster) {
                        StatisticsProcess.launcher(this.lyr, this);
                    }
                    RasterFilterListManager enhancementManager = this.filterList.getManagerByID("EnhancementStretch");
                    params = this.filterList.createEmptyFilterParams();
                    params.setParam("stats", (Object)this.stats);
                    params.setParam("remove", (Object)this.ePanel.isRemoveEndsSelected());
                    params.setParam("renderBands", (Object)this.renderBands);
                    params.setParam("rgb", (Object)this.lyr.isRGB());
                    if (this.ePanel.isTailTrimCheckSelected()) {
                        params.setParam("tailtrim", (Object)(this.ePanel.getTrimValue() / 100.0));
                    } else {
                        params.setParam("tailtrim", (Object)0.0);
                    }
                    enhancementManager.addFilter(params);
                }
                catch (FilterManagerException e) {
                    throw new FilterAddException("No se han podido calcular estadisticas. Error al a\u00ef\u00bf\u00bdadir realce;" + e.getMessage());
                }
            }
        } else if (this.lyr != null) {
            this.renderBands = this.lyr.getRender().getRenderColorInterpretation().buildRenderBands();
            if (this.lyr.getDataStore().getDataType()[0] != 0 || this.renderBands.length < 3) {
                RasterFilter colortable = this.filterList.getByName("colortable");
                this.filterList.removeAll();
                if (colortable != null) {
                    this.filterList.add(colortable);
                }
            } else {
                this.filterList.remove("enhanced_stretch");
                this.filterList.remove("tailTrim");
            }
        } else {
            this.filterList.remove("enhanced_stretch");
            this.filterList.remove("tailTrim");
        }
        try {
            RasterFilterListManager bcManager = this.filterList.getManagerByID("BrightnessContrast");
            if (this.bcPanel.getActive().isSelected() && (int)this.bcPanel.getBrightnessValue() != 0) {
                params = this.filterList.createEmptyFilterParams();
                params.setParam("Brightness", (Object)new Integer((int)this.bcPanel.getBrightnessValue()));
                this.filterList.add(bcManager.createFilter(params));
            } else {
                this.filterList.remove("brightness");
            }
            if (this.bcPanel.getActive().isSelected() && (int)this.bcPanel.getContrastValue() != 0) {
                params = this.filterList.createEmptyFilterParams();
                params.setParam("Contrast", (Object)new Integer((int)this.bcPanel.getContrastValue()));
                this.filterList.add(bcManager.createFilter(params));
            } else {
                this.filterList.remove("contrast");
            }
        }
        catch (FilterManagerException e) {
            throw new FilterAddException("No se han podido calcular estadisticas. Error al a\u00f1adir realce;" + e.getMessage());
        }
        this.endActionsForFilterSettings();
    }

    private void endActionsForFilterSettings() throws FilterTypeException {
        ArrayList listOrder = (ArrayList)this.panelGroup.getProperties().get("filterOrder");
        List listCopy = this.filterList.getStatusCloned();
        int cont = 0;
        for (int i = 0; i < listOrder.size(); ++i) {
            int pos = this.hasFilter(listCopy, ((RasterFilter)listOrder.get(i)).getName());
            if (pos == -1) continue;
            if (pos != cont) {
                RasterFilter copy = (RasterFilter)listCopy.remove(pos);
                listCopy.add(cont, copy);
            }
            ++cont;
        }
        this.filterList.setStatus(listCopy);
        this.filterList.controlTypes();
        if (this.lyr != null) {
            this.lyr.getMapContext().invalidate();
        }
    }

    public void accept() {
        try {
            this.setValuesFromPanelToFilter();
        }
        catch (FilterTypeException e) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"error_adding_filters"), (Object)this, (Exception)((Object)e));
        }
        catch (FilterAddException e) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"error_adding_filters"), (Object)this, (Exception)((Object)e));
        }
    }

    public void apply() {
        this.onlyApply();
        try {
            this.saveStatus();
        }
        catch (FilterManagerException e) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"error_saving_filters"), (Object)this, (Exception)((Object)e));
        }
        catch (FilterTypeException e) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"error_saving_filters"), (Object)this, (Exception)((Object)e));
        }
    }

    public void onlyApply() {
        if (RasterPropertiesTocMenuEntry.enableEvents) {
            try {
                this.setValuesFromPanelToFilter();
            }
            catch (FilterTypeException e) {
                RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"error_adding_filters"), (Object)this, (Exception)((Object)e));
            }
            catch (FilterAddException e) {
                RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"error_adding_filters"), (Object)this, (Exception)((Object)e));
            }
        }
    }

    public void cancel() {
        this.restoreStatus();
    }

    private int hasFilter(List<RasterFilter> filter, String name) {
        for (int i = 0; i < filter.size(); ++i) {
            if (!filter.get(i).getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public void saveStatus() throws FilterManagerException, FilterTypeException {
        this.panelGroup.getProperties().put("filterStatus", this.filterList.getStatusCloned());
        List filterOrder = this.filterList.getStatusCloned();
        int posEnhanced = this.hasFilter(filterOrder, "enhanced_stretch");
        int posTailTrim = this.hasFilter(filterOrder, "tailTrim");
        RasterFilterListManager statFilterManager = this.filterList.getManagerByID("Statistics");
        Params params = this.filterList.createEmptyFilterParams();
        params.setParam("stats", null);
        params.setParam("tail", (Object)new Double(0.0));
        params.setParam("samples", (Object)new Double(0.0));
        params.setParam("remove", (Object)new Boolean(false));
        RasterFilter filter = statFilterManager.createFilter(params);
        if (posEnhanced != -1) {
            if (posTailTrim == -1) {
                filterOrder.add(posEnhanced, filter);
            }
        } else {
            if (posTailTrim != -1) {
                filterOrder.remove(posTailTrim);
            }
            filterOrder.add(0, filter);
            RasterFilterListManager eManager = this.filterList.getManagerByID("EnhancementStretch");
            params = this.filterList.createEmptyFilterParams();
            params.setParam("remove", (Object)new Boolean(false));
            eManager.createFilter(params);
        }
        RasterFilterListManager bcManager = this.filterList.getManagerByID("BrightnessContrast");
        if (this.hasFilter(filterOrder, "brightness") == -1) {
            params = this.filterList.createEmptyFilterParams();
            params.setParam("Brightness", (Object)new Integer(0));
            filterOrder.add(bcManager.createFilter(params));
        }
        if (this.hasFilter(filterOrder, "contrast") == -1) {
            params = this.filterList.createEmptyFilterParams();
            params.setParam("Contrast", (Object)new Integer(0));
            filterOrder.add(bcManager.createFilter(params));
        }
        this.panelGroup.getProperties().put("filterOrder", filterOrder);
    }

    public void restoreStatus() {
        this.filterList.setStatus((List)((ArrayList)this.panelGroup.getProperties().get("filterStatus")));
        if (this.lyr != null) {
            this.lyr.getMapContext().invalidate();
        }
    }

    @Override
    public void end(Object param) {
        Statistics st = null;
        if (param instanceof FLyrRaster && ((FLyrRaster)param).getDataStore() != null) {
            st = ((FLyrRaster)param).getDataStore().getStatistics();
        }
        Statistics statistics = st == null ? this.stats : st;
        try {
            RasterFilterListManager enhancementManager = this.filterList.getManagerByID("EnhancementStretch");
            Params params = this.filterList.createEmptyFilterParams();
            params.setParam("stats", (Object)statistics);
            params.setParam("remove", (Object)this.ePanel.isRemoveEndsSelected());
            params.setParam("renderBands", (Object)this.renderBands);
            params.setParam("rgb", (Object)this.lyr.isRGB());
            if (this.ePanel.isTailTrimCheckSelected()) {
                params.setParam("tailtrim", (Object)(this.ePanel.getTrimValue() / 100.0));
            } else {
                this.filterList.remove("tailTrim");
                params.setParam("tailtrim", (Object)0.0);
            }
            enhancementManager.addFilter(params);
            this.endActionsForFilterSettings();
        }
        catch (FilterManagerException e) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"error_adding_stats"), (Object)this, (Exception)((Object)e));
        }
        catch (FilterTypeException e) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"error_adding_stats"), (Object)this, (Exception)((Object)e));
        }
    }

    @Override
    public void interrupted() {
    }

    class EnhancedWithTrimListener
    implements ActionListener,
    SliderListener {
        JCheckBox active = null;

        public EnhancedWithTrimListener(EnhancedWithTrimPanel panel) {
            this.active = panel.getActive();
            this.active.addActionListener(this);
            panel.getRemoveCheck().addActionListener(this);
            panel.getTrimCheck().addActionListener(this);
            panel.getTrimSlider().addValueChangedListener((SliderListener)this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!RasterExtension.autoRefreshView) {
                return;
            }
            EnhancedControl.this.onlyApply();
        }

        public void actionValueChanged(SliderEvent e) {
            if (!RasterExtension.autoRefreshView) {
                return;
            }
            EnhancedControl.this.onlyApply();
        }

        public void actionValueDragged(SliderEvent e) {
        }
    }

    class BrightnessContrastListener
    implements ActionListener,
    SliderListener {
        JCheckBox active = null;

        public BrightnessContrastListener(EnhancedBrightnessContrastPanel panel) {
            panel.addBrightnessValueChangedListener(this);
            panel.addContrastValueChangedListener(this);
            this.active = panel.getActive();
            this.active.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!RasterExtension.autoRefreshView) {
                return;
            }
            if (e.getSource() == this.active) {
                EnhancedControl.this.onlyApply();
            }
        }

        public void actionValueChanged(SliderEvent e) {
            if (!RasterExtension.autoRefreshView) {
                return;
            }
            EnhancedControl.this.onlyApply();
        }

        public void actionValueDragged(SliderEvent e) {
        }
    }
}

