/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.properties.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gvsig.andami.PluginServices;

public class TranspOpacitySliderPanel
extends JPanel
implements ActionListener,
FocusListener,
ChangeListener {
    private static final long serialVersionUID = 0L;
    private JCheckBox cbTransparencia = null;
    private JCheckBox cbOpacidad = null;
    private JSlider slOpacidad = null;
    private JTextField tOpacidad = null;

    public TranspOpacitySliderPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"opacidad"), 0, 0, null, null));
        this.setLayout(new FlowLayout());
        this.add((Component)this.getOpacityCheck(), null);
        this.add((Component)this.getOpacitySlider(), null);
        this.add((Component)this.getOpacityText(), null);
    }

    public void initControls() {
        this.getOpacityText().setText("100");
        this.setActiveOpacityControl(false);
    }

    public JCheckBox getTransparencyCheck() {
        if (this.cbTransparencia == null) {
            this.cbTransparencia = new JCheckBox();
            this.cbTransparencia.setText(PluginServices.getText((Object)this, (String)"activar"));
            this.cbTransparencia.addActionListener(this);
        }
        return this.cbTransparencia;
    }

    public JCheckBox getOpacityCheck() {
        if (this.cbOpacidad == null) {
            this.cbOpacidad = new JCheckBox();
            this.cbOpacidad.setText(PluginServices.getText((Object)this, (String)"activar"));
            this.cbOpacidad.addActionListener(this);
            this.cbOpacidad.addFocusListener(this);
        }
        return this.cbOpacidad;
    }

    public JSlider getOpacitySlider() {
        if (this.slOpacidad == null) {
            this.slOpacidad = new JSlider();
            this.slOpacidad.addChangeListener(this);
        }
        return this.slOpacidad;
    }

    public JTextField getOpacityText() {
        if (this.tOpacidad == null) {
            this.tOpacidad = new JTextField();
            this.tOpacidad.setPreferredSize(new Dimension(30, 19));
            this.tOpacidad.addActionListener(this);
            this.tOpacidad.addFocusListener(this);
        }
        return this.tOpacidad;
    }

    public void setActiveOpacityControl(boolean active) {
        this.getOpacityCheck().setSelected(active);
        this.getOpacitySlider().setEnabled(active);
        this.getOpacityText().setEnabled(active);
    }

    public void setOpacity(int alpha) {
        int opacityPercent = alpha * 100 / 255;
        this.getOpacityText().setText(String.valueOf(opacityPercent));
        this.getOpacitySlider().setValue(opacityPercent);
        this.setActiveOpacityControl(true);
        if (opacityPercent == 100) {
            this.setActiveOpacityControl(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.getOpacityCheck())) {
            if (this.getOpacityCheck().isSelected()) {
                this.getOpacitySlider().setEnabled(true);
                this.getOpacityText().setEnabled(true);
            } else {
                this.getOpacitySlider().setEnabled(false);
                this.getOpacityText().setEnabled(false);
            }
        }
        if (e.getSource().equals(this.getOpacityText())) {
            this.checkOpacityText();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.checkOpacityText();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource().equals(this.getOpacitySlider())) {
            this.getOpacityText().setText(String.valueOf(this.getOpacitySlider().getValue()));
        }
    }

    private void checkOpacityText() {
        String op = this.getOpacityText().getText();
        int value = 0;
        try {
            if (op == null) {
                throw new NumberFormatException();
            }
            value = Integer.parseInt(op);
            if (value > 100) {
                this.getOpacityText().setText("100");
            } else if (value < 0) {
                this.getOpacityText().setText("0");
            }
            this.getOpacitySlider().setValue(value);
        }
        catch (NumberFormatException exc) {
            this.getOpacityText().setText("100");
            this.getOpacitySlider().setValue(100);
        }
    }
}

