/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.raw.tool;

import org.gvsig.raster.tools.app.basic.tool.raw.tool.VRTFileCreator;

public class VRTFormatUtils {
    public static String getImageOffset(int dataSize, int headerSize, String interLeaving, int band, int numBands, int width, int height) {
        int imageOffSet = 0;
        if (interLeaving.equals("Pixel")) {
            imageOffSet = 1;
        } else if (interLeaving.equals("Band")) {
            imageOffSet = width * height;
        } else if (interLeaving.equals("Line")) {
            imageOffSet = width * numBands;
        }
        imageOffSet *= dataSize / 8;
        imageOffSet *= band - 1;
        return String.valueOf(imageOffSet += headerSize);
    }

    public static String getImageOffset(VRTFileCreator fileCreator, int band) {
        return VRTFormatUtils.getImageOffset(fileCreator.getDataSize(), fileCreator.getHeaderSize(), fileCreator.getInterleaving(), band, fileCreator.getBands(), fileCreator.getImageWidth(), fileCreator.getImageHeight());
    }

    public static String getLineOffset(int dataSize, String interLeaving, int numBands, int width) {
        int lineOffSet = 0;
        if (interLeaving.equals("Pixel")) {
            lineOffSet = width * numBands;
        } else if (interLeaving.equals("Band")) {
            lineOffSet = width;
        } else if (interLeaving.equals("Line")) {
            lineOffSet = width * numBands;
        }
        return String.valueOf(lineOffSet *= dataSize / 8);
    }

    public static String getLineOffset(VRTFileCreator fileCreator) {
        return VRTFormatUtils.getLineOffset(fileCreator.getDataSize(), fileCreator.getInterleaving(), fileCreator.getBands(), fileCreator.getImageWidth());
    }

    public static String getPixelOffset(int dataSize, String interLeaving, int numBands) {
        int pixelOffSet = 0;
        if (interLeaving.equals("Pixel")) {
            pixelOffSet = numBands;
        } else if (interLeaving.equals("Band")) {
            pixelOffSet = 1;
        } else if (interLeaving.equals("Line")) {
            pixelOffSet = 1;
        }
        return String.valueOf(pixelOffSet *= dataSize / 8);
    }

    public static String getPixelOffset(VRTFileCreator fileCreator) {
        return VRTFormatUtils.getPixelOffset(fileCreator.getDataSize(), fileCreator.getInterleaving(), fileCreator.getBands());
    }
}

