/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.raw.ui.listener;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.tool.raw.tool.VRTFileCreator;
import org.gvsig.raster.tools.app.basic.tool.raw.ui.main.OpenRawFileControlsPanel;
import org.gvsig.raster.tools.app.basic.tool.raw.ui.main.OpenRawFileDefaultView;

public class OpenRawFileDefaultViewListener
implements ActionListener {
    private OpenRawFileDefaultView openRawView = null;

    public OpenRawFileDefaultViewListener(OpenRawFileDefaultView view) {
        this.openRawView = view;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand() == "close") {
            this.closeButtonActionPerformed();
        } else if (event.getActionCommand() == "open") {
            this.openButtonActionPerformed();
        }
    }

    private void openButtonActionPerformed() {
        OpenRawFileControlsPanel controls = this.openRawView.getControlsPanel();
        if (!controls.getFile().exists()) {
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"file_doesn_exists"));
            return;
        }
        if (controls.getOutputHeaderFormat().equals("VRT")) {
            String vrtFileName = controls.getFile().getAbsolutePath().replaceAll("\\.raw", ".vrt");
            VRTFileCreator vrt = new VRTFileCreator(vrtFileName);
            vrt.setImageWidth(controls.getImageWidth());
            vrt.setImageHeight(controls.getImageHeight());
            vrt.setBands(controls.getNumberOfBands());
            vrt.setHeaderSize(controls.getHeaderSize());
            vrt.setDataType(controls.getDataType().getVrtOptionName());
            vrt.setDataSize(controls.getDataType().getDataSize());
            vrt.setByteOrder(controls.getByteOrder());
            vrt.setInterleaving(controls.getInterleaving());
            vrt.setRawFile(controls.getFile().getName());
            try {
                vrt.writeFile();
                this.openRawView.setImageFile(vrt.getM_File());
            }
            catch (IOException e) {
                RasterSwingLibrary.messageBoxError((String)"cant_create_vrt_file", (Object)this, (Exception)e);
            }
        }
        this.closeButtonActionPerformed();
    }

    private void closeButtonActionPerformed() {
        OpenRawFileControlsPanel controls = this.openRawView.getControlsPanel();
        controls.stopThread();
        PluginServices.getMDIManager().closeWindow((IWindow)this.openRawView);
    }
}

