/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.raw.ui.main;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.JPanel;
import org.gvsig.gui.beans.openfile.OpenFileContainer;
import org.gvsig.raster.tools.app.basic.tool.raw.tool.VRTFormatOptions;
import org.gvsig.raster.tools.app.basic.tool.raw.ui.main.GeometryPropertiesPanel;
import org.gvsig.raster.tools.app.basic.tool.raw.ui.main.OutputHeaderFormatPanel;

public class OpenRawFileControlsPanel
extends JPanel {
    private static final long serialVersionUID = 6493641545774147712L;
    private final int PANELS_WIDTH = 510;
    private OpenFileContainer openFilePanel = null;
    private GeometryPropertiesPanel geometryPropertiesPanel = null;
    private OutputHeaderFormatPanel outputHeaderFormatPanel = null;
    private boolean calculateFileSize = true;

    public OpenRawFileControlsPanel(String rawFileName) {
        this.initialize();
        this.openFilePanel.getTOpen().setText(rawFileName);
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.gridx = 0;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridx = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getOpenFilePanel(), gridBagConstraints);
        this.add((Component)this.getGeometryPropertiesPanel(), gridBagConstraints1);
        this.add((Component)this.getOutputHeaderFormatPanel(), gridBagConstraints2);
        new CalculateFileSize();
    }

    private OpenFileContainer getOpenFilePanel() {
        if (this.openFilePanel == null) {
            this.openFilePanel = new OpenFileContainer(510, 50, false);
            this.openFilePanel.setPreferredSize(new Dimension(510, 50));
        }
        return this.openFilePanel;
    }

    private GeometryPropertiesPanel getGeometryPropertiesPanel() {
        if (this.geometryPropertiesPanel == null) {
            this.geometryPropertiesPanel = new GeometryPropertiesPanel();
        }
        return this.geometryPropertiesPanel;
    }

    private OutputHeaderFormatPanel getOutputHeaderFormatPanel() {
        if (this.outputHeaderFormatPanel == null) {
            this.outputHeaderFormatPanel = new OutputHeaderFormatPanel();
        }
        return this.outputHeaderFormatPanel;
    }

    public void setFileSize(int fileSize) {
        this.getGeometryPropertiesPanel().setFileSize(fileSize);
    }

    public VRTFormatOptions.UIOption getDataType() {
        return this.getGeometryPropertiesPanel().getDataType();
    }

    public String getByteOrder() {
        return this.getGeometryPropertiesPanel().getByteOrder();
    }

    public String getInterleaving() {
        return this.getGeometryPropertiesPanel().getInterleaving();
    }

    public int getImageWidth() {
        return this.getGeometryPropertiesPanel().getImageWidth();
    }

    public int getImageHeight() {
        return this.getGeometryPropertiesPanel().getImageHeight();
    }

    public int getNumberOfBands() {
        return this.getGeometryPropertiesPanel().getNumberOfBands();
    }

    public int getHeaderSize() {
        return this.getGeometryPropertiesPanel().getHeaderSize();
    }

    public String getOutputHeaderFormat() {
        return this.getOutputHeaderFormatPanel().getOutputHeaderFormat();
    }

    public File getFile() {
        return this.getOpenFilePanel().getFile();
    }

    public void stopThread() {
        this.calculateFileSize = false;
    }

    public class CalculateFileSize
    implements Runnable {
        volatile Thread myThread = null;

        public CalculateFileSize() {
            if (this.myThread == null) {
                this.myThread = new Thread(this);
                this.myThread.start();
            }
        }

        @Override
        public void run() {
            while (OpenRawFileControlsPanel.this.calculateFileSize) {
                File file = OpenRawFileControlsPanel.this.getFile();
                if (file.exists() && file.isFile()) {
                    OpenRawFileControlsPanel.this.getGeometryPropertiesPanel().setFileSize(file.length());
                } else {
                    OpenRawFileControlsPanel.this.getGeometryPropertiesPanel().setFileSize(0L);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

