/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.roi;

import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JComboBox;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.app.project.documents.view.toolListeners.StatusBarListener;
import org.gvsig.fmap.dal.coverage.exception.GridException;
import org.gvsig.fmap.dal.coverage.exception.ROIException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.layers.vectorial.GraphicLayer;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.MouseMovementBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.PointBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.PolygonBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.PolylineBehavior;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PolylineListener;
import org.gvsig.gui.beans.table.TableContainer;
import org.gvsig.gui.beans.table.exceptions.NotInitializeException;
import org.gvsig.gui.beans.table.models.IModel;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.roi.ROI;
import org.gvsig.raster.roi.VectorialROI;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.swing.roi.ROIPanel;
import org.gvsig.raster.swing.roi.ROIPanelDataModel;
import org.gvsig.raster.tools.app.basic.tool.roi.ROIFeatureManager;
import org.gvsig.raster.tools.app.basic.tool.roi.ui.listener.DrawMouseViewListener;

public class ROIDataModel
implements ROIPanelDataModel {
    private FLayer fLayer = null;
    private MapControl mapControl = null;
    private AbstractViewPanel view = null;
    private GraphicLayer graphicLayer = null;
    private String previousTool = null;
    private MapContextManager mapContextManager = MapContextLocator.getMapContextManager();
    private ROIFeatureManager roiFeatureManager = null;
    private Image curImage = null;
    private LinkedHashMap<String, ROI> rois = null;
    private ROIPanel panel = null;
    private List<FLyrVect> fLyrsList = null;
    private File roiFile = null;

    public ROIDataModel(List<FLyrVect> vectLayers) {
        this.fLyrsList = vectLayers;
    }

    public void setROIPanel(ROIPanel panel) {
        this.panel = panel;
        JComboBox list = panel.getLayerList(12);
        list.removeAllItems();
        for (int i = 0; i < this.fLyrsList.size(); ++i) {
            list.addItem(new LayerElement(this.fLyrsList.get(i)));
        }
    }

    public ROIPanel getROIPanel() {
        return this.panel;
    }

    public RasterDataStore getRasterDataStore() {
        return ((FLyrRaster)this.fLayer).getDataStore();
    }

    public void setLayer(FLayer layer) throws GridException {
        this.fLayer = layer;
        if (this.view == null) {
            IWindow[] list = PluginServices.getMDIManager().getAllWindows();
            for (int i = 0; i < list.length; ++i) {
                if (!(list[i] instanceof AbstractViewPanel)) continue;
                this.view = (AbstractViewPanel)list[i];
            }
            if (this.view == null) {
                return;
            }
            this.mapControl = this.view.getMapControl();
            this.graphicLayer = this.view.getMapControl().getMapContext().getGraphicsLayer();
            this.previousTool = this.mapControl.getCurrentTool();
            StatusBarListener sbl = new StatusBarListener(this.mapControl);
            DrawMouseViewListener drawMouseViewListener = new DrawMouseViewListener(this);
            this.mapControl.addBehavior("drawPolygonROI", new Behavior[]{new PolygonBehavior((PolylineListener)drawMouseViewListener), new MouseMovementBehavior((PointListener)sbl)});
            this.mapControl.addBehavior("drawLineROI", new Behavior[]{new PolylineBehavior((PolylineListener)drawMouseViewListener), new MouseMovementBehavior((PointListener)sbl)});
            this.mapControl.addBehavior("drawPointROI", new Behavior[]{new PointBehavior((PointListener)drawMouseViewListener), new MouseMovementBehavior((PointListener)sbl)});
        }
        try {
            this.roiFeatureManager = new ROIFeatureManager(this.fLayer.getMetadataID().toString());
        }
        catch (MetadataException e) {
            throw new GridException("Can't create ROI", (Exception)((Object)e));
        }
        this.clearROIs();
        this.loadROIs();
    }

    public void clearROIs() {
        try {
            this.panel.getTable().removeAllRows();
        }
        catch (NotInitializeException e) {
            RasterSwingLibrary.messageBoxError((String)"error_tabla_rois", (Object)this, (Exception)((Object)e));
        }
        boolean repaint = this.roiFeatureManager.clear(this.graphicLayer);
        if (repaint) {
            this.getMapControl().rePaintDirtyLayers();
        }
        this.getRois().clear();
    }

    private LinkedHashMap<String, ROI> getRois() {
        if (this.rois == null) {
            this.rois = new LinkedHashMap();
        }
        return this.rois;
    }

    private void loadROIs() throws GridException {
        List roisArray = null;
        try {
            roisArray = ((FLyrRaster)this.fLayer).getRois();
        }
        catch (ROIException e) {
            RasterSwingLibrary.messageBoxError((String)"problems_loading_rois", (Object)this, (Exception)((Object)e));
        }
        this.loadROIs(roisArray);
    }

    private void loadROIs(List<ROI> roisArray) throws GridException {
        if (roisArray != null) {
            ISymbol symbol = null;
            FeatureStore store = this.graphicLayer.getFeatureStore();
            try {
                store.edit();
                for (ROI roi : roisArray) {
                    int nPoints = 0;
                    int nPolygons = 0;
                    int nLines = 0;
                    Object[] row = ((IModel)this.panel.getTable().getModel()).getNewLine();
                    row[0] = roi.getName();
                    row[4] = roi.getColor();
                    this.addROI(roi);
                    VectorialROI vectorialROI = (VectorialROI)roi;
                    for (Geometry geometry : vectorialROI.getGeometries()) {
                        symbol = this.mapContextManager.getSymbolManager().createSymbol(geometry.getType(), roi.getColor());
                        switch (geometry.getType()) {
                            case 1: {
                                ++nPoints;
                                break;
                            }
                            case 3: {
                                ++nPolygons;
                                break;
                            }
                            case 2: {
                                ++nLines;
                            }
                        }
                        EditableFeature feature = this.roiFeatureManager.addROIFeature((ROI)vectorialROI, this.graphicLayer, geometry, symbol);
                        store.insert(feature);
                    }
                    row[1] = new Integer(nPolygons);
                    row[2] = new Integer(nLines);
                    row[3] = new Integer(nPoints);
                    this.panel.getTable().getModel().addRow(row);
                }
                store.finishEditing();
            }
            catch (DataException e) {
                throw new GridException("Error loading ROIs from layer " + this.fLayer.getName(), (Exception)((Object)e));
            }
            this.selectDrawRoiTool();
            this.getMapControl().drawGraphics();
        }
    }

    public void addROI(ROI roi) {
        this.getRois().put(roi.getName(), roi);
    }

    public void selectDrawRoiTool() {
        if (this.mapControl != null) {
            if (this.panel.getButton(4).isSelected()) {
                Image img;
                this.curImage = img = IconThemeHelper.getImageIcon((String)"polygon-cursor").getImage();
                this.mapControl.setTool("drawPolygonROI");
            } else if (this.panel.getButton(6).isSelected()) {
                Image img;
                this.curImage = img = IconThemeHelper.getImageIcon((String)"line-cursor").getImage();
                this.mapControl.setTool("drawLineROI");
            } else if (this.panel.getButton(5).isSelected()) {
                Image img;
                this.curImage = img = IconThemeHelper.getImageIcon((String)"point-cursor").getImage();
                this.mapControl.setTool("drawPointROI");
            }
        }
    }

    public void changeRoiName(String currentName, String newName) throws DataException {
        this.getROI(currentName).setName(newName);
        this.getRois().put(newName, (ROI)this.getRois().remove(currentName));
        this.roiFeatureManager.changeROIName(currentName, newName, this.graphicLayer);
    }

    public void removeROI(String roiName) {
        this.getRois().remove(roiName);
        boolean repaint = this.roiFeatureManager.removeROI(roiName, this.graphicLayer);
        if (repaint) {
            this.getMapControl().rePaintDirtyLayers();
        }
    }

    public void clearRoiGraphics() {
        this.roiFeatureManager.clearFeaturesFromGraphicLayer(this.graphicLayer);
    }

    public MapControl getMapControl() {
        return this.mapControl;
    }

    public TableContainer getTable() {
        return this.panel.getTable();
    }

    public ROI getROI(String roiName) {
        return this.getRois().get(roiName);
    }

    public GraphicLayer getGraphicLayer() {
        return this.graphicLayer;
    }

    public void setPreviousTool() {
        if (this.previousTool != null) {
            this.getMapControl().setTool(this.previousTool);
        }
    }

    public List<ROI> getROIs() {
        return new ArrayList<ROI>(this.getRois().values());
    }

    public void setROIs(List<ROI> roisArray) throws GridException {
        this.loadROIs(roisArray);
    }

    public FLayer getFLayer() {
        return this.fLayer;
    }

    public ROIFeatureManager getRoiFeatureManager() {
        return this.roiFeatureManager;
    }

    public Image getToolImage() {
        return this.curImage;
    }

    public void setROIFile(File file) {
        this.roiFile = file;
    }

    public File getROIFile() {
        return this.roiFile;
    }

    public class LayerElement {
        private FLyrVect lyr = null;

        public LayerElement(FLyrVect lyr) {
            this.lyr = lyr;
        }

        public FLyrVect getLayer() {
            return this.lyr;
        }

        public String toString() {
            return this.lyr.getName();
        }
    }
}

