/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.roi.ui.listener;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.cresques.cts.IProjection;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.view.BaseViewDocument;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.exception.FileNotExistsException;
import org.gvsig.fmap.dal.coverage.exception.GridException;
import org.gvsig.fmap.dal.coverage.exception.ROIException;
import org.gvsig.fmap.dal.coverage.exception.RmfSerializerException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelEvent;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelListener;
import org.gvsig.gui.beans.table.exceptions.NotInitializeException;
import org.gvsig.gui.beans.table.models.IModel;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.roi.ROI;
import org.gvsig.raster.roi.ROIReader;
import org.gvsig.raster.roi.ROIWriter;
import org.gvsig.raster.roi.VectorialROI;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.swing.roi.ROIPanel;
import org.gvsig.raster.tools.app.basic.tool.roi.ROIDataModel;
import org.gvsig.raster.tools.app.basic.tool.roi.ROIFeatureManager;
import org.gvsig.raster.tools.app.basic.tool.roi.ui.ROIWindow;
import org.gvsig.raster.tools.app.basic.tool.roi.ui.listener.ShpFileFilter;

public class ROIsTablePanelListener
implements ButtonsPanelListener,
ActionListener,
ListSelectionListener,
TableModelListener {
    private ROIPanel panel = null;
    private ROIDataModel dataModel = null;
    private String roiSelectedName = "";
    private ROIWindow window = null;
    private File lastDirectory = null;
    private String defaultROIFileName = null;

    public ROIsTablePanelListener(ROIPanel panel, ROIDataModel dataModel, ROIWindow window) {
        this.panel = panel;
        this.dataModel = dataModel;
        this.window = window;
    }

    public void setDefaultROIFileName(String defaultROIFileName) {
        this.defaultROIFileName = defaultROIFileName;
    }

    public void setPathToROI(File ROI2) {
        this.lastDirectory = ROI2;
    }

    public void actionButtonPressed(ButtonsPanelEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj;
        if (e.getSource() == this.panel.getButton(7)) {
            try {
                String roiName = "ROI-" + String.valueOf(System.currentTimeMillis());
                Object[] row = ((IModel)this.panel.getTable().getModel()).getNewLine();
                row[0] = roiName;
                this.panel.getTable().getModel().addRow(row);
                VectorialROI roi = RasterLocator.getManager().createVectorialROI(this.dataModel.getRasterDataStore());
                roi.setName(roiName);
                roi.setColor((Color)row[4]);
                this.dataModel.addROI((ROI)roi);
                this.panel.getTable().setSelectedIndex(this.panel.getTable().getRowCount() - 1);
                this.dataModel.selectDrawRoiTool();
                this.panel.setToolsEnabled(true);
            }
            catch (NotInitializeException e1) {
                RasterSwingLibrary.messageBoxError((String)"error_tabla_rois", (Object)this.panel, (Exception)((Object)e1));
                this.window.close();
            }
        } else if (e.getSource() == this.panel.getButton(8)) {
            try {
                if (this.panel.getTable().getSelectedRows().length > 0) {
                    String className = (String)this.panel.getTable().getModel().getValueAt(this.panel.getTable().getSelectedRow(), 0);
                    this.dataModel.removeROI(className);
                    int selectedRow = this.panel.getTable().getSelectedRow();
                    this.panel.getTable().getModel().removeRow(selectedRow);
                    selectedRow = selectedRow >= this.panel.getTable().getRowCount() ? this.panel.getTable().getRowCount() - 1 : selectedRow;
                    this.panel.getTable().setSelectedIndex(selectedRow);
                }
            }
            catch (NotInitializeException e1) {
                RasterSwingLibrary.messageBoxError((String)"error_tabla_rois", (Object)this.panel, (Exception)((Object)e1));
                this.window.close();
            }
        } else if (e.getSource() == this.panel.getButton(5)) {
            this.panel.getButton(5).setSelected(true);
            this.panel.getButton(6).setSelected(false);
            this.panel.getButton(4).setSelected(false);
            this.dataModel.selectDrawRoiTool();
        } else if (e.getSource() == this.panel.getButton(6)) {
            this.panel.getButton(6).setSelected(true);
            this.panel.getButton(5).setSelected(false);
            this.panel.getButton(4).setSelected(false);
            this.dataModel.selectDrawRoiTool();
        } else if (e.getSource() == this.panel.getButton(4)) {
            this.panel.getButton(4).setSelected(true);
            this.panel.getButton(6).setSelected(false);
            this.panel.getButton(5).setSelected(false);
            this.dataModel.selectDrawRoiTool();
        } else if (e.getSource() == this.panel.getButton(9)) {
            this.showChooserDialog(9);
        } else if (e.getSource() == this.panel.getButton(10)) {
            this.showChooserDialog(10);
        } else if (e.getSource() == this.panel.getButton(13)) {
            if (RasterSwingLibrary.messageBoxYesOrNot((String)"remove_roi_file_link", null)) {
                this.dataModel.clearROIs();
                this.removeLinkBetweenFileROIAndLayer();
            }
        } else if (e.getSource() == this.panel.getButton(11) && (obj = this.panel.getLayerList(12).getSelectedItem()) instanceof ROIDataModel.LayerElement) {
            FLyrVect lyrVect = ((ROIDataModel.LayerElement)obj).getLayer();
            ROIReader reader = null;
            try {
                reader = RasterLocator.getManager().createVectorialROIReader(lyrVect.getFeatureStore(), this.dataModel.getRasterDataStore(), this.getProjectionFromLayer());
                List rois = reader.read(this.dataModel.getROIs());
                this.dataModel.clearROIs();
                this.dataModel.setROIs(rois);
                DataStoreParameters params = lyrVect.getDataStore().getParameters();
                if (params instanceof FilesystemStoreParameters) {
                    this.dataModel.setROIFile(((FilesystemStoreParameters)params).getFile());
                }
            }
            catch (ROIException e1) {
                RasterSwingLibrary.messageBoxError((String)"error_file_not_valid", (Object)this.panel, (Exception)((Object)e1));
            }
            catch (GridException e1) {
                RasterSwingLibrary.messageBoxError((String)"error_file_not_valid", (Object)this.panel, (Exception)((Object)e1));
            }
        }
    }

    private void removeLinkBetweenFileROIAndLayer() {
        try {
            ((FLyrRaster)this.dataModel.getFLayer()).setROIsFiles(null);
        }
        catch (RmfSerializerException e) {
            RasterSwingLibrary.messageBoxError((String)"error_saving_rois_rmf", (Object)this.panel, (Exception)((Object)e));
        }
    }

    private void showChooserDialog(int action) {
        File file;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.removeChoosableFileFilter(fileChooser.getAcceptAllFileFilter());
        fileChooser.addChoosableFileFilter(new ShpFileFilter());
        fileChooser.setSelectedFile(new File(this.defaultROIFileName));
        File oldROIFile = this.dataModel.getROIFile();
        if (oldROIFile != null) {
            fileChooser.setCurrentDirectory(oldROIFile);
            fileChooser.setSelectedFile(oldROIFile);
        } else {
            fileChooser.setCurrentDirectory(this.lastDirectory);
        }
        if (action == 10 && fileChooser.showOpenDialog(this.panel.getComponent()) == 0) {
            file = fileChooser.getSelectedFile();
            this.loadROIFromFile(file);
        }
        if (action == 9 && fileChooser.showSaveDialog(this.panel.getComponent()) == 0) {
            file = fileChooser.getSelectedFile();
            this.saveROIToFile(file);
        }
    }

    private void saveROIToFile(File file) {
        this.lastDirectory = new File(file.getParent());
        if (file.exists() && !RasterSwingLibrary.messageBoxYesOrNot((String)"raster_error_file_exists", null)) {
            return;
        }
        ROIWriter writer = RasterLocator.getManager().createROIWriter(file.getPath(), this.getProjectionFromLayer());
        writer.write(this.dataModel.getROIs());
        this.dataModel.setROIFile(file);
    }

    private void loadROIFromFile(File file) {
        this.lastDirectory = new File(file.getParent());
        try {
            ROIReader reader = RasterLocator.getManager().createROIReader(file.getPath(), this.dataModel.getRasterDataStore(), this.getProjectionFromLayer());
            this.dataModel.clearROIs();
            List rois = reader.read(this.dataModel.getROIs());
            this.dataModel.setROIFile(file);
            this.dataModel.setROIs(rois);
        }
        catch (FileNotExistsException e1) {
            RasterSwingLibrary.messageBoxError((String)"error_file_not_found", (Object)this.panel, (Exception)((Object)e1));
        }
        catch (ROIException e1) {
            RasterSwingLibrary.messageBoxError((String)"problems_loading_rois", (Object)this.panel, (Exception)((Object)e1));
        }
        catch (GridException e1) {
            RasterSwingLibrary.messageBoxError((String)"problems_loading_rois", (Object)this.panel, (Exception)((Object)e1));
        }
    }

    private IProjection getProjectionFromLayer() {
        Document doc;
        IProjection proj = this.dataModel.getFLayer().getProjection();
        if (proj == null && (doc = ApplicationLocator.getManager().getActiveDocument()) instanceof BaseViewDocument) {
            proj = ((BaseViewDocument)doc).getProjection();
        }
        return proj;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            if (this.panel.getTable().getSelectedRows().length <= 0) {
                this.panel.setToolsEnabled(false);
                this.dataModel.setPreviousTool();
            } else {
                this.panel.setToolsEnabled(true);
                this.dataModel.selectDrawRoiTool();
                int selectedRow = this.panel.getTable().getSelectedRow();
                this.roiSelectedName = (String)this.panel.getTable().getTable().getJTable().getValueAt(selectedRow, 0);
            }
        }
        catch (NotInitializeException e1) {
            RasterSwingLibrary.messageBoxError((String)"error_rois_table", (Object)this.panel, (Exception)((Object)e1));
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        try {
            if (e.getColumn() == 4) {
                String roiName = (String)this.panel.getTable().getTable().getJTable().getValueAt(e.getFirstRow(), 0);
                if (this.dataModel.getMapControl() != null) {
                    ROIFeatureManager roiFeatureManager = this.dataModel.getRoiFeatureManager();
                    Color color = (Color)this.panel.getTable().getTable().getJTable().getValueAt(e.getFirstRow(), 4);
                    roiFeatureManager.changeColor(this.dataModel.getGraphicLayer(), roiName, color);
                    this.dataModel.getROI(roiName).setColor(color);
                    this.dataModel.getMapControl().drawGraphics();
                    this.dataModel.getMapControl().getMapContext().invalidate();
                }
            } else if (e.getColumn() == 0) {
                String newName = (String)this.panel.getTable().getTable().getJTable().getValueAt(e.getFirstRow(), 0);
                this.dataModel.changeRoiName(this.roiSelectedName, newName);
                this.roiSelectedName = newName;
            }
        }
        catch (DataException e1) {
            RasterSwingLibrary.messageBoxError((String)"error_getting_roi_features", (Object)this.panel, (Exception)((Object)e1));
        }
    }
}

