/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.saveraster.ui.listener;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JOptionPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.RasterWriter;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelEvent;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelListener;
import org.gvsig.gui.beans.propertiespanel.PropertiesPanel;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.mainplugin.config.Configuration;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.tool.saveraster.operation.RasterizerLayer;
import org.gvsig.raster.tools.app.basic.tool.saveraster.operation.SaveRasterActions;
import org.gvsig.raster.tools.app.basic.tool.saveraster.operation.SaveRasterProcess;
import org.gvsig.raster.tools.app.basic.tool.saveraster.ui.SaveRasterDialog;
import org.gvsig.raster.tools.app.basic.tool.saveraster.ui.SaveRasterPanel;
import org.gvsig.raster.tools.app.basic.tool.saveraster.ui.property.WriterPropertiesDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveRasterDialogListener
implements ButtonsPanelListener {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private Logger log = LoggerFactory.getLogger(SaveRasterDialogListener.class);
    private SaveRasterDialog dialog = null;
    private FLayers layers = null;
    private MapControl mapCtrl = null;
    private RasterWriter writer = null;

    public SaveRasterDialogListener(SaveRasterDialog dialog, FLayers layers, MapControl mapCtrl) {
        this.dialog = dialog;
        this.layers = layers;
        this.mapCtrl = mapCtrl;
        dialog.addButtonPressedListener(this);
        dialog.getControlsPanel().getBProperties().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveRasterDialogListener.this.propsButtonActionPerformed(evt);
            }
        });
    }

    public void actionButtonPressed(ButtonsPanelEvent e) {
        switch (e.getButton()) {
            case 3: {
                this.acceptButtonActionPerformed(e);
                break;
            }
            case 6: {
                this.dialog.closeJDialog();
            }
        }
    }

    private boolean acceptButtonActionPerformed(ButtonsPanelEvent e) {
        SaveRasterPanel controlPanel = this.dialog.getControlsPanel();
        String fName = this.dialog.getDataInputListener().getFileName();
        Dimension dimension = new Dimension((int)this.dialog.getDataInputListener().getWidthInPixels(), (int)this.dialog.getDataInputListener().getHeightInPixels());
        if ((this.dialog.getDataInputListener().getWidthInPixels() > 20000.0 || this.dialog.getDataInputListener().getHeightInPixels() > 20000.0) && !RasterSwingLibrary.messageBoxYesOrNot((String)"output_file_too_big", null)) {
            return false;
        }
        File f = new File(fName);
        if (f.exists() && !RasterSwingLibrary.messageBoxYesOrNot((String)"raster_error_file_exists", (Object)((Object)this.dialog))) {
            return false;
        }
        f = new File(fName.substring(0, fName.lastIndexOf(File.separator)));
        if (f.exists() && f.isDirectory() && !f.canWrite()) {
            RasterSwingLibrary.messageBoxError((String)"error_file_not_writable", (Object)((Object)this.dialog));
            return false;
        }
        this.dialog.getDataInputListener().resetFileName();
        this.dialog.getDataInputListener().enableButtons();
        double lrX = Double.parseDouble(controlPanel.getTInfDerX().getValue());
        double lrY = Double.parseDouble(controlPanel.getTInfDerY().getValue());
        double ulX = Double.parseDouble(controlPanel.getTSupIzqX().getValue());
        double ulY = Double.parseDouble(controlPanel.getTSupIzqY().getValue());
        Envelope ext = null;
        try {
            ext = geomManager.createEnvelope(ulX, lrY, lrX, ulY, 0);
        }
        catch (CreateEnvelopeException e1) {
            this.log.debug("Error creating the envelope", null, (Object)e1);
        }
        long bytes = RasterLocator.getManager().getRasterUtils().getBytesFromRaster((int)dimension.getWidth(), (int)dimension.getHeight(), 0, 3);
        long maxJp2 = 487500000L;
        if (fName.endsWith(".jp2") && bytes > maxJp2 && !RasterSwingLibrary.messageBoxYesOrNot((String)"output_file_too_big_jpeg2000", null)) {
            return false;
        }
        Params params = this.getWriterParams(fName);
        int blockSize = this.getBlockSize(params, this.layers);
        ViewPort viewPort = new ViewPort(this.mapCtrl.getViewPort().getProjection());
        viewPort.setBackColor(this.mapCtrl.getViewPort().getBackColor());
        viewPort.setImageSize(dimension);
        viewPort.setEnvelope(ext);
        RasterizerLayer rasterizerLayer = new RasterizerLayer(this.layers, viewPort, blockSize);
        SaveRasterProcess saveRasterProcess = new SaveRasterProcess();
        saveRasterProcess.setActions(new SaveRasterActions());
        saveRasterProcess.addParam("viewport", viewPort);
        saveRasterProcess.addParam("dimension", dimension);
        saveRasterProcess.addParam("rasterizerlayer", rasterizerLayer);
        saveRasterProcess.addParam("filename", fName);
        saveRasterProcess.addParam("writerparams", params);
        saveRasterProcess.start();
        return true;
    }

    private void propsButtonActionPerformed(ActionEvent e) {
        String name = this.dialog.getDataInputListener().getFileName();
        if (name == null || name.equals("")) {
            return;
        }
        Params params = this.getWriterParams(name);
        PropertiesPanel panel = new PropertiesPanel();
        WriterPropertiesDialog dialog = new WriterPropertiesDialog(panel, params);
        PluginServices.getMDIManager().addWindow((IWindow)dialog);
    }

    private Params getWriterParams(String name) {
        RasterManager rManager = RasterLocator.getManager();
        String ext = rManager.getFileUtils().getExtensionFromFileName(name);
        try {
            if (this.writer == null) {
                this.writer = rManager.createWriter(name);
            } else {
                String oldType;
                String newType = rManager.getProviderServices().getWriteDriverType(ext);
                if (!newType.equals(oldType = this.writer.getDriverName())) {
                    this.writer = rManager.createWriter(name);
                }
            }
            if (this.writer == null) {
                JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"no_driver_escritura"));
            }
            return this.writer.getParams();
        }
        catch (NotSupportedExtensionException e1) {
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"no_driver_escritura"));
            return null;
        }
        catch (RasterDriverException e1) {
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"no_driver_escritura"));
            return null;
        }
    }

    private int getBlockSize(Params params, FLayers flyrs) {
        int blockSize = Configuration.getValue((String)"cache_blockheight", (Integer)RasterLibrary.blockHeight);
        blockSize = RasterLibrary.blockHeight;
        int[] wBlock = null;
        boolean isTiling = false;
        int block = Integer.MAX_VALUE;
        for (int i = 0; i < flyrs.getLayersCount(); ++i) {
            if (!(flyrs.getLayer(i) instanceof FLyrRaster) || !((FLyrRaster)flyrs.getLayer(i)).isTiled() || (wBlock = ((FLyrRaster)flyrs.getLayer(i)).getTileSize())[0] - 1 >= block) continue;
            block = wBlock[0] - 1;
            isTiling = true;
        }
        if (isTiling) {
            params.changeParamValue("blocksize", (Object)String.valueOf(block));
            return block;
        }
        return blockSize;
    }
}

