/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.selectrasterlayer;

import java.awt.geom.Point2D;
import javax.swing.JScrollBar;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.tools.app.basic.tool.selectrasterlayer.SelectImageListImpl;

public class SelectImageListener
extends SelectImageListImpl {
    private Envelope extentLayer = null;

    public SelectImageListener(MapControl mapCtrl) {
        super(mapCtrl);
    }

    @Override
    public void point(PointEvent event) {
        int i;
        super.point(event);
        Point2D pointSelect = event.getPoint();
        if (PluginServices.getMainFrame() != null) {
            PluginServices.getMainFrame().enableControls();
        }
        ViewPort vp = this.mapCtrl.getMapContext().getViewPort();
        this.wcPoint = vp.toMapPoint((int)pointSelect.getX(), (int)pointSelect.getY());
        FLayers layers = this.mapCtrl.getMapContext().getLayers();
        for (i = 0; i < layers.getLayersCount(); ++i) {
            layers.getLayer(i).setActive(false);
        }
        for (i = layers.getLayersCount() - 1; i >= 0 && !this.select(layers.getLayer(i), i); --i) {
        }
    }

    private boolean select(FLayer layer, int pos) {
        if (layer instanceof FLayers) {
            FLayers laux = (FLayers)layer;
            for (int j = laux.getLayersCount() - 1; j >= 0; --j) {
                if (!this.select(laux.getLayer(j), j)) continue;
                return true;
            }
        } else {
            try {
                this.extentLayer = layer.getFullEnvelope();
            }
            catch (ReadException exc) {
                NotificationManager.addError((String)"Error al obtener el extent", (Throwable)exc);
            }
            if (this.extentLayer.getMaximum(0) >= this.wcPoint.getX() && this.extentLayer.getMinimum(0) <= this.wcPoint.getX() && this.extentLayer.getMaximum(1) >= this.wcPoint.getY() && this.extentLayer.getMinimum(1) <= this.wcPoint.getY() && layer.isVisible() && layer instanceof FLyrRaster) {
                layer.setActive(true);
                AbstractViewPanel view = (AbstractViewPanel)PluginServices.getMDIManager().getActiveWindow();
                JScrollBar verticalBar = view.getTOC().getJScrollPane().getVerticalScrollBar();
                double widthPerEntry = verticalBar.getMaximum() / layer.getMapContext().getLayers().getLayersCount();
                verticalBar.setValue((int)widthPerEntry * (layer.getMapContext().getLayers().getLayersCount() - pos - 1));
                return true;
            }
        }
        return false;
    }
}

