/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.setviewprojection;

import javax.swing.Icon;
import org.cresques.Messages;
import org.cresques.cts.IProjection;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.app.project.documents.view.toc.AbstractTocContextMenuAction;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.layers.IRasterLayerActions;
import org.gvsig.raster.mainplugin.toolbar.IGenericToolBarMenuItem;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.RasterToolsUtil;

public class SetViewProjectionTocMenuEntry
extends AbstractTocContextMenuAction
implements IGenericToolBarMenuItem {
    private static SetViewProjectionTocMenuEntry singleton = null;
    FLayer lyr = null;

    public String getGroup() {
        return "GeoRaster";
    }

    public int getGroupOrder() {
        return 10;
    }

    public int getOrder() {
        return 20;
    }

    public String getText() {
        return RasterToolsUtil.getText((Object)this, "set_view_projection");
    }

    public static SetViewProjectionTocMenuEntry getSingleton() {
        if (singleton == null) {
            singleton = new SetViewProjectionTocMenuEntry();
        }
        return singleton;
    }

    public boolean isEnabled(ITocItem item, FLayer[] selectedItems) {
        return true;
    }

    public boolean isVisible(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        if (!(selectedItems[0] instanceof IRasterLayerActions)) {
            return false;
        }
        return ((IRasterLayerActions)selectedItems[0]).isActionEnabled(18);
    }

    public void execute(ITocItem item, FLayer[] selectedItems) {
        FLayer fLayer = null;
        if (selectedItems.length != 1) {
            return;
        }
        fLayer = selectedItems[0];
        if (!(fLayer instanceof FLyrRaster)) {
            return;
        }
        FLyrRaster inputLayer = (FLyrRaster)fLayer;
        IProjection viewProjection = inputLayer.getMapContext().getProjection();
        if (RasterSwingLibrary.messageBoxYesOrNot((String)Messages.getText((String)"overwrite_projection"), null)) {
            inputLayer.setProjection(viewProjection);
        }
    }

    public Icon getIcon() {
        return IconThemeHelper.getImageIcon((String)"setviewprojection-raster-icon");
    }
}

