/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.algorithm.swing.impl.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InputFieldPanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    public static int DOUBLE = 0;
    public static int INT = 1;
    private JFormattedTextField box;
    private PropertyChangeListener listener = null;
    private JLabel label = null;
    private int type = -1;

    public InputFieldPanel(String txt, int type) {
        this.type = type;
        if (type == DOUBLE) {
            this.box = new JFormattedTextField(new DecimalFormat("########.########"));
            this.box.setValue(0.0);
        }
        if (type == INT) {
            this.box = new JFormattedTextField(new DecimalFormat("########"));
            this.box.setValue(0);
        }
        this.box.addPropertyChangeListener("value", this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.getLabel().setText(txt + " ");
        this.add((Component)this.getLabel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.box, gridBagConstraints);
    }

    public JLabel getLabel() {
        if (this.label == null) {
            this.label = new JLabel();
        }
        return this.label;
    }

    public void setText(String txt) {
        this.getLabel().setText(txt + " ");
    }

    public String getValue() {
        if (this.type == DOUBLE) {
            double n = ((Number)this.box.getValue()).doubleValue();
            return Double.toString(n);
        }
        if (this.type == INT) {
            int n = ((Number)this.box.getValue()).intValue();
            return Integer.toString(n);
        }
        return null;
    }

    public void setValue(String value) {
        if (this.type == DOUBLE) {
            this.box.setValue(new Double(value));
        }
        if (this.type == INT) {
            this.box.setValue(new Integer(value));
        }
    }

    public void setListener(PropertyChangeListener listener) {
        this.listener = listener;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.listener != null) {
            this.listener.propertyChange(evt);
        }
    }

    public void setEnable(boolean enabled) {
        this.box.setEnabled(enabled);
        this.getLabel().setEnabled(enabled);
    }

    public JFormattedTextField getTextField() {
        return this.box;
    }
}

