/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.prov.kml.parser;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.gpe.prov.kml.parser.GPEDeafultKmlParser;
import org.gvsig.gpe.prov.kml.parser.profiles.Kml2_1_BindingProfile;
import org.gvsig.gpe.prov.xml.utils.NamespaceAwareComparator;

public class GPEKmz2_1_Parser
extends GPEDeafultKmlParser {
    public GPEKmz2_1_Parser() {
        this.setProfile(new Kml2_1_BindingProfile());
        this.qNameComparator = new NamespaceAwareComparator();
    }

    public String getDescription() {
        return "This parser parses KML 2.1";
    }

    public String getName() {
        return "KMZ v2.1";
    }

    public String getFormat() {
        return "application/zip; subtype=kml/2.1";
    }

    protected InputStream createInputStream(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
            ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                ZipFile fz = new ZipFile(file);
                if (!FilenameUtils.getExtension((String)entry.getName()).equalsIgnoreCase("KML")) continue;
                return fz.getInputStream(entry);
            }
        }
        catch (FileNotFoundException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
        catch (ZipException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
        return null;
    }

    public boolean accept(URI uri) {
        return uri.getPath().toUpperCase().endsWith("KMZ");
    }

    public boolean accept(File file) {
        return file.getPath().toUpperCase().endsWith("KMZ");
    }
}

