/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.prov.kml.parser.v21.coordinates;

import java.io.IOException;
import org.gvsig.gpe.lib.api.parser.ICoordinateIterator;
import org.gvsig.gpe.prov.kml.parser.GPEDeafultKmlParser;
import org.gvsig.gpe.prov.kml.parser.v21.coordinates.KmlCoodinatesIterator;
import org.gvsig.gpe.prov.kml.utils.Kml2_1_Tags;
import org.gvsig.xmlpull.lib.api.stream.IQName;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamReader;
import org.gvsig.xmlpull.lib.api.stream.XmlStreamException;

public class LatLonAltBoxIterator
extends KmlCoodinatesIterator {
    double[] min = null;
    double[] max = null;
    int iterations = 0;

    public Object parse(IXmlStreamReader parser, GPEDeafultKmlParser handler) throws XmlStreamException, IOException {
        boolean endFeature = false;
        Object bbox = null;
        this.min = new double[3];
        this.max = new double[3];
        this.iterations = 0;
        this.dimension = 3;
        String id = handler.getProfile().getGeometryBinding().getID(parser, handler);
        IQName tag = parser.getName();
        int currentTag = parser.getEventType();
        while (!endFeature) {
            switch (currentTag) {
                case 1: {
                    if (handler.getQNameComparator().equals(tag, Kml2_1_Tags.NORTH)) {
                        parser.next();
                        this.max[1] = handler.getProfile().getDoubleBinding().parse(parser.getText());
                        break;
                    }
                    if (handler.getQNameComparator().equals(tag, Kml2_1_Tags.SOUTH)) {
                        parser.next();
                        this.min[1] = handler.getProfile().getDoubleBinding().parse(parser.getText());
                        break;
                    }
                    if (handler.getQNameComparator().equals(tag, Kml2_1_Tags.EAST)) {
                        parser.next();
                        this.max[0] = handler.getProfile().getDoubleBinding().parse(parser.getText());
                        break;
                    }
                    if (handler.getQNameComparator().equals(tag, Kml2_1_Tags.WEST)) {
                        parser.next();
                        this.min[0] = handler.getProfile().getDoubleBinding().parse(parser.getText());
                        break;
                    }
                    if (handler.getQNameComparator().equals(tag, Kml2_1_Tags.MINALTITUDE)) {
                        parser.next();
                        this.min[2] = handler.getProfile().getDoubleBinding().parse(parser.getText());
                        break;
                    }
                    if (!handler.getQNameComparator().equals(tag, Kml2_1_Tags.MAXALTITUDE)) break;
                    parser.next();
                    this.max[2] = handler.getProfile().getDoubleBinding().parse(parser.getText());
                    break;
                }
                case 2: {
                    if (!handler.getQNameComparator().equals(tag, Kml2_1_Tags.LATLONALTBOX)) break;
                    endFeature = true;
                    bbox = handler.getContentHandler().startBbox(id, (ICoordinateIterator)this, "EPSG:4326");
                    handler.getContentHandler().endBbox(bbox);
                    break;
                }
            }
            if (endFeature) continue;
            currentTag = parser.next();
            tag = parser.getName();
        }
        return bbox;
    }

    public boolean hasNext() throws IOException {
        return this.iterations < 2;
    }

    public void next(double[] buffer) throws IOException {
        if (this.iterations == 0) {
            for (int i = 0; i < buffer.length; ++i) {
                buffer[i] = this.min[i];
            }
            this.iterations = 1;
            return;
        }
        if (this.iterations == 1) {
            for (int i = 0; i < buffer.length; ++i) {
                buffer[i] = this.max[i];
            }
            this.iterations = 2;
        }
    }
}

