/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.prov.kml.parser.v21.geometries;

import java.io.IOException;
import org.gvsig.gpe.prov.kml.parser.GPEDeafultKmlParser;
import org.gvsig.gpe.prov.kml.utils.Kml2_1_Tags;
import org.gvsig.xmlpull.lib.api.stream.IQName;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamReader;
import org.gvsig.xmlpull.lib.api.stream.XmlStreamException;

public class MultiGeometryBinding {
    public Object parse(IXmlStreamReader parser, GPEDeafultKmlParser handler) throws XmlStreamException, IOException {
        boolean endFeature = false;
        Object multiGeometry = null;
        String id = handler.getProfile().getGeometryBinding().getID(parser, handler);
        IQName tag = parser.getName();
        int currentTag = parser.getEventType();
        while (!endFeature) {
            switch (currentTag) {
                case 1: {
                    if (handler.getQNameComparator().equals(tag, Kml2_1_Tags.POINT)) {
                        if (multiGeometry == null) {
                            multiGeometry = handler.getContentHandler().startMultiPoint(id, "EPSG:4326");
                        }
                        Object point = handler.getProfile().getPointTypeBinding().parse(parser, handler);
                        handler.getContentHandler().addGeometryToMultiGeometry(point, multiGeometry);
                        break;
                    }
                    if (handler.getQNameComparator().equals(tag, Kml2_1_Tags.LINESTRING)) {
                        if (multiGeometry == null) {
                            multiGeometry = handler.getContentHandler().startMultiLineString(id, "EPSG:4326");
                        }
                        Object lineString = handler.getProfile().getLineStringTypeBinding().parse(parser, handler);
                        handler.getContentHandler().addGeometryToMultiGeometry(lineString, multiGeometry);
                        break;
                    }
                    if (handler.getQNameComparator().equals(tag, Kml2_1_Tags.POLYGON)) {
                        if (multiGeometry == null) {
                            multiGeometry = handler.getContentHandler().startMultiPolygon(id, "EPSG:4326");
                        }
                        Object polygon = handler.getProfile().getPolygonTypeBinding().parse(parser, handler);
                        handler.getContentHandler().addGeometryToMultiGeometry(polygon, multiGeometry);
                        break;
                    }
                    if (multiGeometry != null) break;
                    multiGeometry = handler.getContentHandler().startMultiGeometry(id, "EPSG:4326");
                    break;
                }
                case 2: {
                    if (!handler.getQNameComparator().equals(tag, Kml2_1_Tags.MULTIGEOMETRY)) break;
                    endFeature = true;
                    multiGeometry = handler.getContentHandler().endMultiGeometry(multiGeometry);
                    break;
                }
            }
            if (endFeature) continue;
            currentTag = parser.next();
            tag = parser.getName();
        }
        return multiGeometry;
    }
}

