/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.prov.kml.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.gpe.lib.api.writer.ICoordinateSequence;
import org.gvsig.gpe.prov.kml.utils.Kml2_1_Tags;
import org.gvsig.gpe.prov.kml.writer.MetadataElement;
import org.gvsig.gpe.prov.kml.writer.profiles.IWriterProfile;
import org.gvsig.gpe.prov.xml.writer.GPEXmlWriterHandlerImplementor;

public abstract class GPEKmlWriterHandlerImplementor
extends GPEXmlWriterHandlerImplementor {
    private int layerLevel = 0;
    private IWriterProfile profile = null;
    private List metadataElements;
    private MetadataElement currentMetadataElement = null;

    public String getDefaultFormat() {
        return "KML";
    }

    public String getFormat() {
        return "text/xml; subtype=kml/2.1";
    }

    public void initialize() {
        super.initialize();
        try {
            this.writer.setDefaultNamespace("http://earth.google.com/kml/2.1");
            this.writer.writeStartElement(Kml2_1_Tags.ROOT);
            this.writer.writeStartAttribute("http://www.w3.org/2000/xmlns/", "xmlns");
            this.writer.writeValue("http://earth.google.com/kml/2.1");
            this.writer.writeEndAttributes();
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void close() {
        try {
            this.writer.writeEndElement();
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void startLayer(String id, String namespace, String name, String description, String srs) {
        try {
            if (this.layerLevel == 0) {
                this.getProfile().getDocumentWriter().start(this.writer, this, id, name, description);
            } else {
                this.getProfile().getFolderWriter().start(this.writer, this, id, name, description);
            }
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
        ++this.layerLevel;
    }

    public void endLayer() {
        --this.layerLevel;
        try {
            if (this.layerLevel == 0) {
                this.getProfile().getDocumentWriter().end(this.writer, this);
            } else {
                this.getProfile().getFolderWriter().end(this.writer, this);
            }
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void startFeature(String id, String namespace, String name) {
        try {
            this.metadataElements = new ArrayList();
            this.currentMetadataElement = null;
            this.getProfile().getPlaceMarkWriter().start(this.writer, this, id, name);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void endFeature() {
        try {
            this.getProfile().getMetadataWriter().start(this.writer, this);
            for (int i = 0; i < this.metadataElements.size(); ++i) {
                this.writeMetadatadElement((MetadataElement)this.metadataElements.get(i));
            }
            this.getProfile().getMetadataWriter().end(this.writer, this);
            this.getProfile().getPlaceMarkWriter().end(this.writer, this);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    private void writeMetadatadElement(MetadataElement metadataElement) throws IOException {
        this.getProfile().getElementWriter().start(this.writer, this, metadataElement);
        for (int i = 0; i < metadataElement.getElementsSize(); ++i) {
            this.writeMetadatadElement(metadataElement.getElementAt(i));
        }
        this.getProfile().getElementWriter().end(this.writer, this);
    }

    public void startElement(String namespace, String name, Object value) {
        if (this.currentMetadataElement == null) {
            this.currentMetadataElement = new MetadataElement(namespace, name, value);
            this.metadataElements.add(this.currentMetadataElement);
        } else {
            this.currentMetadataElement = this.currentMetadataElement.addChildElement(namespace, name, value);
        }
    }

    public void endElement() {
        this.currentMetadataElement = this.currentMetadataElement.getParentElement();
    }

    public void startPoint(String id, ICoordinateSequence coords, String srs) {
        try {
            this.getProfile().getPointTypeWriter().start(this.writer, this, id, coords);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void endPoint() {
        try {
            this.getProfile().getPointTypeWriter().end(this.writer, this);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void startLineString(String id, ICoordinateSequence coords, String srs) {
        try {
            this.getProfile().getLineStringTypeWriter().start(this.writer, this, id, coords);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void endLineString() {
        try {
            this.getProfile().getLineStringTypeWriter().end(this.writer, this);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void startLinearRing(String id, ICoordinateSequence coords, String srs) {
        try {
            this.getProfile().getLinearRingWriter().start(this.writer, this, coords);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void endLinearRing() {
        try {
            this.getProfile().getLinearRingWriter().end(this.writer, this);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void startPolygon(String id, ICoordinateSequence coords, String srs) {
        try {
            this.getProfile().getPolygonTypeWriter().start(this.writer, this, id, coords);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void endPolygon() {
        try {
            this.getProfile().getPolygonTypeWriter().end(this.writer, this);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void startInnerBoundary(String id, ICoordinateSequence coords, String srs) {
        try {
            this.getProfile().getInnerBoundaryIsWriter().start(this.writer, this, coords);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void endInnerBoundary() {
        try {
            this.getProfile().getInnerBoundaryIsWriter().end(this.writer, this);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void startBbox(String id, ICoordinateSequence coords, String srs) {
        try {
            this.getProfile().getRegionWriter().start(this.writer, this, coords);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void endBbox() {
        try {
            this.getProfile().getRegionWriter().end(this.writer, this);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void startMultiGeometry(String id, String srs) {
        try {
            this.getProfile().getMultiGeometryWriter().start(this.writer, this, id);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void endMultiGeometry() {
        try {
            this.getProfile().getMultiGeometryWriter().end(this.writer, this);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void startMultiPoint(String id, String srs) {
        this.startMultiGeometry(id, srs);
    }

    public void endMultiPoint() {
        super.endMultiPoint();
        this.endMultiGeometry();
    }

    public void startMultiLineString(String id, String srs) {
        this.startMultiGeometry(id, srs);
    }

    public void endMultiLineString() {
        this.endMultiGeometry();
    }

    public void startMultiPolygon(String id, String srs) {
        this.startMultiGeometry(id, srs);
    }

    public void endMultiPolygon() {
        this.endMultiGeometry();
    }

    public IWriterProfile getProfile() {
        return this.profile;
    }

    public void setProfile(IWriterProfile profile) {
        this.profile = profile;
    }

    public String getFileExtension() {
        return "kml";
    }
}

