/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.svgsupport;

import com.openhtmltopdf.svgsupport.OpenHtmlGvtFont;
import java.awt.FontFormatException;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTFontFace;
import org.apache.batik.gvt.font.GVTFontFamily;

public class OpenHtmlGvtFontFamily
implements GVTFontFamily {
    private final Map<FontDescriptor, FontEntry> fonts = new HashMap<FontDescriptor, FontEntry>(1);
    private final String fontFamily;

    public OpenHtmlGvtFontFamily(String family) {
        this.fontFamily = family;
    }

    public void addFont(File file, float size, Float fontWeight, Float fontStyle) throws IOException, FontFormatException {
        FontDescriptor des = new FontDescriptor();
        des.style = fontStyle;
        des.weight = fontWeight;
        FontEntry entry = new FontEntry();
        entry.size = size;
        entry.font = new OpenHtmlGvtFont(file, (GVTFontFamily)this, size, fontWeight, fontStyle);
        this.fonts.put(des, entry);
    }

    public void addFont(byte[] bytes, float size, Float fontWeight, Float fontStyle) throws FontFormatException {
        FontDescriptor des = new FontDescriptor();
        des.style = fontStyle;
        des.weight = fontWeight;
        FontEntry entry = new FontEntry();
        entry.size = size;
        entry.font = new OpenHtmlGvtFont(bytes, (GVTFontFamily)this, size, fontWeight, fontStyle);
        this.fonts.put(des, entry);
    }

    public GVTFont deriveFont(float sz, AttributedCharacterIterator arg1) {
        return this.deriveFont(sz, arg1.getAttributes());
    }

    public GVTFont deriveFont(float size, Map attrs) {
        Float fontWeight = (Float)attrs.get(TextAttribute.WEIGHT);
        Float fontStyle = (Float)attrs.get(TextAttribute.POSTURE);
        FontDescriptor des = new FontDescriptor();
        des.weight = fontWeight;
        des.style = fontStyle;
        FontEntry fnt = this.fonts.get(des);
        if (fnt != null) {
            if (fnt.size == size) {
                return fnt.font;
            }
            return fnt.font.deriveFont(size);
        }
        return this.fonts.values().iterator().next().font.deriveFont(size);
    }

    public String getFamilyName() {
        return this.fontFamily;
    }

    public GVTFontFace getFontFace() {
        return new GVTFontFace(this.fontFamily);
    }

    public boolean isComplex() {
        return false;
    }

    private static class FontEntry {
        GVTFont font;
        float size;

        private FontEntry() {
        }
    }

    private static class FontDescriptor {
        Float style;
        Float weight;

        private FontDescriptor() {
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass() == this.getClass() && Objects.equals(((FontDescriptor)obj).style, this.style) && Objects.equals(((FontDescriptor)obj).weight, this.weight);
        }

        public int hashCode() {
            return Objects.hash(this.style, this.weight);
        }
    }
}

