/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gdal.prov.gml;

import java.io.File;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Driver;
import org.gdal.ogr.ogr;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataStoreProvider;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.gdal.prov.gml.GMLDataExplorerParameters;
import org.gvsig.gdal.prov.gml.GMLDataStoreParameters;
import org.gvsig.gdal.prov.gml.GMLDataStoreProvider;
import org.gvsig.gdal.prov.ogr.BasicOGRDataStoreProviderFactory;
import org.gvsig.gdal.prov.ogr.OGRDataStoreProviderFactory;
import org.gvsig.tools.dynobject.DynObject;

public class GMLDataStoreProviderFactory
extends BasicOGRDataStoreProviderFactory
implements OGRDataStoreProviderFactory {
    private static final String DRIVER_NAME = "GML";

    public GMLDataStoreProviderFactory(String name, String description) {
        super(name, description);
    }

    public DataStoreProvider createProvider(DataParameters dataParameters, DataStoreProviderServices providerServices) throws InitializeException {
        return new GMLDataStoreProvider((DataStoreParameters)dataParameters, providerServices);
    }

    public DynObject createParameters() {
        return new GMLDataStoreParameters();
    }

    public DynObject createParameters(Object connectionObject) {
        if (this.canOpen(connectionObject)) {
            return new GMLDataStoreParameters();
        }
        return null;
    }

    public DynObject createDataExplorerParameters(Object connectionObject) {
        if (this.canOpen(connectionObject)) {
            return new GMLDataExplorerParameters();
        }
        return null;
    }

    private boolean canOpen(Object connectionObject) {
        if (connectionObject instanceof File) {
            Driver driver;
            DataSource dataSource;
            File file = (File)connectionObject;
            if (file.isFile() && file.exists() && (dataSource = (driver = ogr.GetDriverByName((String)this.getDriver())).Open(file.getAbsolutePath())) != null) {
                dataSource.delete();
                dataSource = null;
                return true;
            }
        } else if (connectionObject instanceof String) {
            String connectionString = (String)connectionObject;
            Driver driver = ogr.GetDriverByName((String)this.getDriver());
            DataSource dataSource = driver.Open(connectionString);
            if (dataSource != null) {
                dataSource.delete();
                dataSource = null;
                return true;
            }
        } else {
            throw new IllegalArgumentException("Connection object must be a file or a connection string");
        }
        return false;
    }

    public String getDriver() {
        return DRIVER_NAME;
    }
}

