/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andamiupdater;

import com.sardak.antform.AntForm;
import com.sardak.antform.AntMenu;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class Updater {
    private String[] args;

    public Updater(String[] args) {
        this.args = args;
    }

    public static void main(String[] args) throws Exception {
        Updater updater = new Updater(args);
        updater.copyFiles();
        updater.executeScripts();
        updater.removeAll();
        updater.launchApp(args);
    }

    private File getApplicationDirectory() {
        return new File("").getAbsoluteFile();
    }

    private File getPluginsDirectory() {
        return new File(this.getApplicationDirectory(), this.args[1]);
    }

    private void launchApp(String[] args) throws Exception {
        try {
            Class<?> launcher_class = Class.forName("org.gvsig.andami.Launcher");
            Object launcher = launcher_class.newInstance();
            Method main = launcher_class.getMethod("main", String[].class);
            main.invoke(launcher, new Object[]{args});
        }
        catch (ClassNotFoundException e) {
            Class<?> launcher_class = Class.forName("com.iver.andami.Launcher");
            Object launcher = launcher_class.newInstance();
            Method main = launcher_class.getMethod("main", String[].class);
            main.invoke(launcher, new Object[]{args});
        }
    }

    private void removeAll() {
        File updateDirectory = new File(this.getApplicationDirectory(), "update");
        if (updateDirectory.exists()) {
            this.deleteDir(updateDirectory);
        }
    }

    private boolean deleteDir(File folder) {
        if (folder == null) {
            return true;
        }
        try {
            if (folder.isDirectory()) {
                String[] children;
                for (String children1 : children = folder.list()) {
                    boolean success = this.deleteDir(new File(folder, children1));
                    if (success) continue;
                    return false;
                }
            }
            return folder.delete();
        }
        catch (Throwable th) {
            this.warning("Can't remove '" + folder.getAbsolutePath() + "'.", th);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScripts() {
        File updateFolder = new File(this.getApplicationDirectory(), "update");
        File antFilesScript = new File(updateFolder, "scripts.lst");
        if (antFilesScript.exists()) {
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(antFilesScript));
                while ((line = reader.readLine()) != null) {
                    File antFile = new File(line);
                    try {
                        this.executeAntFile(antFile);
                    }
                    catch (Throwable th) {
                        this.warning("Error running file '" + antFile.getAbsolutePath() + "'.", th);
                    }
                }
                this.closeQuietly(reader, antFilesScript);
            }
            catch (Throwable th) {
                try {
                    this.warning("Error running ant scripts.", th);
                    this.closeQuietly(reader, antFilesScript);
                }
                catch (Throwable throwable) {
                    this.closeQuietly(reader, antFilesScript);
                    throw throwable;
                }
            }
        }
    }

    private void copyFiles() throws IOException {
        String[] childrenDirs;
        File updateFolder = new File(this.getApplicationDirectory(), "update");
        File filesFolder = new File(updateFolder, "files");
        File pluginsDirectory = this.getPluginsDirectory();
        if (updateFolder.exists() && (childrenDirs = filesFolder.list()) != null) {
            for (String childrenDir : childrenDirs) {
                File sourceLocation = new File(filesFolder, childrenDir);
                File targetLocation = new File(pluginsDirectory, childrenDir);
                try {
                    this.deleteDir(targetLocation);
                    this.copyFilesAndFolders(sourceLocation, targetLocation);
                }
                catch (Throwable th) {
                    this.warning("Can't copy files to '" + targetLocation.getAbsolutePath() + "'.", th);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyFilesAndFolders(File source, File target) throws IOException {
        block9: {
            block8: {
                String[] children;
                if (!source.isDirectory()) break block8;
                if (!target.exists()) {
                    target.mkdir();
                }
                if ((children = source.list()) == null) break block9;
                for (String children1 : children) {
                    this.copyFilesAndFolders(new File(source, children1), new File(target, children1));
                }
                break block9;
            }
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                int len;
                in = new FileInputStream(source);
                out = new FileOutputStream(target);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
            catch (Throwable th) {
                this.warning("Can't copy '" + source + "' to '" + target + "'.", th);
            }
            finally {
                this.closeQuietly(in, source);
                this.closeQuietly(out, target);
            }
        }
        return true;
    }

    private void closeQuietly(Closeable closeable, File f) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException ex) {
            if (f == null) {
                this.warning("Can't close file '" + closeable.toString() + "'.", ex);
            }
            this.warning("Can't close file '" + f.getAbsolutePath() + "'.", ex);
        }
    }

    private void executeAntFile(File file) {
        Project p = new Project();
        p.setUserProperty("ant.file", file.getAbsolutePath());
        p.setUserProperty("gvsig_dir", this.getApplicationDirectory().getAbsolutePath());
        p.setUserProperty("extensions_dir", this.getPluginsDirectory().getAbsolutePath());
        p.init();
        p.setBaseDir(file.getParentFile());
        p.addTaskDefinition("antform", AntForm.class);
        p.addTaskDefinition("antmenu", AntMenu.class);
        p.init();
        ProjectHelper helper = ProjectHelper.getProjectHelper();
        p.addReference("ant.projectHelper", (Object)helper);
        helper.parse(p, (Object)file);
        p.executeTarget(p.getDefaultTarget());
    }

    private void warning(String message, Throwable th) {
        System.err.println(message);
        th.printStackTrace();
    }
}

