/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.gpe;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.CreateException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.RemoveException;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.CreateGeometryException;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.impl.AbstractFilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProviderServices;
import org.gvsig.fmap.dal.store.gpe.GPEStoreParameters;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.gpe.lib.api.GPELocator;
import org.gvsig.gpe.lib.api.GPEManager;

public class GPEFileSystemServerProvider
extends AbstractFilesystemServerExplorerProvider
implements FilesystemServerExplorerProvider,
ResourceConsumer {
    protected FilesystemServerExplorerProviderServices serverExplorer;
    private static final GPEManager GPE_MANAGER = GPELocator.getGPEManager();

    public boolean canCreate() {
        return false;
    }

    public int getMode() {
        return 3;
    }

    public boolean canCreate(NewDataStoreParameters parameters) {
        return false;
    }

    public void create(NewDataStoreParameters parameters, boolean overwrite) throws CreateException {
    }

    public NewDataStoreParameters getCreateParameters() throws DataException {
        GPEStoreParameters np = new GPEStoreParameters();
        Envelope env = null;
        try {
            env = GeometryLocator.getGeometryManager().createEnvelope(-180.0, -90.0, 180.0, 90.0, 0);
        }
        catch (Exception e) {
            throw new CreateGeometryException((Throwable)e);
        }
        np.setEnvelope(env);
        np.setDefaultFeatureType((FeatureType)this.serverExplorer.getServerExplorerProviderServices().createNewFeatureType());
        return np;
    }

    public void initialize(FilesystemServerExplorerProviderServices serverExplorer) {
        this.serverExplorer = serverExplorer;
    }

    public void remove(DataStoreParameters parameters) throws RemoveException {
    }

    public String getDataStoreProviderName() {
        return "GPE";
    }

    public String getDescription() {
        return "GPE file";
    }

    public boolean accept(File pathName) {
        if (StringUtils.endsWithIgnoreCase((CharSequence)pathName.getName(), (CharSequence)".gml")) {
            return false;
        }
        return GPE_MANAGER.accept(pathName.toURI());
    }

    public boolean closeResourceRequested(ResourceProvider resource) {
        return false;
    }

    public void resourceChanged(ResourceProvider resource) {
    }
}

