/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.gpe;

import java.io.File;
import org.apache.commons.lang3.BooleanUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.fmap.dal.feature.OpenFeatureStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.spi.AbstractDataStoreParameters;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.gpe.lib.api.GPELocator;
import org.gvsig.gpe.lib.api.GPEManager;
import org.gvsig.gpe.lib.api.exceptions.ParserCreationException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.locator.LocatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPEStoreParameters
extends AbstractDataStoreParameters
implements OpenFeatureStoreParameters,
FilesystemStoreParameters,
NewFeatureStoreParameters {
    public static final String PARAMETERS_DEFINITION_NAME = "GPEStoreParameters";
    private static final String FILE_PARAMETER_NAME = "File";
    private static final String CRS_PARAMETER_NAME = "CRS";
    private static final String ENVELOPE_PARAMETER_NAME = "Envelope";
    private static final String FEATURETYPE_PARAMETER_NAME = "FeatureType";
    private DelegatedDynObject parameters;
    private static Logger logger = LoggerFactory.getLogger(GPEStoreParameters.class);

    public GPEStoreParameters() {
        this(PARAMETERS_DEFINITION_NAME);
    }

    protected GPEStoreParameters(String parametersDefinitionName) {
        this(parametersDefinitionName, "GPE");
    }

    public GPEStoreParameters(String parametersDefinitionName, String name) {
        this.parameters = (DelegatedDynObject)FileHelper.newParameters((String)parametersDefinitionName);
        this.setDynValue("ProviderName", name);
    }

    public static void registerParametersDefinition() {
        DynStruct dynStruct = FileHelper.registerParametersDefinition((String)PARAMETERS_DEFINITION_NAME, GPEStoreParameters.class, (String)"GPEParameters.xml");
        dynStruct.addDynFieldObject(ENVELOPE_PARAMETER_NAME).setClassOfValue(Envelope.class).setMandatory(false);
        dynStruct.addDynFieldObject(FEATURETYPE_PARAMETER_NAME).setClassOfValue(FeatureType.class).setMandatory(false);
    }

    protected DelegatedDynObject getDelegatedDynObject() {
        return this.parameters;
    }

    public String getDataStoreName() {
        return "GPE";
    }

    public String getDescription() {
        return "GPE file";
    }

    public boolean isValid() {
        return this.getFile() != null;
    }

    public File getFile() {
        return (File)this.getDynValue(FILE_PARAMETER_NAME);
    }

    public void setFile(File file) {
        this.setDynValue(FILE_PARAMETER_NAME, file);
    }

    public String getFileName() {
        return this.getFile().getAbsolutePath();
    }

    public void setFileName(String fileName) {
        this.setDynValue(FILE_PARAMETER_NAME, fileName);
    }

    public IProjection getCRS() {
        return (IProjection)this.getDynValue(CRS_PARAMETER_NAME);
    }

    public void setCRS(IProjection srs) {
        this.setDynValue(CRS_PARAMETER_NAME, srs);
    }

    public void setCRS(String srs) {
        this.setDynValue(CRS_PARAMETER_NAME, srs);
    }

    public Envelope getEnvelope() {
        return (Envelope)this.getDynValue(ENVELOPE_PARAMETER_NAME);
    }

    public void setEnvelope(Envelope envelope) {
        this.setDynValue(ENVELOPE_PARAMETER_NAME, envelope);
    }

    public void setDynValue(String name, Object val) {
        super.setDynValue(name, val);
    }

    public boolean getUseAxisOrderYX() {
        boolean x = BooleanUtils.isTrue((Boolean)((Boolean)this.getDynValue("useAxisOrderYX")));
        return x;
    }

    public EditableFeatureType getDefaultFeatureType() {
        return (EditableFeatureType)this.getDynValue(FEATURETYPE_PARAMETER_NAME);
    }

    public void setDefaultFeatureType(FeatureType featureType) {
        this.setDynValue(FEATURETYPE_PARAMETER_NAME, featureType);
    }

    public Object getDynValue(String name) throws DynFieldNotFoundException {
        if (CRS_PARAMETER_NAME.equalsIgnoreCase(name)) {
            try {
                GPEManager gpeManager = GPELocator.getGPEManager();
                String crs = gpeManager.getDefaultProjection(this.getFile());
                DataTypesManager dataTypesManager = ToolsLocator.getDataTypesManager();
                IProjection projection = (IProjection)dataTypesManager.coerce(65, (Object)crs);
                if (projection != null) {
                    this.setCRS(projection);
                }
            }
            catch (ParserCreationException | CoercionException | LocatorException e) {
                logger.warn("Couldn't get default projection", e);
            }
        }
        return super.getDynValue(name);
    }
}

