/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.gpe.model;

import java.util.LinkedHashMap;
import org.gvsig.fmap.dal.store.gpe.model.GPEElement;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPEFeature {
    private static final GeometryManager GEOMETRY_MANAGER = GeometryLocator.getGeometryManager();
    private static final Logger LOG = LoggerFactory.getLogger(GPEFeature.class);
    private static int idFeature = 0;
    private Geometry geometry = null;
    private LinkedHashMap elements = new LinkedHashMap();
    private String id = null;
    private String name = null;
    private String typeName = null;

    public GPEFeature(String id, String name, String typeName) {
        this();
        this.id = id;
        this.name = name;
        this.typeName = typeName;
    }

    public GPEFeature() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Geometry getGeometry() {
        if (this.geometry == null) {
            try {
                this.geometry = GEOMETRY_MANAGER.create(16, 1);
            }
            catch (CreateGeometryException e) {
                LOG.error("Not possible to create a geometry", (Throwable)e);
            }
        }
        return this.geometry;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    public LinkedHashMap getelements() {
        return this.elements;
    }

    public void setElements(LinkedHashMap elements) {
        this.elements = elements;
    }

    public void addElement(GPEElement element) {
        this.elements.put(element.getName(), element);
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public static void initIdFeature() {
        idFeature = 0;
    }

    public Envelope getEnvelope() {
        if (this.geometry == null) {
            return null;
        }
        return this.geometry.getEnvelope();
    }
}

