/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.jexcel;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.jexcel.Spread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JExcelSpread
implements Spread {
    private static final Logger LOGGER = LoggerFactory.getLogger(JExcelSpread.class);
    private File spreadFile;

    @Override
    public void open(File spreadFile) {
        this.spreadFile = spreadFile;
    }

    @Override
    public File getFile() {
        return this.spreadFile;
    }

    @Override
    public Spread.Sheet getSheet(int sheetIndex) {
        try {
            if (this.spreadFile == null || sheetIndex < 0) {
                return null;
            }
            return new SheetJExcel(this.spreadFile, sheetIndex);
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public List<String> getSheetNames() {
        try {
            ArrayList<String> r = new ArrayList<String>();
            Workbook workbook = Workbook.getWorkbook((File)this.spreadFile);
            r.addAll(Arrays.asList(workbook.getSheetNames()));
            return r;
        }
        catch (Exception ex) {
            return Collections.EMPTY_LIST;
        }
    }

    private static class SheetJExcel
    implements Spread.Sheet {
        private final Workbook workbook;
        private final File spreadFile;
        private final int sheetIndex;
        private final Sheet sheetExcel;

        public SheetJExcel(File spreadFile, int sheetIndex) throws IOException {
            try {
                this.spreadFile = spreadFile;
                this.sheetIndex = sheetIndex;
                this.workbook = Workbook.getWorkbook((File)spreadFile);
                this.sheetExcel = this.workbook.getSheet(sheetIndex);
            }
            catch (Exception ex) {
                throw new IOException("Can't open sheet " + sheetIndex + " from '" + Objects.toString(spreadFile) + "'.", ex);
            }
        }

        @Override
        public int getColumnCount() {
            return this.sheetExcel.getColumns();
        }

        @Override
        public Rectangle getUsedRange() {
            return null;
        }

        @Override
        public List<String> getColumnNames(boolean isFirstLineHedaer) {
            int i;
            int columns = this.getColumnCount();
            ArrayList<String> columnNames = new ArrayList<String>(columns);
            String abc = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            if (columns > abc.length()) {
                for (i = 0; i < columns; ++i) {
                    columnNames.add("C" + i);
                }
            } else {
                for (i = 0; i < columns; ++i) {
                    columnNames.add(abc.substring(i, i + 1));
                }
            }
            if (isFirstLineHedaer) {
                for (int col = 0; col < columns; ++col) {
                    Object value = this.getValueAt(col, 0);
                    String s = Objects.toString(value);
                    if (StringUtils.isBlank((CharSequence)s)) continue;
                    columnNames.set(col, s);
                }
            }
            return columnNames;
        }

        @Override
        public File getFile() {
            return this.spreadFile;
        }

        @Override
        public String getName() {
            return this.sheetExcel.getName();
        }

        @Override
        public int getRowCount() {
            return this.sheetExcel.getRows();
        }

        @Override
        public int getSheetIndex() {
            return this.sheetIndex;
        }

        @Override
        public Object getValueAt(int col, int row) {
            Cell cell = this.sheetExcel.getCell(col, row);
            String value = cell.getContents();
            return value;
        }
    }
}

