/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.jexcel.dal.provider;

import java.io.File;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.CreateException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.FileNotFoundException;
import org.gvsig.fmap.dal.exception.RemoveException;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.impl.AbstractFilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProviderServices;
import org.gvsig.jexcel.dal.provider.JExcelStoreParameters;

public class JExcelFilesystemServerProvider
extends AbstractFilesystemServerExplorerProvider
implements FilesystemServerExplorerProvider,
ResourceConsumer {
    private FilesystemServerExplorerProviderServices serverExplorer;

    public String getDataStoreProviderName() {
        return "JExcel";
    }

    public int getMode() {
        return 3;
    }

    public boolean accept(File pathname) {
        return pathname.getName().toLowerCase().endsWith(".xls");
    }

    public String getDescription() {
        return "JExcel file";
    }

    public DataStoreParameters getParameters(File file) throws DataException {
        DataManager manager = DALLocator.getDataManager();
        JExcelStoreParameters params = (JExcelStoreParameters)manager.createStoreParameters(this.getDataStoreProviderName());
        params.setFile(file);
        return params;
    }

    public boolean canCreate() {
        return false;
    }

    public boolean canCreate(NewDataStoreParameters parameters) {
        throw new UnsupportedOperationException();
    }

    public void create(NewDataStoreParameters parameters, boolean overwrite) throws CreateException {
        throw new UnsupportedOperationException();
    }

    public NewDataStoreParameters getCreateParameters() throws DataException {
        throw new UnsupportedOperationException();
    }

    public void initialize(FilesystemServerExplorerProviderServices serverExplorer) {
        this.serverExplorer = serverExplorer;
    }

    public void remove(DataStoreParameters parameters) throws RemoveException {
        File file = ((JExcelStoreParameters)parameters).getFile();
        if (!file.exists()) {
            throw new RemoveException(this.getDataStoreProviderName(), (Throwable)new FileNotFoundException(file));
        }
        if (!file.delete()) {
            // empty if block
        }
    }

    public boolean closeResourceRequested(ResourceProvider resource) {
        return false;
    }

    public void resourceChanged(ResourceProvider resource) {
    }
}

