/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.jexcel.dal.provider;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.json.JsonObject;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureAttributeEmulator;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.PerformEditingException;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProviderServices;
import org.gvsig.fmap.dal.feature.spi.memory.AbstractMemoryStoreProvider;
import org.gvsig.fmap.dal.resource.Resource;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.jexcel.dal.provider.JExcelStoreParameters;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.exception.NotYetImplemented;
import org.gvsig.tools.logger.FilteredLogger;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatusManager;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JExcelStoreProvider
extends AbstractMemoryStoreProvider
implements ResourceConsumer {
    private static final Logger logger = LoggerFactory.getLogger(JExcelStoreProvider.class);
    public static final String NAME = "JExcel";
    public static final String DESCRIPTION = "JExcel file";
    public static final String METADATA_DEFINITION_NAME = "JExcel";
    private ResourceProvider resource;
    private long counterNewsOIDs = 0L;
    private Envelope envelope;
    private boolean need_calculate_envelope = false;
    private SimpleTaskStatus taskStatus;
    private String sheetName = "";

    public JExcelStoreProvider(JExcelStoreParameters parameters, DataStoreProviderServices storeServices) throws InitializeException {
        super((DataStoreParameters)parameters, storeServices, FileHelper.newMetadataContainer((String)"JExcel"));
        TaskStatusManager manager = ToolsLocator.getTaskStatusManager();
        this.taskStatus = manager.createDefaultSimpleTaskStatus("JExcel");
        this.counterNewsOIDs = 0L;
        File file = this.getJExcelParameters().getFile();
        this.resource = this.createResource("file", new Object[]{file.getAbsolutePath()});
        this.resource.addConsumer((ResourceConsumer)this);
        this.initializeFeatureTypes();
    }

    private JExcelStoreParameters getJExcelParameters() {
        return (JExcelStoreParameters)this.getParameters();
    }

    public String getProviderName() {
        return "JExcel";
    }

    public boolean allowWrite() {
        return false;
    }

    private String getFullFileName() {
        String s = "(unknow)";
        try {
            s = this.getJExcelParameters().getFile().getAbsolutePath();
        }
        catch (Exception e2) {
            s = "(unknow)";
        }
        return s;
    }

    public void open() throws OpenException {
        if (this.data != null) {
            return;
        }
        this.data = new ArrayList();
        this.resource.setData(new HashMap());
        this.counterNewsOIDs = 0L;
        try {
            this.loadFeatures();
        }
        catch (RuntimeException e) {
            logger.warn("Can't load features from JExcel '" + this.getFullFileName() + "'.", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.warn("Can't load features from JExcel '" + this.getFullFileName() + "'.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public DataServerExplorer getExplorer() throws ReadException {
        DataManager manager = DALLocator.getDataManager();
        try {
            FilesystemServerExplorerParameters params = (FilesystemServerExplorerParameters)manager.createServerExplorerParameters("FilesystemExplorer");
            params.setRoot(this.getJExcelParameters().getFile().getParent());
            return manager.openServerExplorer("FilesystemExplorer", (DataServerExplorerParameters)params);
        }
        catch (DataException e) {
            throw new ReadException(this.getProviderName(), (Throwable)e);
        }
        catch (ValidateDataParametersException e) {
            throw new ReadException(this.getProviderName(), (Throwable)e);
        }
    }

    public void performChanges(Iterator deleteds, Iterator inserteds, Iterator updateds, Iterator originalFeatureTypesUpdated) throws PerformEditingException {
        throw new UnsupportedOperationException();
    }

    public boolean closeResourceRequested(ResourceProvider resource) {
        return true;
    }

    public int getOIDType() {
        return 5;
    }

    public boolean supportsAppendMode() {
        return false;
    }

    public void append(FeatureProvider featureProvider) {
        throw new UnsupportedOperationException();
    }

    public void beginAppend() {
        throw new UnsupportedOperationException();
    }

    public void endAppend() {
        throw new UnsupportedOperationException();
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        throw new NotYetImplemented();
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        throw new NotYetImplemented();
    }

    public Object createNewOID() {
        return new Long(this.counterNewsOIDs++);
    }

    protected void initializeFeatureTypes() throws InitializeException {
        try {
            this.open();
        }
        catch (OpenException e) {
            throw new InitializeException(this.getProviderName(), (Throwable)e);
        }
    }

    public Envelope getEnvelope() throws DataException {
        this.open();
        if (this.envelope != null) {
            return this.envelope;
        }
        if (!this.need_calculate_envelope) {
            return null;
        }
        FeatureStore fs = this.getFeatureStore();
        FeatureType ft = fs.getDefaultFeatureType();
        FeatureAttributeDescriptor fad = ft.getAttributeDescriptor(ft.getDefaultGeometryAttributeIndex());
        try {
            this.envelope = GeometryLocator.getGeometryManager().createEnvelope(fad.getGeomType().getSubType());
            fs.accept(new Visitor(){

                public void visit(Object obj) throws VisitCanceledException, BaseException {
                    Feature f = (Feature)obj;
                    Geometry geom = f.getDefaultGeometry();
                    if (geom != null) {
                        JExcelStoreProvider.this.envelope.add(geom.getEnvelope());
                    }
                }
            });
        }
        catch (BaseException e) {
            logger.warn("Can't calculate the envelope of JExcel file '" + this.getFullName() + "'.", (Throwable)e);
            this.envelope = null;
        }
        this.need_calculate_envelope = false;
        return this.envelope;
    }

    public Object getDynValue(String name) throws DynFieldNotFoundException {
        IProjection pro;
        if ("Envelope".equalsIgnoreCase(name)) {
            try {
                return this.getEnvelope();
            }
            catch (DataException e) {
                return null;
            }
        }
        if ("CRS".equalsIgnoreCase(name) && (pro = JExcelStoreParameters.getCRS((DynObject)this.getJExcelParameters())) != null) {
            return pro;
        }
        return super.getDynValue(name);
    }

    public void resourceChanged(ResourceProvider resource) {
        this.getStoreServices().notifyChange("resourceChange_DataStore", (Resource)resource);
    }

    public Object getSourceId() {
        return this.getJExcelParameters().getFile();
    }

    public String getName() {
        String name = this.getJExcelParameters().getFile().getName();
        if (StringUtils.isBlank((CharSequence)this.sheetName)) {
            return FilenameUtils.getBaseName((String)name);
        }
        return FilenameUtils.getBaseName((String)name) + "." + this.sheetName;
    }

    public String getFullName() {
        return this.getJExcelParameters().getFile().getAbsolutePath();
    }

    public ResourceProvider getResource() {
        return this.resource;
    }

    private EditableFeatureType getFeatureType(String[] headers, int[] automaticTypes) {
        int i;
        int[] param_sizes;
        int i2;
        EditableFeatureType fType = this.getStoreServices().createFeatureType(this.getName());
        fType.setHasOID(true);
        DataTypesManager dataTypesManager = ToolsLocator.getDataTypesManager();
        FieldTypeParser[] fieldTypes = new FieldTypeParser[headers.length];
        for (i2 = 0; i2 < fieldTypes.length; ++i2) {
            fieldTypes[i2] = new FieldTypeParser();
        }
        if (automaticTypes != null) {
            for (i2 = 0; i2 < fieldTypes.length && i2 < automaticTypes.length; ++i2) {
                fieldTypes[i2].type = automaticTypes[i2];
            }
        }
        for (i2 = 0; i2 < fieldTypes.length; ++i2) {
            if (fieldTypes[i2].parse(headers[i2])) continue;
        }
        int[] param_types = JExcelStoreParameters.getFieldTypes((DynObject)this.getParameters());
        if (param_types != null) {
            for (int i3 = 0; i3 < fieldTypes.length && i3 < param_types.length; ++i3) {
                fieldTypes[i3].type = param_types[i3];
            }
        }
        if ((param_sizes = JExcelStoreParameters.getFieldSizes((DynObject)this.getParameters())) != null) {
            for (i = 0; i < param_sizes.length; ++i) {
                if (param_sizes[i] <= 0) continue;
                fieldTypes[i].size = param_sizes[i];
            }
        }
        for (i = 0; i < fieldTypes.length; ++i) {
            EditableFeatureAttributeDescriptor fad = fType.add(fieldTypes[i].name, fieldTypes[i].type);
            fad.setSize(fieldTypes[i].size);
            fad.setAllowNull(fieldTypes[i].allowNulls);
            if (fieldTypes[i].type != 66 || fType.getDefaultGeometryAttributeName() != null) continue;
            fType.setDefaultGeometryAttributeName(fieldTypes[i].name);
        }
        String[] pointDimensionNames = JExcelStoreParameters.getPointDimensionNames((DynObject)this.getParameters());
        if (pointDimensionNames != null) {
            PointAttributeEmulator emulator = new PointAttributeEmulator(pointDimensionNames);
            EditableFeatureAttributeDescriptor attr = fType.add("GEOM", 66, (FeatureAttributeEmulator)emulator);
            GeometryManager geommgr = GeometryLocator.getGeometryManager();
            try {
                GeometryType gt = emulator.fieldNames != null && emulator.fieldNames.length <= 2 ? geommgr.getGeometryType(0, 0) : geommgr.getGeometryType(0, 1);
                attr.setGeometryType(gt);
            }
            catch (Exception e) {
                logger.warn("Can't set geometry type for the calculated field in JExcel file '" + this.getFullFileName() + "'.", (Throwable)e);
            }
        }
        return fType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFeatures() throws IOException, DataException, CoercionException, CloneNotSupportedException {
        JExcelReader reader = null;
        try {
            String[] headers = null;
            FeatureStoreProviderServices store = this.getStoreServices();
            boolean ignore_errors = JExcelStoreParameters.getIgnoreErrors((DynObject)this.getJExcelParameters());
            reader = new JExcelReader(this.getJExcelParameters());
            this.sheetName = reader.getSheetName();
            headers = JExcelStoreParameters.getHeaders((DynObject)this.getJExcelParameters());
            if (headers == null) {
                headers = reader.getHeader();
            }
            EditableFeatureType edftype = this.getFeatureType(headers, this.automaticDetectionOfTypes());
            FeatureType ftype = edftype.getNotEditableCopy();
            ArrayList<FeatureType> ftypes = new ArrayList<FeatureType>();
            ftypes.add(ftype);
            store.setFeatureTypes(ftypes, ftype);
            Coercion[] coercion = new Coercion[ftype.size()];
            int[] sizes = new int[ftype.size()];
            for (int i = 0; i < ftype.size(); ++i) {
                sizes[i] = -1;
                FeatureAttributeDescriptor ad = ftype.getAttributeDescriptor(i);
                coercion[i] = ad.getDataType().getCoercion();
                if (ad.getDataType().getType() != 8 || ad.getSize() != 0) continue;
                sizes[i] = 0;
            }
            if (ftype.getDefaultGeometryAttributeName() != null) {
                this.need_calculate_envelope = true;
            }
            Locale locale = JExcelStoreParameters.getLocale((DynObject)this.getJExcelParameters());
            this.taskStatus.message("_loading");
            int count = 0;
            int count_errors = 0;
            String[] row = reader.read();
            String rawvalue = null;
            while (row != null) {
                this.taskStatus.setCurValue((long)(++count));
                FeatureProvider feature = this.createFeatureProvider(ftype);
                for (int i = 0; i < row.length; ++i) {
                    rawvalue = row[i];
                    if (rawvalue instanceof String && StringUtils.isBlank((CharSequence)rawvalue)) {
                        rawvalue = null;
                    }
                    try {
                        int x;
                        Object value = null;
                        value = coercion[i].coerce((Object)rawvalue);
                        feature.set(i, value);
                        if (sizes[i] < 0 || value == null || sizes[i] >= (x = ((String)value).length())) continue;
                        sizes[i] = x;
                        continue;
                    }
                    catch (RuntimeException ex) {
                        if (!ignore_errors) {
                            throw ex;
                        }
                        if (count_errors++ < 10) {
                            logger.warn("Can't load value of attribute " + i + " in row " + count + ".", (Throwable)ex);
                        }
                        if (count_errors != 10) continue;
                        logger.info("Too many errors, suppress messages.");
                    }
                }
                this.addFeatureProvider(feature);
                row = reader.read();
            }
            for (int i = 0; i < ftype.size(); ++i) {
                if (sizes[i] <= 0) continue;
                EditableFeatureAttributeDescriptor efad = (EditableFeatureAttributeDescriptor)edftype.getAttributeDescriptor(i);
                efad.setSize(sizes[i]);
            }
            ftype = edftype.getNotEditableCopy();
            ftypes = new ArrayList();
            ftypes.add(ftype);
            store.setFeatureTypes(ftypes, ftype);
            this.taskStatus.terminate();
        }
        catch (Exception ex) {
            logger.warn("Can't load features from excel file '" + this.getFullFileName() + "'.", (Throwable)ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
                reader = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] automaticDetectionOfTypes() throws IOException {
        boolean automatic_types_detection = JExcelStoreParameters.getAutomaticTypesDetection((DynObject)this.getJExcelParameters());
        if (!automatic_types_detection) {
            return null;
        }
        boolean T_INT = false;
        boolean T_FLOAT = true;
        int T_DOUBLE = 2;
        int T_LONG = 3;
        int T_URL = 4;
        int T_DATE = 5;
        boolean[][] possibleDataTypes = null;
        Locale locale = null;
        JExcelReader reader = null;
        int[] types = null;
        String[] headers = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        try {
            reader = new JExcelReader(this.getJExcelParameters());
            headers = reader.getHeader();
            if (headers == null) {
                headers = JExcelStoreParameters.getHeaders((DynObject)this.getJExcelParameters());
            }
            types = new int[headers.length];
            possibleDataTypes = new boolean[headers.length][6];
            for (int i = 0; i < possibleDataTypes.length; ++i) {
                for (int j = 0; j < 4; ++j) {
                    possibleDataTypes[i][j] = true;
                }
            }
            locale = JExcelStoreParameters.getLocale((DynObject)this.getJExcelParameters());
            if (locale == null) {
                locale = Locale.getDefault();
            }
            Coercion[] coercion = new Coercion[6];
            DataTypesManager typeManager = ToolsLocator.getDataTypesManager();
            coercion[2] = typeManager.getCoercion(7);
            coercion[1] = typeManager.getCoercion(6);
            coercion[0] = typeManager.getCoercion(4);
            coercion[3] = typeManager.getCoercion(5);
            coercion[5] = typeManager.getCoercion(9);
            coercion[4] = typeManager.getCoercion(16);
            String[] row = reader.read();
            while (row != null) {
                for (int i = 0; i < row.length; ++i) {
                    String rawvalue = row[i];
                    if (rawvalue instanceof String && StringUtils.isBlank((CharSequence)rawvalue)) {
                        rawvalue = null;
                    }
                    Object value = null;
                    if (possibleDataTypes[i][2]) {
                        try {
                            value = coercion[2].coerce((Object)rawvalue);
                            possibleDataTypes[i][2] = true;
                        }
                        catch (Exception ex) {
                            possibleDataTypes[i][2] = false;
                        }
                    }
                    if (possibleDataTypes[i][1]) {
                        try {
                            value = coercion[1].coerce((Object)rawvalue);
                            possibleDataTypes[i][1] = true;
                        }
                        catch (Exception ex) {
                            possibleDataTypes[i][1] = false;
                        }
                    }
                    if (possibleDataTypes[i][3]) {
                        try {
                            value = coercion[3].coerce((Object)rawvalue);
                            possibleDataTypes[i][3] = true;
                        }
                        catch (Exception ex) {
                            possibleDataTypes[i][3] = false;
                        }
                    }
                    if (possibleDataTypes[i][0]) {
                        try {
                            value = coercion[0].coerce((Object)rawvalue);
                            possibleDataTypes[i][0] = true;
                        }
                        catch (Exception ex) {
                            possibleDataTypes[i][0] = false;
                        }
                    }
                    if (possibleDataTypes[i][5]) {
                        try {
                            value = coercion[5].coerce((Object)rawvalue);
                            possibleDataTypes[i][5] = true;
                        }
                        catch (Exception ex) {
                            possibleDataTypes[i][5] = false;
                        }
                    }
                    if (!possibleDataTypes[i][4]) continue;
                    try {
                        value = coercion[4].coerce((Object)rawvalue);
                        possibleDataTypes[i][4] = true;
                        continue;
                    }
                    catch (Exception ex) {
                        possibleDataTypes[i][4] = false;
                    }
                }
                row = reader.read();
            }
        }
        catch (Exception ex) {
            logger.warn("Can't detect automatic values.", (Throwable)ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception ex) {}
                reader = null;
            }
        }
        if (types != null && possibleDataTypes != null) {
            for (int i = 0; i < possibleDataTypes.length; ++i) {
                types[i] = possibleDataTypes[i][0] ? 4 : (possibleDataTypes[i][3] ? 5 : (possibleDataTypes[i][1] ? 6 : (possibleDataTypes[i][2] ? 7 : (possibleDataTypes[i][4] ? 16 : (possibleDataTypes[i][5] ? 9 : 8)))));
            }
        }
        return types;
    }

    static class JExcelReader {
        Workbook workbook = null;
        Sheet sheet = null;
        boolean isFirstLineHeader = false;
        int currentRow = 0;
        String[] row = null;
        private int sheetIndex;

        public JExcelReader(JExcelStoreParameters params) throws IOException, BiffException {
            this.sheetIndex = JExcelStoreParameters.getSheetIndex((DynObject)params);
            WorkbookSettings wSettings = new WorkbookSettings();
            wSettings.setLocale(JExcelStoreParameters.getLocale((DynObject)params));
            wSettings.setEncoding(JExcelStoreParameters.getEncoding((DynObject)params));
            this.workbook = Workbook.getWorkbook((File)params.getFile(), (WorkbookSettings)wSettings);
            this.sheet = this.workbook.getSheet(this.sheetIndex);
            this.row = new String[this.sheet.getColumns()];
            this.isFirstLineHeader = JExcelStoreParameters.isFirstRowHeader((DynObject)params);
            if (this.isFirstLineHeader) {
                ++this.currentRow;
            }
        }

        public JExcelReader(File f, int sheet, boolean isFirstLineHedaer) throws IOException, BiffException {
            this.sheetIndex = sheet;
            this.workbook = Workbook.getWorkbook((File)f);
            this.sheet = this.workbook.getSheet(sheet);
            this.row = new String[this.sheet.getColumns()];
            this.isFirstLineHeader = isFirstLineHedaer;
            if (this.isFirstLineHeader) {
                ++this.currentRow;
            }
        }

        public String[] getHeader() {
            int i;
            int columns = this.sheet.getColumns();
            String[] header = new String[columns];
            String abc = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            if (columns > abc.length()) {
                for (i = 0; i < columns; ++i) {
                    header[i] = "C" + i;
                }
            } else {
                for (i = 0; i < columns; ++i) {
                    header[i] = abc.substring(i, i + 1);
                }
            }
            if (this.isFirstLineHeader) {
                for (int col = 0; col < columns; ++col) {
                    Cell cell = this.sheet.getCell(col, 0);
                    String s = cell.getContents().trim();
                    if (StringUtils.isBlank((CharSequence)s)) continue;
                    header[col] = s;
                }
            }
            return header;
        }

        public String[] read() {
            if (this.currentRow >= this.sheet.getRows()) {
                return null;
            }
            int columns = this.sheet.getColumns();
            for (int col = 0; col < columns; ++col) {
                Cell cell = this.sheet.getCell(col, this.currentRow);
                this.row[col] = cell.getContents();
            }
            ++this.currentRow;
            return this.row;
        }

        public void close() {
            this.workbook.close();
        }

        public String getSheetName() {
            String[] names = this.workbook.getSheetNames();
            return names[this.sheetIndex];
        }
    }

    static class PointAttributeEmulator
    implements FeatureAttributeEmulator {
        private static final Logger LOGGER = LoggerFactory.getLogger(PointAttributeEmulator.class);
        private static final int XNAME = 0;
        private static final int YNAME = 1;
        private static final int ZNAME = 2;
        private final GeometryManager geommgr = GeometryLocator.getGeometryManager();
        private final Coercion toDouble;
        private final DataType dataType;
        private FilteredLogger logger;
        private String[] fieldNames;

        public PointAttributeEmulator() {
            DataTypesManager datatypeManager = ToolsLocator.getDataTypesManager();
            this.toDouble = datatypeManager.getCoercion(7);
            this.dataType = datatypeManager.get(66);
        }

        public PointAttributeEmulator(String[] pointDimensionNames) {
            this();
            if (pointDimensionNames.length > 2) {
                this.fieldNames = new String[3];
                this.fieldNames[2] = pointDimensionNames[2];
            } else {
                this.fieldNames = new String[2];
            }
            this.fieldNames[0] = pointDimensionNames[0];
            this.fieldNames[1] = pointDimensionNames[1];
        }

        private FilteredLogger getLogger() {
            if (this.logger == null) {
                this.logger = new FilteredLogger(LOGGER, "JExcelPointAttributeEmulator", 10);
                this.logger.setInterval(60000L);
            }
            return this.logger;
        }

        public Object get(Feature feature) {
            try {
                Point point;
                Object valueX = feature.get(this.fieldNames[0]);
                valueX = this.toDouble.coerce(valueX);
                if (valueX == null) {
                    return null;
                }
                Object valueY = feature.get(this.fieldNames[1]);
                if ((valueY = this.toDouble.coerce(valueY)) == null) {
                    return null;
                }
                Object valueZ = null;
                if (this.fieldNames.length > 2 && (valueZ = this.toDouble.coerce(feature.get(this.fieldNames[2]))) == null) {
                    return null;
                }
                double x = (Double)valueX;
                double y = (Double)valueY;
                if (this.fieldNames.length > 2) {
                    point = this.geommgr.createPoint(x, y, 1);
                    double z = (Double)valueZ;
                    point.setCoordinateAt(2, z);
                } else {
                    point = this.geommgr.createPoint(x, y, 0);
                }
                return point;
            }
            catch (Exception ex) {
                this.getLogger().warn("Can't create point in JExcel provider. XNAME='" + this.fieldNames[0] + "', YNAME='" + this.fieldNames[1] + "' feature=" + feature.toString(), (Throwable)ex);
                return null;
            }
        }

        public void set(EditableFeature feature, Object value) {
            if (value == null) {
                return;
            }
            Point point = value instanceof MultiPoint ? (Point)((MultiPoint)value).getPrimitiveAt(0) : (Point)value;
            feature.set(this.fieldNames[0], (Object)point.getX());
            feature.set(this.fieldNames[1], (Object)point.getY());
            if (this.fieldNames.length > 2) {
                feature.set(this.fieldNames[2], (Object)point.getCoordinateAt(2));
            }
        }

        public boolean allowSetting() {
            return true;
        }

        public String[] getRequiredFieldNames() {
            return this.fieldNames;
        }

        public void fromJson(JsonObject json) {
            this.fieldNames = (String[])Json.toArray((JsonObject)json, (String)"fieldNames", (Object[])new String[0]);
        }

        public JsonObject toJson() {
            return this.toJsonBuilder().build();
        }

        public JsonObjectBuilder toJsonBuilder() {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add("fieldNames", (Object[])this.fieldNames);
            return builder;
        }
    }

    private class FieldTypeParser {
        public String name = null;
        public int type = 8;
        public int size = 0;
        public boolean allowNulls = true;
        private String typename = "string";

        FieldTypeParser() {
        }

        private int getType(String value) {
            DataTypesManager dataTypesManager = ToolsLocator.getDataTypesManager();
            return dataTypesManager.getType(this.typename);
        }

        public boolean parse(String value) {
            String typename = null;
            String[] ss = null;
            if (value.contains(":")) {
                ss = value.split(":");
            } else if (value.contains("__")) {
                ss = value.split("__");
            }
            if (ss == null) {
                this.name = value;
                return true;
            }
            switch (ss.length) {
                case 4: {
                    if (ss[3].length() > 0) {
                        this.allowNulls = !"notnull".equalsIgnoreCase(ss[3]);
                    }
                }
                case 3: {
                    if (ss[2].length() > 0) {
                        try {
                            this.size = Integer.parseInt(ss[2]);
                        }
                        catch (Exception ex) {
                            logger.warn("Ignore incorrect field size for field " + value + " in JExcel header of '" + JExcelStoreProvider.this.getFullFileName() + "'.", (Throwable)ex);
                        }
                    }
                }
                case 2: {
                    if (ss[1].length() > 0) {
                        this.typename = ss[1];
                        this.type = this.getType(this.typename);
                        if (this.type == 0) {
                            this.type = 8;
                            logger.info("Type '" + typename + "' not valid for attribute '" + value + "' in JExcel file '" + JExcelStoreProvider.this.getFullFileName() + "'.");
                        }
                    }
                }
                case 1: {
                    this.name = ss[0];
                }
            }
            if (this.type != 8) {
                this.size = 0;
            }
            return true;
        }
    }
}

