/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.swing.impl.actions;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.json.JsonObject;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.report.AbstractReportAction;
import org.gvsig.fmap.dal.swing.report.ReportAction;
import org.gvsig.fmap.dal.swing.report.ReportActionFactory;
import org.gvsig.report.lib.api.Report;
import org.gvsig.report.lib.api.ReportConfig;
import org.gvsig.report.lib.api.ReportLocator;
import org.gvsig.report.lib.api.ReportManager;
import org.gvsig.report.swing.api.JReport;
import org.gvsig.report.swing.api.ReportSwingLocator;
import org.gvsig.report.swing.api.ReportSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JasperReportAction
extends AbstractReportAction
implements ReportAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(JasperReportAction.class);
    private final JsonObject json;
    private final FeatureSet selection;
    private final FeatureStore store;
    private final FeatureQuery query;

    public JasperReportAction(ReportActionFactory factory, FeatureStore store, FeatureQuery query, FeatureSet selection, JsonObject json) {
        super(factory, null);
        this.json = json;
        this.setReportName(this.json.getString("name", store.getName()));
        this.setReportLabel(this.json.getString("label", this.getReportName()));
        this.selection = selection;
        this.store = store;
        this.query = query;
    }

    public void actionPerformed(ActionEvent e) {
        ReportManager manager = ReportLocator.getReportManager();
        ReportConfig reportConfig = manager.createReportConfig();
        reportConfig.fromJSON(this.json);
        if (!reportConfig.hasDataSet()) {
            reportConfig.setDataSet(manager.createDataSet(this.store, this.query));
        }
        Report report = reportConfig.createReport();
        this.doShowReport(report);
    }

    private void doShowReport(Report report) {
        Expression filter;
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager winManager = ToolsSwingLocator.getWindowManager();
        ReportSwingManager swingManager = ReportSwingLocator.getReportSwingManager();
        FeatureQuery theQuery = this.query.getCopy();
        if (this.selection != null && !this.selection.isEmpty()) {
            filter = this.selection.makeFilter(100);
            if (filter == null) {
                filter = theQuery.getExpressionFilter();
            }
        } else {
            filter = theQuery.getExpressionFilter();
        }
        theQuery.retrievesAllAttributes();
        JReport reportPanel = swingManager.createJReport(report, filter);
        reportPanel.asJComponent().setPreferredSize(new Dimension(800, 500));
        winManager.showWindow(reportPanel.asJComponent(), ToolsSwingUtils.makeTitle((String)"_Report", (String)report.getName(), null), WindowManager.MODE.WINDOW);
    }
}

