/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.swing.impl.reportbuilder;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang.StringUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.expressionevaluator.FeatureStoreElement;
import org.gvsig.report.lib.api.ReportBuilder;
import org.gvsig.report.swing.impl.reportbuilder.DefaultJReportStyleBuilder;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.util.LabeledValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJReportColumnBuilderController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJReportColumnBuilderController.class);
    private final JTextField txtTitle;
    private final JTextField txtField;
    private final JComboBox cboClass;
    private final JTextField txtWidth;
    private final JCheckBox chkFixedWidth;
    private final JTextField txtPattern;
    private final JTextField txtTruncateSuffix;
    private final JTextField txtExpression;
    private final JButton btnTitleStyle;
    private final JButton btnFieldStyle;
    private final JButton btnExpressionHistory;
    private final JButton btnExpressionBookmarks;
    private final JButton btnExpression;
    private final JButton btnExpressionStyle;
    private FeatureStoreElement featureStoreElement;
    private ExpressionPickerController pickerFieldExpression;
    private ReportBuilder.ColumnBuilder columnBuilder;
    private final JRadioButton rdoField;
    private final JRadioButton rdoExpression;
    private final JButton btnColumnApply;
    private ReportBuilder.StyleBuilder styleTitle;
    private ReportBuilder.StyleBuilder styleField;
    private ReportBuilder.StyleBuilder styleExpression;
    private GroupByColumnController groupByController;
    private final JCheckBox chkGroupByField;
    private final JComboBox cboGroupByOperation;
    private final JTextField txtName;
    private boolean hasChanges;

    public DefaultJReportColumnBuilderController(JTextField txtColumnTitle, JButton btnColumnTitleStyle, JRadioButton rdoColumnField, JTextField txtColumnField, JButton btnColumnFieldStyle, JRadioButton rdoColumnExpression, JTextField txtColumnExpression, JButton btnColumnExpressionHistory, JButton btnColumnExpressionBookmarks, JButton btnColumnExpression, JButton btnColumnExpressionStyle, JComboBox cboClass, JTextField txtColumnWidth, JCheckBox chkColumnFixedWidth, JTextField txtColumnPattern, JTextField txtColumnTruncateSuffix, JButton btnColumnApply, JCheckBox chkGroupByField, JComboBox cboGroupByOperation, ExpressionPickerController pickerFieldExpression, JTextField txtColumnName) {
        this.txtTitle = txtColumnTitle;
        this.btnTitleStyle = btnColumnTitleStyle;
        this.rdoField = rdoColumnField;
        this.txtField = txtColumnField;
        this.btnFieldStyle = btnColumnFieldStyle;
        this.rdoExpression = rdoColumnExpression;
        this.txtExpression = txtColumnExpression;
        this.btnExpressionHistory = btnColumnExpressionHistory;
        this.btnExpressionBookmarks = btnColumnExpressionBookmarks;
        this.btnExpression = btnColumnExpression;
        this.btnExpressionStyle = btnColumnExpressionStyle;
        this.cboClass = cboClass;
        this.txtWidth = txtColumnWidth;
        this.chkFixedWidth = chkColumnFixedWidth;
        this.txtPattern = txtColumnPattern;
        this.txtTruncateSuffix = txtColumnTruncateSuffix;
        this.btnColumnApply = btnColumnApply;
        this.chkGroupByField = chkGroupByField;
        this.cboGroupByOperation = cboGroupByOperation;
        this.pickerFieldExpression = pickerFieldExpression;
        this.txtName = txtColumnName;
        this.hasChanges = false;
        this.initComponents();
    }

    public void fetch(ReportBuilder.ColumnBuilder columnBuilder) {
        columnBuilder.columnName(this.txtName.getText());
        columnBuilder.title(this.txtTitle.getText());
        columnBuilder.titleStyle().copyFrom(this.styleTitle);
        if (this.rdoField.isSelected()) {
            columnBuilder.field(this.txtField.getText());
            columnBuilder.fieldStyle().copyFrom(this.styleField);
        }
        if (this.rdoExpression.isSelected()) {
            columnBuilder.expression(this.pickerFieldExpression.get());
            columnBuilder.expressionStyle().copyFrom(this.styleExpression);
        }
        LabeledValueImpl value = (LabeledValueImpl)this.cboClass.getModel().getSelectedItem();
        DataType valueType = (DataType)value.getValue();
        columnBuilder.dataType(valueType);
        columnBuilder.width(Integer.parseInt(this.txtWidth.getText()));
        columnBuilder.fixedWidth(this.chkFixedWidth.isSelected());
        columnBuilder.pattern(this.txtPattern.getText());
        columnBuilder.truncateSuffix(this.txtTruncateSuffix.getText());
        this.groupByController.fetch(columnBuilder);
        this.hasChanges = false;
    }

    public void put(ReportBuilder.ColumnBuilder columnBuilder) {
        this.columnBuilder = columnBuilder;
        this.txtName.setText(columnBuilder.getColumnName());
        this.txtTitle.setText(columnBuilder.getTitle());
        this.styleTitle = columnBuilder.titleStyle();
        this.rdoField.setSelected(!StringUtils.isEmpty((String)columnBuilder.getField()));
        this.txtField.setText(columnBuilder.getField());
        this.styleField = columnBuilder.fieldStyle();
        Expression exp = columnBuilder.getExpression();
        if (exp == null) {
            this.rdoExpression.setSelected(false);
        } else {
            this.rdoExpression.setSelected(!exp.isPhraseEmpty());
        }
        this.pickerFieldExpression.set((Object)columnBuilder.getExpression());
        this.styleExpression = columnBuilder.expressionStyle();
        DataType inDataType = columnBuilder.getDataType();
        LabeledValueImpl valueDataType = new LabeledValueImpl(inDataType.getName(), (Object)inDataType);
        this.cboClass.getModel().setSelectedItem(valueDataType);
        this.txtWidth.setText(String.valueOf(columnBuilder.getWidth()));
        this.chkFixedWidth.setSelected(columnBuilder.getFixedWidth());
        this.txtPattern.setText(columnBuilder.getPattern());
        this.txtTruncateSuffix.setText(columnBuilder.getTruncateSuffix());
        this.groupByController.put(columnBuilder);
        this.hasChanges = false;
    }

    public void setEnabled(Boolean enabled) {
        this.txtName.setEnabled(enabled);
        this.txtTitle.setEnabled(enabled);
        this.btnTitleStyle.setEnabled(enabled);
        this.txtField.setEnabled(enabled);
        this.btnFieldStyle.setEnabled(enabled);
        this.pickerFieldExpression.setEnabled(enabled.booleanValue());
        this.cboClass.setEnabled(enabled);
        this.txtWidth.setEnabled(enabled);
        this.chkFixedWidth.setEnabled(enabled);
        this.txtPattern.setEnabled(enabled);
        this.txtTruncateSuffix.setEnabled(enabled);
        this.btnExpressionStyle.setEnabled(enabled);
        this.btnColumnApply.setEnabled(enabled);
        this.groupByController.setEnabled(enabled);
    }

    public void clean() {
        this.txtName.setText("");
        this.txtTitle.setText("");
        this.txtField.setText("");
        this.pickerFieldExpression.set(null);
        this.txtWidth.setText("");
        this.chkFixedWidth.setSelected(false);
        this.txtPattern.setText("");
        this.txtTruncateSuffix.setText("");
        this.groupByController.clean();
        this.hasChanges = false;
    }

    public boolean hasChanges() {
        return this.hasChanges;
    }

    public void setHasChanges(boolean changes) {
        this.hasChanges = changes;
    }

    private void initComponents() {
        DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
        DefaultComboBoxModel<LabeledValueImpl> colModel = new DefaultComboBoxModel<LabeledValueImpl>();
        DataTypesManager dataTypes = ToolsLocator.getDataTypesManager();
        for (DataType dataType : dataTypes) {
            LabeledValueImpl dtValue = new LabeledValueImpl(dataType.getName(), (Object)dataType);
            colModel.addElement(dtValue);
        }
        this.cboClass.setModel(colModel);
        this.btnTitleStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJReportColumnBuilderController.this.doSelectStyle(DefaultJReportColumnBuilderController.this.styleTitle);
            }
        });
        this.btnFieldStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJReportColumnBuilderController.this.doSelectStyle(DefaultJReportColumnBuilderController.this.styleField);
            }
        });
        this.btnExpressionStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJReportColumnBuilderController.this.doSelectStyle(DefaultJReportColumnBuilderController.this.styleExpression);
            }
        });
        this.groupByController = new GroupByColumnController(this.chkGroupByField, this.cboGroupByOperation);
        this.rdoExpression.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJReportColumnBuilderController.this.pickerFieldExpression.setEnabled(true);
                DefaultJReportColumnBuilderController.this.btnExpressionStyle.setEnabled(true);
                DefaultJReportColumnBuilderController.this.txtField.setEnabled(false);
                DefaultJReportColumnBuilderController.this.btnFieldStyle.setEnabled(false);
            }
        });
        this.rdoField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJReportColumnBuilderController.this.pickerFieldExpression.setEnabled(false);
                DefaultJReportColumnBuilderController.this.btnExpressionStyle.setEnabled(false);
                DefaultJReportColumnBuilderController.this.txtField.setEnabled(true);
                DefaultJReportColumnBuilderController.this.btnFieldStyle.setEnabled(true);
            }
        });
        this.pickerFieldExpression.setEnabled(false);
        this.btnExpressionStyle.setEnabled(false);
        this.txtField.setEnabled(true);
        this.btnFieldStyle.setEnabled(true);
        DocumentListener documentListenerChanged = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DefaultJReportColumnBuilderController.this.hasChanges = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DefaultJReportColumnBuilderController.this.hasChanges = true;
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DefaultJReportColumnBuilderController.this.hasChanges = true;
            }
        };
        this.txtTitle.getDocument().addDocumentListener(documentListenerChanged);
        this.btnTitleStyle.addActionListener(e -> {
            this.hasChanges = true;
        });
        this.rdoField.addActionListener(e -> {
            this.hasChanges = true;
        });
        this.txtField.getDocument().addDocumentListener(documentListenerChanged);
        this.btnFieldStyle.addActionListener(e -> {
            this.hasChanges = true;
        });
        this.rdoExpression.addActionListener(e -> {
            this.hasChanges = true;
        });
        this.txtExpression.getDocument().addDocumentListener(documentListenerChanged);
        this.btnExpressionHistory.addActionListener(e -> {
            this.hasChanges = true;
        });
        this.btnExpressionBookmarks.addActionListener(e -> {
            this.hasChanges = true;
        });
        this.btnExpression.addActionListener(e -> {
            this.hasChanges = true;
        });
        this.btnExpressionStyle.addActionListener(e -> {
            this.hasChanges = true;
        });
        this.cboClass.addActionListener(e -> {
            this.hasChanges = true;
        });
        this.txtWidth.getDocument().addDocumentListener(documentListenerChanged);
        this.chkFixedWidth.addActionListener(e -> {
            this.hasChanges = true;
        });
        this.txtPattern.getDocument().addDocumentListener(documentListenerChanged);
        this.txtTruncateSuffix.getDocument().addDocumentListener(documentListenerChanged);
        this.btnColumnApply.addActionListener(e -> {
            this.hasChanges = true;
        });
        this.chkGroupByField.addActionListener(e -> {
            this.hasChanges = true;
        });
        this.cboGroupByOperation.addActionListener(e -> {
            this.hasChanges = true;
        });
        this.pickerFieldExpression.addChangeListener(e -> {
            this.hasChanges = true;
        });
        this.txtName.getDocument().addDocumentListener(documentListenerChanged);
    }

    private void doSelectStyle(ReportBuilder.StyleBuilder styleBuilder) {
        DefaultJReportStyleBuilder panel = new DefaultJReportStyleBuilder();
        panel.put(styleBuilder);
        WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        Dialog dialog = windowManager.createDialog(panel.asJComponent(), "Expression builder", null, 3);
        dialog.show(WindowManager.MODE.DIALOG);
        if (dialog.getAction() == 1) {
            panel.fetch(styleBuilder);
        }
    }

    private class GroupByColumnController {
        private final JComboBox cboGroupByMethod;
        private final JCheckBox chkGroupBy;

        private GroupByColumnController(JCheckBox chkGroupBy, JComboBox cboGroupByMethod) {
            this.chkGroupBy = chkGroupBy;
            this.cboGroupByMethod = cboGroupByMethod;
            this.init();
        }

        public void init() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            DefaultComboBoxModel<LabeledValueImpl> colModel = new DefaultComboBoxModel<LabeledValueImpl>();
            DataTypesManager dataTypes = ToolsLocator.getDataTypesManager();
            colModel.addElement(new LabeledValueImpl(i18n.getTranslation("_Average"), (Object)0));
            colModel.addElement(new LabeledValueImpl(i18n.getTranslation("_Count"), (Object)1));
            colModel.addElement(new LabeledValueImpl(i18n.getTranslation("_First"), (Object)2));
            colModel.addElement(new LabeledValueImpl(i18n.getTranslation("_Highest"), (Object)3));
            colModel.addElement(new LabeledValueImpl(i18n.getTranslation("_Lowest"), (Object)4));
            colModel.addElement(new LabeledValueImpl(i18n.getTranslation("_Nothing"), (Object)5));
            colModel.addElement(new LabeledValueImpl(i18n.getTranslation("_Standard_deviation"), (Object)6));
            colModel.addElement(new LabeledValueImpl(i18n.getTranslation("_Sum"), (Object)7));
            colModel.addElement(new LabeledValueImpl(i18n.getTranslation("_System"), (Object)8));
            colModel.addElement(new LabeledValueImpl(i18n.getTranslation("_Variance"), (Object)9));
            this.cboGroupByMethod.setModel(colModel);
        }

        public void fetch(ReportBuilder.ColumnBuilder columnBuilder) {
            Integer operationValue = (Integer)((LabeledValueImpl)this.cboGroupByMethod.getSelectedItem()).getValue();
            columnBuilder.groupByOperation(operationValue.intValue());
            columnBuilder.groupByField(this.chkGroupBy.isSelected());
        }

        public void put(ReportBuilder.ColumnBuilder columnBuilder) {
            this.chkGroupBy.setSelected(columnBuilder.showGroupByField());
            int operationValue = columnBuilder.getGroupByOperation();
            ComboBoxModel model = this.cboGroupByMethod.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                LabeledValueImpl object = (LabeledValueImpl)model.getElementAt(i);
                if (!((Integer)object.getValue()).equals(operationValue)) continue;
                this.cboGroupByMethod.setSelectedIndex(i);
                break;
            }
        }

        public void setEnabled(Boolean enabled) {
            this.chkGroupBy.setEnabled(enabled);
            this.cboGroupByMethod.setEnabled(enabled);
        }

        public void clean() {
            this.chkGroupBy.setSelected(false);
            this.cboGroupByMethod.setSelectedIndex(0);
        }
    }
}

