/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.swing.impl.reportserver.dataset;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.expressionevaluator.FeatureStoreElement;
import org.gvsig.propertypage.PropertiesPage;
import org.gvsig.report.lib.api.ReportDataSet;
import org.gvsig.report.lib.api.ReportServer;
import org.gvsig.report.lib.api.ReportServerConfig;
import org.gvsig.report.swing.api.JReportServer;
import org.gvsig.report.swing.impl.reportserver.dataset.DataSetView;
import org.gvsig.report.swing.impl.utils.Clipboard;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.documentfilters.IntegerDocumentFilter;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSet
extends DataSetView
implements PropertiesPage {
    private static final Logger LOG = LoggerFactory.getLogger(DataSet.class);
    private final JReportServer jreportServer;
    private ReportServer server;
    private final PropertyChangeListener configChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DataSet.this.configChanged();
        }
    };
    private DataSetEditorController dataSetEditorController;

    public DataSet(JReportServer jreportServer) {
        this.jreportServer = jreportServer;
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate((AbstractButton)this.btnDataSetApply);
        swingManager.translate((AbstractButton)this.btnDataSetCopyURL);
        swingManager.translate((AbstractButton)this.btnDataSetRemove);
        swingManager.translate(this.lblName);
        swingManager.translate(this.lblFilter);
        swingManager.translate(this.lblLimit);
        swingManager.translate(this.lblURL);
        swingManager.translate((AbstractButton)this.chkDataSetExposeGeometry);
        swingManager.translate((AbstractButton)this.rdoUseAnExpression);
        swingManager.translate((AbstractButton)this.rdoUseAllFeatures);
        swingManager.translate((AbstractButton)this.rdoUseCurrentSelectionInLayer);
        swingManager.translate((AbstractButton)this.rdoUseFeaturesInDataSet);
        this.dataSetEditorController = new DataSetEditorController(this.server, this.txtDataSetName, this.txtDatasetURL, this.btnDataSetCopyURL, this.txtDataSetLimit, this.txtDataSetFilter, this.btnDataSetFilter, this.chkDataSetExposeGeometry, this.rdoUseAllFeatures, this.rdoUseFeaturesInDataSet, this.rdoUseCurrentSelectionInLayer, this.rdoUseAnExpression, this.btnDataSetApply);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                DataSet.this.fetch(DataSet.this.server);
            }
        });
        this.btnDataSetRemove.setEnabled(false);
        this.btnDataSetRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSet.this.doDataSetRemove();
            }
        });
        this.lstDataSets.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                DataSet.this.doDataSetsSeleccionChanged();
            }
        });
        this.setPreferredSize(new Dimension(300, 420));
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        String iconName = FilenameUtils.getBaseName((String)imageName);
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        if (theme.exists(iconName)) {
            return theme.get(iconName);
        }
        LOG.warn("Can't find icon '" + iconName + "'.");
        return super.loadImage(imageName);
    }

    private void doDataSetsSeleccionChanged() {
        this.btnDataSetRemove.setEnabled(!this.lstDataSets.isSelectionEmpty());
        String datasetName = (String)this.lstDataSets.getSelectedValue();
        if (datasetName == null) {
            this.dataSetEditorController.clear();
            this.dataSetEditorController.setEnabled(false);
            this.btnDataSetRemove.setEnabled(false);
            return;
        }
        ReportDataSet dataset = this.getConfig().getDataset(datasetName);
        this.dataSetEditorController.put(dataset);
        this.dataSetEditorController.setEnabled(true);
        this.btnDataSetRemove.setEnabled(true);
    }

    private void doDataSetRemove() {
        int index = this.lstDataSets.getSelectedIndex();
        String dataSetName = (String)this.lstDataSets.getSelectedValue();
        if (dataSetName == null) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.lstDataSets.getModel();
        model.removeElement(dataSetName);
        this.server.getConfig().getDatasets().remove(dataSetName);
        if (index >= model.size()) {
            index = model.size() - 1;
        }
        if (index >= 0) {
            this.lstDataSets.setSelectedIndex(index);
        }
    }

    public void setData(Object data) {
        this.setServer((ReportServer)data);
    }

    public void setServer(ReportServer server) {
        if (this.server != null) {
            this.server.getConfig().removePropertyChangeListener(this.configChangeListener);
        }
        this.server = server;
        if (server == null) {
            this.clearComponents();
            this.setEnabledComponents(false);
        } else {
            DefaultListModel<String> model1 = new DefaultListModel<String>();
            ReportServerConfig config = this.getConfig();
            if (config != null && this.getConfig().getDatasets() != null) {
                for (ReportDataSet dataset : this.getConfig().getDatasets()) {
                    model1.addElement(dataset.getName());
                }
            }
            this.lstDataSets.setModel(model1);
            this.dataSetEditorController.clear();
            this.dataSetEditorController.setEnabled(false);
            this.getConfig().addPropertyChangeListener(this.configChangeListener);
        }
        this.dataSetEditorController.setServer(this.server);
    }

    private void configChanged() {
        this.setServer(this.server);
    }

    public ReportServerConfig getConfig() {
        if (this.getServer() == null) {
            return null;
        }
        return this.getServer().getConfig();
    }

    private void fetch(ReportServer server) {
        String datasetName = (String)this.lstDataSets.getSelectedValue();
        if (datasetName == null) {
            return;
        }
        ReportDataSet dataset = this.getConfig().getDataset(datasetName);
        this.dataSetEditorController.fetch(dataset);
    }

    private void clearComponents() {
        this.lstDataSets.setModel(new DefaultListModel());
        this.dataSetEditorController.clear();
    }

    private void setEnabledComponents(boolean enabled) {
        this.lstDataSets.setEnabled(enabled);
        this.btnDataSetRemove.setEnabled(enabled);
        this.dataSetEditorController.setEnabled(enabled);
    }

    public ReportServer getServer() {
        return this.server;
    }

    public JComponent asJComponent() {
        return this;
    }

    public String getTitle() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        return i18n.getTranslation("_Data_sets");
    }

    public int getPriority() {
        return 800;
    }

    public boolean whenAccept() {
        return this.whenApply();
    }

    public boolean whenApply() {
        this.fetch(this.server);
        return true;
    }

    public boolean whenCancel() {
        return true;
    }

    private static class DataSetEditorController {
        private ReportDataSet dataSet;
        private ReportServer server;
        private final JTextField txtName;
        private final JTextField txtURL;
        private final JButton btnCopyURL;
        private final JTextField txtLimit;
        private final JButton btnFilter;
        private final JTextField txtFilter;
        private final JButton btnApply;
        private final JCheckBox chkExposeGeometry;
        private final JRadioButton rdoUseAnExpression;
        private final JRadioButton rdoUseAllFeatures;
        private final JRadioButton rdoUseFeaturesInDataSet;
        private final JRadioButton rdoUseCurrentSelectionInLayer;
        private ExpressionPickerController pickerFilter;
        private FeatureStoreElement filterStoreElement;

        private DataSetEditorController(ReportServer server, JTextField txtName, JTextField txtURL, JButton btnCopyURL, JTextField txtLimit, JTextField txtFilter, JButton btnFilter, JCheckBox chkDataSetExposeGeometry, JRadioButton rdoUseAllFeatures, JRadioButton rdoUseFeaturesInDataSet, JRadioButton rdoUseCurrentSelectionInLayer, JRadioButton rdoUseAnExpression, JButton btnApply) {
            this.server = server;
            this.txtName = txtName;
            this.txtURL = txtURL;
            this.btnCopyURL = btnCopyURL;
            this.txtLimit = txtLimit;
            this.txtFilter = txtFilter;
            this.btnFilter = btnFilter;
            this.chkExposeGeometry = chkDataSetExposeGeometry;
            this.rdoUseAllFeatures = rdoUseAllFeatures;
            this.rdoUseFeaturesInDataSet = rdoUseFeaturesInDataSet;
            this.rdoUseCurrentSelectionInLayer = rdoUseCurrentSelectionInLayer;
            this.rdoUseAnExpression = rdoUseAnExpression;
            this.btnApply = btnApply;
            this.initComponents();
        }

        private void setServer(ReportServer server) {
            this.server = server;
        }

        private void initComponents() {
            ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
            toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtName);
            toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtURL);
            toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtLimit);
            this.btnFilter.setText("");
            this.pickerFilter = ExpressionEvaluatorSwingLocator.getManager().createExpressionPickerController((JTextComponent)this.txtFilter, this.btnFilter);
            this.filterStoreElement = DALSwingLocator.getSwingManager().createFeatureStoreElement();
            this.pickerFilter.getConfig().addElement((Element)this.filterStoreElement);
            this.rdoUseAnExpression.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    this.doUseExpressionChanged();
                }
            });
            this.btnCopyURL.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.doDatasetCopyURL();
                }
            });
            this.btnApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.doApply();
                }
            });
            IntegerDocumentFilter.install((JTextField)this.txtLimit);
        }

        public void doApply() {
            this.fetch(this.dataSet);
        }

        public void setEnabled(boolean enabled) {
            this.pickerFilter.setEnabled(enabled);
            this.btnApply.setEnabled(enabled);
            this.btnCopyURL.setEnabled(enabled);
            this.txtLimit.setEnabled(enabled);
            this.txtName.setEnabled(enabled);
            this.txtURL.setEnabled(enabled);
            this.chkExposeGeometry.setEnabled(enabled);
            this.rdoUseAllFeatures.setEnabled(enabled);
            this.rdoUseAnExpression.setEnabled(enabled);
            this.rdoUseCurrentSelectionInLayer.setEnabled(enabled);
            if (this.dataSet != null && this.dataSet.getSelectionOfFeatures().isEmpty()) {
                this.rdoUseFeaturesInDataSet.setEnabled(false);
            } else {
                this.rdoUseFeaturesInDataSet.setEnabled(enabled);
            }
        }

        public boolean isEnabled() {
            return this.btnApply.isEnabled();
        }

        public void clear() {
            this.txtLimit.setText("");
            this.txtName.setText("");
            this.txtURL.setText("");
            this.pickerFilter.set(null);
            this.chkExposeGeometry.setSelected(false);
        }

        public void doFilterClear() {
            this.pickerFilter.set(null);
        }

        public void put(ReportDataSet dataSet) {
            this.dataSet = dataSet;
            if (dataSet == null) {
                this.clear();
                return;
            }
            String limit = String.valueOf(dataSet.getLimit());
            this.txtLimit.setText(limit);
            this.txtName.setText(StringUtils.defaultString((String)dataSet.getName()));
            this.txtURL.setText(this.server.getURL(dataSet.getURLPath()).toString());
            this.chkExposeGeometry.setSelected(dataSet.getExposeGeometry());
            this.pickerFilter.set((Object)dataSet.getFilter());
            this.filterStoreElement.setFeatureStore(dataSet.getStore());
            if (dataSet.getSelectionOfFeatures().isEmpty()) {
                this.rdoUseFeaturesInDataSet.setEnabled(false);
                this.rdoUseFeaturesInDataSet.setSelected(false);
                if (!ExpressionUtils.isPhraseEmpty((Expression)dataSet.getFilter())) {
                    this.rdoUseAnExpression.setSelected(true);
                } else {
                    this.rdoUseAllFeatures.setSelected(true);
                }
            } else {
                this.rdoUseFeaturesInDataSet.setEnabled(true);
                this.rdoUseFeaturesInDataSet.setSelected(true);
            }
        }

        public void fetch(final ReportDataSet dataSet) {
            if (dataSet == null) {
                return;
            }
            dataSet.setName(this.txtName.getText());
            int limit = IntegerDocumentFilter.getValue((JTextField)this.txtLimit);
            dataSet.setLimit(limit);
            dataSet.setName(this.txtName.getText());
            dataSet.setExposeGeometry(this.chkExposeGeometry.isSelected());
            if (this.rdoUseAllFeatures.isSelected()) {
                dataSet.getSelectionOfFeatures().clear();
                dataSet.setFilter(null);
            } else if (this.rdoUseFeaturesInDataSet.isSelected()) {
                dataSet.setFilter(null);
            } else if (this.rdoUseAnExpression.isSelected()) {
                dataSet.getSelectionOfFeatures().clear();
                dataSet.setFilter(this.pickerFilter.get());
            } else if (this.rdoUseCurrentSelectionInLayer.isSelected()) {
                final boolean theEnabled = this.isEnabled();
                Thread th = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            dataSet.getSelectionOfFeatures().clear();
                            dataSet.getSelectionOfFeatures().addStoreSelection();
                        }
                        catch (Throwable throwable) {
                            SwingUtilities.invokeLater(new Runnable(this){
                                final /* synthetic */ 4 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    this.this$1.this.setEnabled(this.this$1.theEnabled);
                                    rdoUseFeaturesInDataSet.setSelected(true);
                                }
                            });
                            throw throwable;
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                }, "ReportDataSet-setFeatures");
                this.setEnabled(false);
                th.start();
            }
        }

        private void doUseExpressionChanged() {
            boolean enabled = this.rdoUseAnExpression.isSelected();
            if (!this.isEnabled()) {
                enabled = false;
            }
            this.pickerFilter.setEnabled(enabled);
        }

        private void doDatasetCopyURL() {
            String s = this.txtURL.getText();
            if (StringUtils.isEmpty((CharSequence)s)) {
                return;
            }
            Clipboard.copy(s);
        }
    }
}

