/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.h2;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.GeometryExpressionBuilderHelper;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.resource.exception.AccessResourceException;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.spi.DataServerExplorerProviderServices;
import org.gvsig.fmap.dal.spi.DataTransactionServices;
import org.gvsig.fmap.dal.store.h2.H2SpatialConnectionParameters;
import org.gvsig.fmap.dal.store.h2.H2SpatialExplorer;
import org.gvsig.fmap.dal.store.h2.H2SpatialExplorerParameters;
import org.gvsig.fmap.dal.store.h2.H2SpatialNewStoreParameters;
import org.gvsig.fmap.dal.store.h2.H2SpatialSQLBuilder;
import org.gvsig.fmap.dal.store.h2.H2SpatialStoreParameters;
import org.gvsig.fmap.dal.store.h2.H2SpatialUtils;
import org.gvsig.fmap.dal.store.h2.H2Utils;
import org.gvsig.fmap.dal.store.h2.functions.Json_value;
import org.gvsig.fmap.dal.store.h2.functions.Reverse;
import org.gvsig.fmap.dal.store.h2.functions.Reverseinstr;
import org.gvsig.fmap.dal.store.h2.operations.H2SpatialOperationsFactory;
import org.gvsig.fmap.dal.store.jdbc.JDBCConnectionParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCNewStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.exception.JDBCDriverClassNotFoundException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.AbstractConnectionProvider;
import org.gvsig.fmap.dal.store.jdbc2.spi.ConnectionProvider;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCConnectionBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCHelperBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.SRSSolverDumb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2SpatialHelper
extends JDBCHelperBase {
    protected static final Logger LOGGER = LoggerFactory.getLogger(H2SpatialHelper.class);
    public static final String H2SPATIAL_JDBC_DRIVER = "org.h2.Driver";
    private ConnectionProvider connectionProvider = null;

    public H2SpatialHelper(JDBCConnectionParameters connectionParameters, ConnectionProvider connectionProvider) {
        super(connectionParameters);
        this.srssolver = new SRSSolverDumb((JDBCHelper)this);
        this.connectionProvider = connectionProvider;
    }

    public H2SpatialHelper(JDBCConnectionParameters connectionParameters) {
        super(connectionParameters);
        this.srssolver = new SRSSolverDumb((JDBCHelper)this);
    }

    public void shutdown() {
        try {
            try {
                this.getConnection();
            }
            catch (Throwable th) {
                LOGGER.debug("Can't get connection-provider", th);
            }
            if (this.connectionProvider != null) {
                ((H2SpatialConnectionProvider)this.connectionProvider).shutdown();
                this.connectionProvider = null;
            }
            H2SpatialUtils.server_stop();
        }
        catch (Throwable ex) {
            LOGGER.warn("Problems shutdown H2", ex);
        }
    }

    private void logConnectionStatus(String msg, Connection conn) {
        ConnectionProvider cp = this.getConnectionProvider();
        StringBuilder builder = new StringBuilder();
        builder.append(msg);
        if (conn == null) {
            builder.append(": connection null");
        } else {
            Boolean closed = null;
            try {
                closed = conn.isClosed();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            builder.append(": connection ");
            builder.append(JDBCUtils.getConnId((Connection)conn));
            if (closed.booleanValue()) {
                builder.append(" (c)");
            }
            builder.append(" ");
        }
        builder.append(cp.getStatus());
        LOGGER.info(builder.toString());
    }

    public ConnectionProvider getConnectionProvider() {
        if (this.connectionProvider == null) {
            H2SpatialConnectionParameters connectionParameters = this.getConnectionParameters();
            if (connectionParameters == null) {
                return null;
            }
            this.connectionProvider = new H2SpatialConnectionProvider(connectionParameters);
            H2SpatialUtils.addGlobalConnection(this.connectionProvider);
        }
        return this.connectionProvider;
    }

    public synchronized JDBCConnection getConnection() throws AccessResourceException {
        try {
            H2SpatialConnectionParameters connectionParameters = this.getConnectionParameters();
            JDBCConnection conn = (JDBCConnection)DataTransactionServices.getConnection((DataTransactionServices)this.getTransaction(), (String)this.getConnectionProviderKey(connectionParameters));
            if (conn != null) {
                H2SpatialUtils.useConnection(this.getConnectionProvider(), connectionParameters);
                return conn;
            }
            JDBCConnectionBase connection = new JDBCConnectionBase(this.getTransaction(), this.getConnectionProvider().getConnection(), this.getConnectionProviderKey(connectionParameters));
            H2SpatialUtils.useConnection(this.getConnectionProvider(), connectionParameters);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[" + JDBCUtils.getConnId((Connection)connection.get()) + "] getConnection " + this.getConnectionProvider().getStatus() + " " + this.getConnectionProvider().toString());
            }
            return connection;
        }
        catch (SQLException ex) {
            throw new AccessResourceException("H2Spatial", (Throwable)ex);
        }
    }

    public H2SpatialConnectionParameters getConnectionParameters() {
        return (H2SpatialConnectionParameters)super.getConnectionParameters();
    }

    public String getConnectionURL() {
        return H2SpatialUtils.getConnectionURL(this.getConnectionParameters());
    }

    protected String getResourceType() {
        return "H2Spatial";
    }

    public String getProviderName() {
        return "H2Spatial";
    }

    public JDBCSQLBuilderBase createSQLBuilder() {
        return new H2SpatialSQLBuilder(this);
    }

    public OperationsFactory getOperations() {
        if (this.operationsFactory == null) {
            this.operationsFactory = new H2SpatialOperationsFactory((JDBCHelper)this);
        }
        return this.operationsFactory;
    }

    public GeometryExpressionBuilderHelper.GeometrySupportType getGeometrySupportType() {
        return GeometryExpressionBuilderHelper.GeometrySupportType.WKB;
    }

    public boolean hasSpatialFunctions() {
        return true;
    }

    public boolean canWriteGeometry(int geometryType, int geometrySubtype) {
        return true;
    }

    public String getQuoteForIdentifiers() {
        return "\"";
    }

    public boolean allowAutomaticValues() {
        return true;
    }

    public boolean supportOffsetInSelect() {
        return true;
    }

    public String getQuoteForStrings() {
        return "'";
    }

    public String getSourceId(JDBCStoreParameters parameters) {
        File f;
        H2SpatialStoreParameters params = (H2SpatialStoreParameters)parameters;
        StringBuilder builder = new StringBuilder();
        builder.append(params.getTable());
        builder.append("(");
        boolean needComma = false;
        if (StringUtils.isNotBlank((CharSequence)params.getHost())) {
            builder.append("host=");
            builder.append(params.getHost());
            needComma = true;
        }
        if (params.getPort() > 0) {
            if (needComma) {
                builder.append(", ");
            }
            builder.append("port=");
            builder.append(params.getPort());
            needComma = true;
        }
        if (StringUtils.isNotBlank((CharSequence)params.getDBName())) {
            if (needComma) {
                builder.append(", ");
            }
            builder.append("db=");
            builder.append(params.getDBName());
            needComma = true;
        }
        if (StringUtils.isNotBlank((CharSequence)params.getSchema())) {
            if (needComma) {
                builder.append(", ");
            }
            builder.append("schema=");
            builder.append(params.getSchema());
            needComma = true;
        }
        if ((f = params.getFile()) != null) {
            if (needComma) {
                builder.append(", ");
            }
            builder.append("file=");
            builder.append(params.getFile().getAbsolutePath());
        }
        builder.append(")");
        return builder.toString();
    }

    public JDBCNewStoreParameters createNewStoreParameters() {
        return new H2SpatialNewStoreParameters();
    }

    public JDBCStoreParameters createOpenStoreParameters() {
        return new H2SpatialStoreParameters();
    }

    public JDBCServerExplorerParameters createServerExplorerParameters() {
        return new H2SpatialExplorerParameters();
    }

    public JDBCServerExplorer createServerExplorer(JDBCServerExplorerParameters parameters, DataServerExplorerProviderServices providerServices) throws InitializeException {
        H2SpatialExplorer explorer = new H2SpatialExplorer(parameters, providerServices, (JDBCHelper)this);
        this.initialize((ResourceConsumer)explorer, (JDBCConnectionParameters)parameters, null);
        return explorer;
    }

    public String getConnectionProviderStatus() {
        return this.getConnectionProvider().getStatus();
    }

    public JDBCStoreParameters createOpenStoreParameters(JDBCServerExplorerParameters parameters) {
        JDBCStoreParameters p = super.createOpenStoreParameters(parameters);
        if (StringUtils.isBlank((CharSequence)p.getCatalog())) {
            p.setCatalog(StringUtils.upperCase((String)p.getDBName()));
        }
        return p;
    }

    public static class H2SpatialConnectionProvider
    extends AbstractConnectionProvider
    implements ConnectionProvider {
        private static boolean needRegisterDriver = true;
        private BasicDataSource dataSource = null;
        private H2SpatialConnectionParameters connectionParameters;

        public H2SpatialConnectionProvider(H2SpatialConnectionParameters connectionParameters) {
            this.connectionParameters = connectionParameters;
        }

        public H2SpatialConnectionParameters getConnectionParameters() {
            return this.connectionParameters;
        }

        public String getStatus() {
            if (this.dataSource == null) {
                return "Not using pool.";
            }
            StringBuilder builder = new StringBuilder();
            builder.append("Pool: ");
            builder.append(JDBCUtils.getHexId((Object)this.dataSource));
            builder.append(" Actives: ");
            builder.append(this.dataSource.getNumActive());
            builder.append("/");
            builder.append(this.dataSource.getMaxActive());
            builder.append(" idle: ");
            builder.append(this.dataSource.getNumIdle());
            builder.append("/");
            builder.append(this.dataSource.getMinIdle());
            builder.append(":");
            builder.append(this.dataSource.getMaxIdle());
            return builder.toString();
        }

        public void shutdown() {
            LOGGER.info("Shutdown H2 connection.");
            try {
                Connection conn = this.getConnection();
                conn.createStatement().execute("CHECKPOINT SYNC");
                conn.createStatement().execute("ANALYZE");
                conn.createStatement().execute("SHUTDOWN COMPACT");
                conn.close();
                LOGGER.info("Shutdown completed.");
            }
            catch (Throwable th) {
                LOGGER.warn("Problems shutdown the database.", th);
            }
            this.closeDataSource();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(" url=").append(this.connectionParameters.getUrl());
            builder.append(" driver name=").append(this.connectionParameters.getJDBCDriverClassName());
            builder.append(" user=").append(this.connectionParameters.getUser());
            return builder.toString();
        }

        public synchronized Connection getConnection() throws SQLException {
            String[] sqls;
            File f = H2SpatialUtils.getLocalFile(this.connectionParameters);
            boolean newdb = f != null && !f.exists();
            Connection conn = DriverManager.getConnection(this.connectionParameters.getUrl(), this.connectionParameters.getUser(), this.connectionParameters.getPassword());
            H2SpatialUtils.server_start(this.connectionParameters.getServerPortAsString(), this.connectionParameters.getServerAllowOthers());
            try {
                conn.createStatement().execute("SELECT TOP 1 SRID FROM SPATIAL_REF_SYS");
            }
            catch (SQLException ex) {
                H2Utils.LoadH2Spatial(conn);
            }
            for (String sql : sqls = new String[]{"CREATE SCHEMA IF NOT EXISTS PUBLIC;SET SCHEMA PUBLIC", Json_value.getSQL(), Reverse.getSQL(), Reverseinstr.getSQL()}) {
                try {
                    conn.createStatement().execute(sql);
                }
                catch (SQLException ex) {
                    LOGGER.debug("Can't configure gvsig tables.", (Throwable)ex);
                    LOGGER.warn("Can't configure gvsig tables. " + sql);
                }
            }
            if (newdb) {
                String[] sqls2;
                for (String sql : sqls2 = new String[]{"CREATE CACHED TABLE PUBLIC.\"GVSIGD_RESOURCES\"(\"name\" VARCHAR(150) NOT NULL, \"resource\" BLOB DEFAULT NULL)", "ALTER TABLE PUBLIC.\"GVSIGD_RESOURCES\" ADD CONSTRAINT PUBLIC.CONSTRAINT_E PRIMARY KEY(\"name\")", "CREATE CACHED TABLE PUBLIC.\"GVSIGD_CONFIG\"(\"name\" VARCHAR(200) NOT NULL, \"value\" CLOB DEFAULT NULL)", "ALTER TABLE PUBLIC.\"GVSIGD_CONFIG\" ADD CONSTRAINT PUBLIC.CONSTRAINT_2 PRIMARY KEY(\"name\")"}) {
                    try {
                        conn.createStatement().execute(sql);
                    }
                    catch (SQLException ex) {
                        LOGGER.debug("Can't configure gvsig tables.", (Throwable)ex);
                        LOGGER.warn("Can't configure gvsig tables. " + sql);
                    }
                }
            }
            return conn;
        }

        private BasicDataSource createDataSource() throws SQLException {
            if (!this.isRegistered()) {
                this.registerDriver();
            }
            H2SpatialConnectionParameters params = this.connectionParameters;
            BasicDataSource ds = new BasicDataSource();
            ds.setDriverClassName(params.getJDBCDriverClassName());
            if (!StringUtils.isEmpty((CharSequence)params.getUser())) {
                ds.setUsername(params.getUser());
            }
            if (!StringUtils.isEmpty((CharSequence)params.getPassword())) {
                ds.setPassword(params.getPassword());
            }
            ds.setUrl(params.getUrl());
            ds.setMaxWait(60000L);
            int sidle = this.connectionParameters.getMaxSecondsIdle();
            if (sidle < 0) {
                ds.setTimeBetweenEvictionRunsMillis(-1L);
                ds.setMinEvictableIdleTimeMillis(30000L);
            } else {
                ds.setTimeBetweenEvictionRunsMillis((long)(sidle * 1000));
                ds.setMinEvictableIdleTimeMillis((long)(sidle * 1000));
            }
            ds.setMinIdle(0);
            ds.setMaxIdle(20);
            return ds;
        }

        private boolean isRegistered() {
            return needRegisterDriver;
        }

        public void registerDriver() throws SQLException {
            String className = this.connectionParameters.getJDBCDriverClassName();
            if (className == null) {
                return;
            }
            try {
                Class<?> theClass = Class.forName(className);
                if (theClass == null) {
                    throw new JDBCDriverClassNotFoundException("H2Spatial", className);
                }
            }
            catch (Exception e) {
                throw new SQLException("Can't register JDBC driver '" + className + "'.", e);
            }
            needRegisterDriver = false;
        }

        public void dispose() {
            this.closeDataSource();
            this.connectionParameters = null;
        }

        private void closeDataSource() {
            try {
                if (this.dataSource != null) {
                    LOGGER.info("Clossing connection pool.");
                    LOGGER.info(this.getStatus());
                    this.dataSource.close();
                    this.dataSource = null;
                    LOGGER.info("Connection pool closed.");
                    LOGGER.info(this.getStatus());
                }
            }
            catch (Throwable th) {
                LOGGER.warn("Problems closing connections pool.", th);
            }
        }

        public boolean isDisposed() {
            return this.connectionParameters == null;
        }
    }
}

